/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism.trait.heat;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import com.lowdragmc.mbd2.integration.mekanism.MekanismHeatRecipeCapability;
import com.lowdragmc.mbd2.integration.mekanism.trait.heat.MekHeatCapabilityTrait;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

@LDLRegister(name="mek_heat_container", group="trait", modID="mekanism")
public class MekHeatCapabilityTraitDefinition
extends SimpleCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.mek_heat_container.capacity")
    @NumberRange(range={1.0, 1.7976931348623157E308})
    private double capacity = 1.0;
    @Configurable(name="config.definition.trait.mek_heat_container.min_temp_display", tips={"config.definition.trait.mek_heat_container.min_temp_display.tooltip.0", "config.definition.trait.mek_heat_container.min_temp_display.tooltip.1"})
    @NumberRange(range={-1.7976931348623157E308, 1.7976931348623157E308})
    private double minTempDisplay = 0.0;
    @Configurable(name="config.definition.trait.mek_heat_container.max_temp_display", tips={"config.definition.trait.mek_heat_container.max_temp_display.tooltip.0", "config.definition.trait.mek_heat_container.max_temp_display.tooltip.1"})
    @NumberRange(range={-1.7976931348623157E308, 1.7976931348623157E308})
    private double maxTempDisplay = 600.0;
    @Configurable(name="config.definition.trait.mek_heat_container.inverse_conduction", tips={"config.definition.trait.mek_heat_container.inverse_conduction.tooltip"})
    @NumberRange(range={1.0, 1.7976931348623157E308})
    private double inverseConduction = 1.0;
    @Configurable(name="config.definition.trait.mek_heat_container.simulate_environment", tips={"config.definition.trait.mek_heat_container.simulate_environment.tooltip"})
    private boolean simulateEnvironment = false;
    @Configurable(name="config.definition.trait.auto_io", subConfigurable=true, tips={"config.definition.trait.mek_heat_container.auto_io.tooltip"})
    private final ToggleAutoIO autoIO = new ToggleAutoIO();

    @Override
    public SimpleCapabilityTrait createTrait(MBDMachine machine) {
        return new MekHeatCapabilityTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new ItemStack[]{MekanismBlocks.RESISTIVE_HEATER.getItemStack()});
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        String prefix = this.uiPrefixName();
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 15, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)MekanismHeatRecipeCapability.HUD_BAR));
        energyBar.setBackground(new IGuiTexture[]{MekanismHeatRecipeCapability.HUD_BACKGROUND});
        energyBar.setId(prefix);
        TextTextureWidget energyBarText = new TextTextureWidget(5, 3, 90, 10).setText("0K").textureStyle(texture -> texture.setDropShadow(true));
        energyBarText.setId(prefix + "_text");
        ui.addWidget((Widget)energyBar);
        ui.addWidget((Widget)energyBarText);
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof MekHeatCapabilityTrait) {
            MekHeatCapabilityTrait heatTrait = (MekHeatCapabilityTrait)trait;
            String prefix = this.uiPrefixName();
            double range = this.maxTempDisplay - this.minTempDisplay;
            WidgetUtils.widgetByIdForEach(group, "^%s$".formatted(prefix), ProgressWidget.class, energyBar -> {
                energyBar.setProgressSupplier(() -> Mth.m_14008_((double)((heatTrait.container.getTemperature(0) - this.minTempDisplay) / range), (double)0.0, (double)1.0));
                energyBar.setDynamicHoverTips(value -> LocalizationUtils.format((String)"config.definition.trait.mek_heat_container.ui_container_hover", (Object[])new Object[]{Math.round(range * value), range}));
            });
            WidgetUtils.widgetByIdForEach(group, "^%s_text$".formatted(prefix), TextTextureWidget.class, energyBarText -> energyBarText.setText(() -> Component.m_237113_((String)"%.1fK".formatted(heatTrait.container.getTotalTemperature()))));
        }
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
    }

    public void setMinTempDisplay(double minTempDisplay) {
        this.minTempDisplay = minTempDisplay;
    }

    public void setMaxTempDisplay(double maxTempDisplay) {
        this.maxTempDisplay = maxTempDisplay;
    }

    public void setInverseConduction(double inverseConduction) {
        this.inverseConduction = inverseConduction;
    }

    public void setSimulateEnvironment(boolean simulateEnvironment) {
        this.simulateEnvironment = simulateEnvironment;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public double getMinTempDisplay() {
        return this.minTempDisplay;
    }

    public double getMaxTempDisplay() {
        return this.maxTempDisplay;
    }

    public double getInverseConduction() {
        return this.inverseConduction;
    }

    public boolean isSimulateEnvironment() {
        return this.simulateEnvironment;
    }

    public ToggleAutoIO getAutoIO() {
        return this.autoIO;
    }
}

