/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism.trait.chemical;

import com.google.common.base.Predicates;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoIO;
import com.lowdragmc.mbd2.common.trait.IAutoIOTrait;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.integration.mekanism.trait.chemical.ChemicalHandlerList;
import com.lowdragmc.mbd2.integration.mekanism.trait.chemical.ChemicalStorage;
import com.lowdragmc.mbd2.integration.mekanism.trait.chemical.ChemicalStorageWrapper;
import com.lowdragmc.mbd2.integration.mekanism.trait.chemical.ChemicalTankCapabilityTraitDefinition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public abstract class ChemicalTankCapabilityTrait<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>>
extends SimpleCapabilityTrait
implements IRecipeHandlerTrait<STACK>,
ICapabilityProviderTrait<HANDLER>,
IAutoIOTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ChemicalTankCapabilityTrait.class);
    @Persisted
    @DescSynced
    public final ChemicalStorage<CHEMICAL, STACK>[] storages = this.createStorages();
    protected boolean allowSameFluids;
    private Boolean isEmpty;

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public ChemicalTankCapabilityTrait(MBDMachine machine, ChemicalTankCapabilityTraitDefinition<CHEMICAL, STACK> definition) {
        super(machine, definition);
    }

    @Override
    public ChemicalTankCapabilityTraitDefinition<CHEMICAL, STACK> getDefinition() {
        return (ChemicalTankCapabilityTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        if (this.storages.length > 0) {
            Object stack = ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).recipeCapability.createDefaultContent();
            stack.setAmount((long)(((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getCapacity() / 2));
            this.storages[0].setStackUnchecked((ChemicalStack)stack);
        }
    }

    @Override
    @Nullable
    public AutoIO getAutoIO() {
        return ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getAutoIO().isEnable() ? ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getAutoIO() : null;
    }

    @Override
    public void handleAutoIO(BlockPos port, Direction side, IO io) {
        if (io.support(IO.IN)) {
            this.importToTarget(this.mergeContents(this.storages), Long.MAX_VALUE, ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getChemicalFilterSettings().isEnable() ? stack -> ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getChemicalFilterSettings().test(stack.getType()) : Predicates.alwaysTrue(), this.getMachine().getLevel(), port.m_121945_(side), side.m_122424_());
        }
        if (io.support(IO.OUT)) {
            this.exportToTarget(this.mergeContents(this.storages), Long.MAX_VALUE, (Predicate<STACK>)Predicates.alwaysTrue(), this.getMachine().getLevel(), port.m_121945_(side), side.m_122424_());
        }
    }

    public abstract HANDLER mergeContents(ChemicalStorage<CHEMICAL, STACK>[] var1);

    public void exportToTarget(HANDLER source, long maxAmount, Predicate<STACK> filter, Level level, BlockPos pos, @Nullable Direction direction) {
        Optional cap;
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (cap = blockEntity.getCapability(this.getCapability(), direction).resolve()).isPresent()) {
            IChemicalHandler target = (IChemicalHandler)cap.get();
            for (int srcIndex = 0; srcIndex < source.getTanks(); ++srcIndex) {
                ChemicalStack currentChemical = source.getChemicalInTank(srcIndex);
                if (currentChemical.isEmpty() || !filter.test(currentChemical)) continue;
                ChemicalStack toDrain = currentChemical.copy();
                toDrain.setAmount(maxAmount);
                ChemicalStack extracted = source.extractChemical(toDrain, Action.SIMULATE);
                long filled = extracted.getAmount() - target.insertChemical(extracted, Action.SIMULATE).getAmount();
                if (filled > 0L) {
                    maxAmount -= filled;
                    toDrain = currentChemical.copy();
                    toDrain.setAmount(filled);
                    target.insertChemical(source.extractChemical(toDrain, Action.EXECUTE), Action.EXECUTE);
                }
                if (maxAmount > 0L) continue;
                return;
            }
        }
    }

    public void importToTarget(HANDLER target, long maxAmount, Predicate<STACK> filter, Level level, BlockPos pos, @Nullable Direction direction) {
        Optional cap;
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (cap = blockEntity.getCapability(this.getCapability(), direction).resolve()).isPresent()) {
            IChemicalHandler source = (IChemicalHandler)cap.get();
            for (int srcIndex = 0; srcIndex < source.getTanks(); ++srcIndex) {
                ChemicalStack currentChemical = source.getChemicalInTank(srcIndex);
                if (currentChemical.isEmpty() || !filter.test(currentChemical)) continue;
                ChemicalStack toDrain = currentChemical.copy();
                toDrain.setAmount(maxAmount);
                ChemicalStack extracted = source.extractChemical(toDrain, Action.SIMULATE);
                long filled = extracted.getAmount() - target.insertChemical(extracted, Action.SIMULATE).getAmount();
                if (filled > 0L) {
                    maxAmount -= filled;
                    toDrain = currentChemical.copy();
                    toDrain.setAmount(filled);
                    target.insertChemical(source.extractChemical(toDrain, Action.EXECUTE), Action.EXECUTE);
                }
                if (maxAmount > 0L) continue;
                return;
            }
        }
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this);
    }

    protected ChemicalStorage<CHEMICAL, STACK>[] createStorages() {
        ChemicalStorage[] storages = new ChemicalStorage[((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getTankSize()];
        for (int i = 0; i < storages.length; ++i) {
            storages[i] = this.createStorage();
            storages[i].setOnContentsChanged(this::onContentsChanged);
        }
        return storages;
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public RecipeCapability<STACK> getRecipeCapability() {
        return ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getRecipeCapability();
    }

    @Override
    public List<STACK> handleRecipeInner(IO io, MBDRecipe recipe, List<STACK> left, @Nullable String slotName, boolean simulate) {
        ChemicalStorage<CHEMICAL, STACK>[] capabilities;
        if (!this.compatibleWith(io)) {
            return left;
        }
        for (ChemicalStorage<CHEMICAL, STACK> capability : capabilities = simulate ? (ChemicalStorage[])Arrays.stream(this.storages).map(ChemicalStorage::copy).toArray(ChemicalStorage[]::new) : this.storages) {
            Iterator<STACK> iterator = left.iterator();
            if (io == IO.IN) {
                while (iterator.hasNext()) {
                    chemicalStack = (ChemicalStack)iterator.next();
                    if (chemicalStack.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    boolean found = false;
                    ChemicalStack foundStack = null;
                    for (int i = 0; i < capability.getTanks(); ++i) {
                        ChemicalStack stored = capability.getChemicalInTank(i);
                        if (!chemicalStack.isTypeEqual(stored)) continue;
                        found = true;
                        foundStack = stored;
                    }
                    if (!found) continue;
                    ChemicalStack copied = foundStack.copy();
                    copied.setAmount(chemicalStack.getAmount());
                    ChemicalStack drained = capability.extractChemical(copied, Action.EXECUTE);
                    chemicalStack.setAmount(chemicalStack.getAmount() - drained.getAmount());
                    if (chemicalStack.getAmount() > 0L) continue;
                    iterator.remove();
                }
            } else if (io == IO.OUT) {
                while (iterator.hasNext()) {
                    chemicalStack = (ChemicalStack)iterator.next();
                    if (chemicalStack.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    ChemicalStack remaining = capability.insertChemical(chemicalStack.copy(), Action.EXECUTE);
                    if (!chemicalStack.isEmpty()) {
                        chemicalStack.setAmount(remaining.getAmount());
                    }
                    if (!chemicalStack.isEmpty()) continue;
                    iterator.remove();
                }
            }
            if (left.isEmpty()) break;
        }
        return left.isEmpty() ? null : left;
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (ChemicalStorage<CHEMICAL, STACK> storage : this.storages) {
                if (storage.getStack().isEmpty()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public abstract ChemicalStorage<CHEMICAL, STACK> createStorage();

    public void setAllowSameFluids(boolean allowSameFluids) {
        this.allowSameFluids = allowSameFluids;
    }

    public static class Slurry
    extends ChemicalTankCapabilityTrait<mekanism.api.chemical.slurry.Slurry, SlurryStack, ISlurryHandler> {
        public Slurry(MBDMachine machine, ChemicalTankCapabilityTraitDefinition<mekanism.api.chemical.slurry.Slurry, SlurryStack> definition) {
            super(machine, definition);
        }

        @Override
        public ISlurryHandler mergeContents(ChemicalStorage<mekanism.api.chemical.slurry.Slurry, SlurryStack>[] storages) {
            return new ChemicalHandlerList.Slurry((IChemicalHandler<mekanism.api.chemical.slurry.Slurry, SlurryStack>[])storages);
        }

        @Override
        public ChemicalStorage<mekanism.api.chemical.slurry.Slurry, SlurryStack> createStorage() {
            return new ChemicalStorage.Slurry((long)((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getCapacity(), chemical -> ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getChemicalFilterSettings().test(chemical), null);
        }

        @Override
        public Capability<ISlurryHandler> getCapability() {
            return Capabilities.SLURRY_HANDLER;
        }

        @Override
        public ISlurryHandler getCapContent(IO capbilityIO) {
            return new ChemicalStorageWrapper.Slurry(this.storages, capbilityIO);
        }

        @Override
        public ISlurryHandler mergeContents(List<ISlurryHandler> contents) {
            return new ChemicalHandlerList.Slurry((IChemicalHandler[])contents.toArray(new ISlurryHandler[0]));
        }
    }

    public static class Pigment
    extends ChemicalTankCapabilityTrait<mekanism.api.chemical.pigment.Pigment, PigmentStack, IPigmentHandler> {
        public Pigment(MBDMachine machine, ChemicalTankCapabilityTraitDefinition<mekanism.api.chemical.pigment.Pigment, PigmentStack> definition) {
            super(machine, definition);
        }

        @Override
        public IPigmentHandler mergeContents(ChemicalStorage<mekanism.api.chemical.pigment.Pigment, PigmentStack>[] storages) {
            return new ChemicalHandlerList.Pigment((IChemicalHandler<mekanism.api.chemical.pigment.Pigment, PigmentStack>[])storages);
        }

        @Override
        public ChemicalStorage<mekanism.api.chemical.pigment.Pigment, PigmentStack> createStorage() {
            return new ChemicalStorage.Pigment((long)((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getCapacity(), chemical -> ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getChemicalFilterSettings().test(chemical), null);
        }

        @Override
        public Capability<IPigmentHandler> getCapability() {
            return Capabilities.PIGMENT_HANDLER;
        }

        @Override
        public IPigmentHandler getCapContent(IO capbilityIO) {
            return new ChemicalStorageWrapper.Pigment(this.storages, capbilityIO);
        }

        @Override
        public IPigmentHandler mergeContents(List<IPigmentHandler> contents) {
            return new ChemicalHandlerList.Pigment((IChemicalHandler[])contents.toArray(new IPigmentHandler[0]));
        }
    }

    public static class Infuse
    extends ChemicalTankCapabilityTrait<InfuseType, InfusionStack, IInfusionHandler> {
        public Infuse(MBDMachine machine, ChemicalTankCapabilityTraitDefinition<InfuseType, InfusionStack> definition) {
            super(machine, definition);
        }

        @Override
        public IInfusionHandler mergeContents(ChemicalStorage<InfuseType, InfusionStack>[] storages) {
            return new ChemicalHandlerList.Infuse((IChemicalHandler<InfuseType, InfusionStack>[])storages);
        }

        @Override
        public ChemicalStorage<InfuseType, InfusionStack> createStorage() {
            return new ChemicalStorage.Infuse((long)((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getCapacity(), chemical -> ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getChemicalFilterSettings().test(chemical), null);
        }

        @Override
        public Capability<IInfusionHandler> getCapability() {
            return Capabilities.INFUSION_HANDLER;
        }

        @Override
        public IInfusionHandler getCapContent(IO capbilityIO) {
            return new ChemicalStorageWrapper.Infuse(this.storages, capbilityIO);
        }

        @Override
        public IInfusionHandler mergeContents(List<IInfusionHandler> contents) {
            return new ChemicalHandlerList.Infuse((IChemicalHandler[])contents.toArray(new IInfusionHandler[0]));
        }
    }

    public static class Gas
    extends ChemicalTankCapabilityTrait<mekanism.api.chemical.gas.Gas, GasStack, IGasHandler> {
        public Gas(MBDMachine machine, ChemicalTankCapabilityTraitDefinition<mekanism.api.chemical.gas.Gas, GasStack> definition) {
            super(machine, definition);
        }

        @Override
        public IGasHandler mergeContents(ChemicalStorage<mekanism.api.chemical.gas.Gas, GasStack>[] storages) {
            return new ChemicalHandlerList.Gas((IChemicalHandler<mekanism.api.chemical.gas.Gas, GasStack>[])storages);
        }

        @Override
        public ChemicalStorage<mekanism.api.chemical.gas.Gas, GasStack> createStorage() {
            return new ChemicalStorage.Gas((long)((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getCapacity(), chemical -> ((ChemicalTankCapabilityTraitDefinition)this.getDefinition()).getChemicalFilterSettings().test(chemical), null);
        }

        @Override
        public Capability<IGasHandler> getCapability() {
            return Capabilities.GAS_HANDLER;
        }

        @Override
        public IGasHandler getCapContent(IO capbilityIO) {
            return new ChemicalStorageWrapper.Gas(this.storages, capbilityIO);
        }

        @Override
        public IGasHandler mergeContents(List<IGasHandler> contents) {
            return new ChemicalHandlerList.Gas((IChemicalHandler[])contents.toArray(new IGasHandler[0]));
        }
    }
}

