/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism.trait.chemical;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IToggleConfigurable;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.integration.mekanism.MekanismChemicalRecipeCapability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class ChemicalFilterSettings<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IPersistedSerializable,
IToggleConfigurable,
Predicate<CHEMICAL> {
    @Persisted
    private boolean enable;
    @Configurable(name="config.definition.trait.filter.whitelist")
    private boolean isWhitelist = true;
    @NumberRange(range={1.0, 1.0})
    private List<CHEMICAL> filterChemicals = new ArrayList<CHEMICAL>();
    @Configurable(name="config.definition.trait.filter.chemical_tags", forceUpdate=false)
    private List<ResourceLocation> filterTags = new ArrayList<ResourceLocation>();
    private final ChemicalTags<CHEMICAL> chemicalTags;
    private final MekanismChemicalRecipeCapability<CHEMICAL, STACK> recipeCapability;

    public ChemicalFilterSettings(ChemicalTags<CHEMICAL> chemicalTags, MekanismChemicalRecipeCapability<CHEMICAL, STACK> recipeCapability) {
        this.chemicalTags = chemicalTags;
        this.recipeCapability = recipeCapability;
    }

    @Override
    public boolean test(CHEMICAL chemical) {
        if (!this.enable) {
            return true;
        }
        for (Chemical filterChemical : this.filterChemicals) {
            if (filterChemical != chemical) continue;
            return this.isWhitelist;
        }
        for (ResourceLocation filterTag : this.filterTags) {
            if (!chemical.is(this.chemicalTags.tag(filterTag))) continue;
            return this.isWhitelist;
        }
        return !this.isWhitelist;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ArrayConfiguratorGroup arrayGroup = new ArrayConfiguratorGroup("config.definition.trait.filter.chemicals", true, () -> this.filterChemicals, (getter, setter) -> {
            ConfiguratorGroup configuratorGroup = new ConfiguratorGroup("");
            this.recipeCapability.createContentConfigurator(configuratorGroup, () -> this.lambda$buildConfigurator$1((Supplier)getter), stack -> setter.accept(stack.getType()));
            return configuratorGroup;
        }, true);
        arrayGroup.setOnAdd(chemical -> this.filterChemicals.add(chemical));
        arrayGroup.setOnRemove(chemical -> this.filterChemicals.remove(chemical));
        arrayGroup.setAddDefault(this.recipeCapability::createDefaultChemical);
        arrayGroup.setOnUpdate(list -> {
            this.filterChemicals.clear();
            this.filterChemicals.addAll((Collection<CHEMICAL>)list);
        });
        father.addConfigurators(new Configurator[]{arrayGroup});
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        ListTag chemicals = new ListTag();
        for (Chemical filterChemical : this.filterChemicals) {
            CompoundTag nbt = new CompoundTag();
            ChemicalType.getTypeFor((Chemical)filterChemical).write(nbt);
            filterChemical.write(nbt);
            chemicals.add((Object)nbt);
        }
        tag.m_128365_("filterChemicals", (Tag)chemicals);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.filterChemicals.clear();
        ListTag chemicals = nbt.m_128437_("filterChemicals", 10);
        for (int i = 0; i < chemicals.size(); ++i) {
            CompoundTag tag = chemicals.m_128728_(i);
            ChemicalType type = ChemicalType.fromNBT((CompoundTag)tag);
            Gas stack = null;
            if (type == ChemicalType.GAS) {
                stack = Gas.readFromNBT((CompoundTag)tag);
            } else if (type == ChemicalType.INFUSION) {
                stack = InfuseType.readFromNBT((CompoundTag)tag);
            } else if (type == ChemicalType.PIGMENT) {
                stack = Pigment.readFromNBT((CompoundTag)tag);
            } else if (type == ChemicalType.SLURRY) {
                stack = Slurry.readFromNBT((CompoundTag)tag);
            }
            if (stack == null) continue;
            this.filterChemicals.add(stack);
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    public void setWhitelist(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public List<CHEMICAL> getFilterChemicals() {
        return this.filterChemicals;
    }

    public void setFilterChemicals(List<CHEMICAL> filterChemicals) {
        this.filterChemicals = filterChemicals;
    }

    public List<ResourceLocation> getFilterTags() {
        return this.filterTags;
    }

    public void setFilterTags(List<ResourceLocation> filterTags) {
        this.filterTags = filterTags;
    }

    private /* synthetic */ ChemicalStack lambda$buildConfigurator$1(Supplier getter) {
        return (ChemicalStack)this.recipeCapability.createStack.apply((Chemical)getter.get(), 1L);
    }
}

