/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.kubejs.events;

import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.recipe.event.FuelRecipeUIEvent;
import com.lowdragmc.mbd2.api.recipe.event.RecipeTypeEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineClientTickEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineCustomDataUpdateEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineCustomKeyframeEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineEvent;
import com.lowdragmc.mbd2.integration.kubejs.events.MBDMachineEvents;
import com.lowdragmc.mbd2.integration.kubejs.events.MBDRecipeTypeEvents;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.Extra;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface MBDClientEvents {
    public static final Map<Class<? extends MachineEvent>, Function<MachineEvent, EventResult>> machineEventHandlers = new HashMap<Class<? extends MachineEvent>, Function<MachineEvent, EventResult>>();
    public static final Map<Class<? extends RecipeTypeEvent>, Function<RecipeTypeEvent, EventResult>> recipeTypeEventHandlers = new HashMap<Class<? extends RecipeTypeEvent>, Function<RecipeTypeEvent, EventResult>>();
    public static final EventHandler CLIENT_TICK = MBDClientEvents.registerMachineEvent("onClientTick", MachineClientTickEvent.class, MBDMachineEvents.MachineClientTickEventJS.class, MBDMachineEvents.MachineClientTickEventJS::new);
    public static final EventHandler CUSTOM_DATA_UPDATE = MBDClientEvents.registerMachineEvent("onCustomDataUpdate", MachineCustomDataUpdateEvent.class, MBDMachineEvents.MachineCustomDataUpdateEventJS.class, MBDMachineEvents.MachineCustomDataUpdateEventJS::new);
    @Nullable
    public static final EventHandler CUSTOM_KEYFRAME = MBDClientEvents.createCustomKeyframeEvent();
    public static final EventHandler RECIPE_UI = MBDClientEvents.registerRecipeTypeEvent("onRecipeUI", RecipeTypeEvent.class, MBDRecipeTypeEvents.RecipeUIEventJS.class, MBDRecipeTypeEvents.RecipeUIEventJS::new);
    public static final EventHandler FUEL_RECIPE_UI = MBDClientEvents.registerRecipeTypeEvent("onFuelRecipeUI", FuelRecipeUIEvent.class, MBDRecipeTypeEvents.FuelRecipeUIEventJS.class, MBDRecipeTypeEvents.FuelRecipeUIEventJS::new);

    public static EventHandler createCustomKeyframeEvent() {
        if (MBD2.isGeckolibLoaded()) {
            return MBDClientEvents.registerMachineEvent("onCustomKeyframe", MachineCustomKeyframeEvent.class, MBDMachineEvents.MachineCustomKeyframeEventJS.class, MBDMachineEvents.MachineCustomKeyframeEventJS::new);
        }
        return null;
    }

    public static void init() {
    }

    public static <E extends MachineEvent> EventHandler registerMachineEvent(String name, Class<E> eventClass, Class<? extends MBDMachineEvents.MachineEventJS<E>> eventJSClass, Function<E, MBDMachineEvents.MachineEventJS<E>> eventJSFactory) {
        EventHandler handler = MBDMachineEvents.MBD_MACHINE_EVENTS.client(name, () -> eventJSClass).extra(Extra.ID);
        machineEventHandlers.put(eventClass, event -> handler.post((EventJS)eventJSFactory.apply(event), (Object)event.machine.getDefinition().id()));
        return handler;
    }

    public static <E extends RecipeTypeEvent> EventHandler registerRecipeTypeEvent(String name, Class<? extends RecipeTypeEvent> eventClass, Class<? extends MBDRecipeTypeEvents.RecipeTypeEventJS<E>> eventJSClass, Function<E, MBDRecipeTypeEvents.RecipeTypeEventJS<E>> eventJSFactory) {
        EventHandler handler = MBDRecipeTypeEvents.MBD_RECIPE_TYPE_EVENTS.server(name, () -> eventJSClass).extra(Extra.ID);
        recipeTypeEventHandlers.put(eventClass, event -> handler.post((EventJS)eventJSFactory.apply(event), (Object)event.recipeType.getRegistryName()));
        return handler;
    }

    public static EventResult postMachineEvent(MachineEvent machineEvent) {
        return Optional.ofNullable(machineEventHandlers.get(((Object)((Object)machineEvent)).getClass())).map(handler -> (EventResult)handler.apply(machineEvent)).orElse(EventResult.PASS);
    }

    public static EventResult postRecipeTypeEvent(RecipeTypeEvent recipeTypeEvent) {
        return Optional.ofNullable(recipeTypeEventHandlers.get(((Object)((Object)recipeTypeEvent)).getClass())).map(handler -> (EventResult)handler.apply(recipeTypeEvent)).orElse(EventResult.PASS);
    }
}

