/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.jade;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ProgressElement;
import snownee.jade.impl.ui.ProgressStyle;

public class RecipeLogicProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig config) {
        if (IMachine.ofMachine(blockAccessor.getBlockEntity()).isEmpty()) {
            return;
        }
        CompoundTag data = blockAccessor.getServerData();
        if (data.m_128441_("recipe_logic")) {
            data = data.m_128469_("recipe_logic");
            String status = data.m_128461_("status");
            tooltip.add((Component)Component.m_237115_((String)("recipe_logic.status." + status.toLowerCase())));
            BoxStyle boxStyle = new BoxStyle();
            boxStyle.borderColor = ColorPattern.GRAY.color;
            boxStyle.borderWidth = 1.0f;
            if (data.m_128441_("duration")) {
                int progress = data.m_128451_("progress");
                int duration = data.m_128451_("duration");
                tooltip.add(tooltip.getElementHelper().progress((float)progress * 1.0f / (float)duration, (Component)Component.m_237113_((String)"%.2fs / %.2fs".formatted(Float.valueOf((float)progress / 20.0f), Float.valueOf((float)duration / 20.0f))).m_130940_(ChatFormatting.WHITE), new ProgressStyle().color(ColorPattern.GREEN.color), (IBoxStyle)boxStyle, true));
            }
            if (data.m_128441_("fuel")) {
                int fuel = data.m_128451_("fuel");
                int maxFuel = data.m_128451_("maxFuel");
                tooltip.add((IElement)new ProgressElement((float)fuel * 1.0f / (float)maxFuel, (Component)Component.m_237113_((String)"%.2f / %.2f ".formatted(Float.valueOf((float)fuel / 20.0f), Float.valueOf((float)maxFuel / 20.0f))).m_130940_(ChatFormatting.WHITE), new ProgressStyle().color(ColorPattern.ORANGE.color), (IBoxStyle)boxStyle, true));
            }
            if (data.m_128441_("waitingReason")) {
                MutableComponent reason = Component.Serializer.m_130701_((String)data.m_128461_("waitingReason"));
                tooltip.add((Component)reason);
            }
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        IMachine.ofMachine(blockAccessor.getBlockEntity()).ifPresent(machine -> {
            CompoundTag tag = new CompoundTag();
            if (!machine.runRecipeLogic()) {
                return;
            }
            RecipeLogic recipeLogic = machine.getRecipeLogic();
            tag.m_128359_("status", recipeLogic.getStatus().name());
            if (recipeLogic.getDuration() > 0) {
                tag.m_128405_("progress", recipeLogic.getProgress());
                tag.m_128405_("duration", recipeLogic.getDuration());
            }
            if (recipeLogic.needFuel()) {
                tag.m_128405_("fuel", recipeLogic.getFuelTime());
                tag.m_128405_("maxFuel", recipeLogic.getFuelMaxTime());
            }
            if (recipeLogic.isWaiting() && recipeLogic.getWaitingReason() != null) {
                tag.m_128359_("waitingReason", Component.Serializer.m_130703_((Component)recipeLogic.getWaitingReason()));
            }
            data.m_128365_("recipe_logic", (Tag)tag);
        });
    }

    public ResourceLocation getUid() {
        return MBD2.id("recipe_logic_provider");
    }
}

