/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.geckolib;

import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineCustomKeyframeEvent;
import com.lowdragmc.mbd2.integration.geckolib.Animation;
import com.lowdragmc.mbd2.integration.geckolib.GeckolibRenderer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class AnimatableMachine
implements GeoAnimatable {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this, (boolean)false);
    private final MBDMachine machine;
    private final GeckolibRenderer renderer;

    public AnimatableMachine(MBDMachine machine, GeckolibRenderer renderer) {
        this.machine = machine;
        this.renderer = renderer;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, state -> {
            String stateName;
            RawAnimation animation;
            if (this.renderer.scheduleStateAnimation && (animation = this.renderer.getRawAnimation(stateName = this.machine.getMachineState().name())) != null) {
                state.setAndContinue(animation);
            }
            return PlayState.STOP;
        });
        controller.setCustomInstructionKeyframeHandler(frame -> MinecraftForge.EVENT_BUS.post((Event)new MachineCustomKeyframeEvent(this.machine, (CustomInstructionKeyframeEvent<AnimatableMachine>)frame).postCustomEvent()));
        for (Animation animation : this.renderer.animations) {
            RawAnimation rawAnimation = this.renderer.getRawAnimation(animation.getName());
            if (rawAnimation == null) continue;
            controller.triggerableAnim(animation.getName(), rawAnimation);
        }
        controllers.add(new AnimationController[]{controller});
    }

    public double getTick(Object object) {
        return RenderUtils.getCurrentTick();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public MBDMachine getMachine() {
        return this.machine;
    }

    public GeckolibRenderer getRenderer() {
        return this.renderer;
    }
}

