/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.embers.trait;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import com.lowdragmc.mbd2.integration.embers.EmbersEmberRecipeCapability;
import com.lowdragmc.mbd2.integration.embers.trait.EmbersEmberCapabilityTrait;
import com.lowdragmc.mbd2.integration.embers.trait.EmbersEmberFancyRendererSettings;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import com.rekindled.embers.RegistryManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

@LDLRegister(name="embers_ember_capability", group="trait", modID="embers")
public class EmbersEmberCapabilityTraitDefinition
extends SimpleCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.embers_ember_capability.capacity")
    @NumberRange(range={1.0, 1.7976931348623157E308})
    private double capacity = 5000.0;
    @Configurable(name="config.definition.trait.auto_io", subConfigurable=true, tips={"config.definition.trait.embers_ember_capability.auto_io.tooltip"})
    private final ToggleAutoIO autoIO = new ToggleAutoIO();
    @Configurable(name="config.definition.trait.embers_ember_capability.fancy_renderer", subConfigurable=true, tips={"config.definition.trait.embers_ember_capability.fancy_renderer.tooltip"})
    private final EmbersEmberFancyRendererSettings fancyRendererSettings = new EmbersEmberFancyRendererSettings(this);

    @Override
    public EmbersEmberCapabilityTrait createTrait(MBDMachine machine) {
        return new EmbersEmberCapabilityTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{(Item)RegistryManager.EMBER_CRYSTAL.get()});
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public IRenderer getBESRenderer(IMachine machine) {
        return this.fancyRendererSettings.getFancyRenderer(machine);
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        String prefix = this.uiPrefixName();
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 10, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)EmbersEmberRecipeCapability.HUD_BAR));
        energyBar.setBackground(new IGuiTexture[]{EmbersEmberRecipeCapability.HUD_BACKGROUND});
        energyBar.setId(prefix);
        TextTextureWidget energyBarText = new TextTextureWidget(5, 0, 90, 10).setText("0/0 ember").textureStyle(textTexture -> textTexture.setDropShadow(true));
        energyBarText.setId(prefix + "_text");
        ui.addWidget((Widget)energyBar);
        ui.addWidget((Widget)energyBarText);
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof EmbersEmberCapabilityTrait) {
            EmbersEmberCapabilityTrait emberTrait = (EmbersEmberCapabilityTrait)trait;
            String prefix = this.uiPrefixName();
            WidgetUtils.widgetByIdForEach(group, "^%s$".formatted(prefix), ProgressWidget.class, energyBar -> {
                energyBar.setProgressSupplier(() -> emberTrait.storage.getEmber() / emberTrait.storage.getEmberCapacity());
                energyBar.setDynamicHoverTips(value -> LocalizationUtils.format((String)"config.definition.trait.embers_ember_capability.ui_container_hover", (Object[])new Object[]{Math.round(emberTrait.storage.getEmberCapacity() * value), emberTrait.storage.getEmberCapacity()}));
            });
            WidgetUtils.widgetByIdForEach(group, "^%s_text$".formatted(prefix), TextTextureWidget.class, energyBarText -> energyBarText.setText(() -> Component.m_237113_((String)(Math.round(emberTrait.storage.getEmber()) + "/" + emberTrait.storage.getEmberCapacity() + " ember"))));
        }
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
    }

    public ToggleAutoIO getAutoIO() {
        return this.autoIO;
    }
}

