/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create.machine;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.IRendererResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineConfigPanel;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.integration.create.machine.CreateKineticMachineDefinition;
import com.lowdragmc.mbd2.integration.create.machine.CreateMachineState;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.Create;
import java.io.File;
import java.util.Map;
import net.minecraft.world.phys.shapes.Shapes;

@LDLRegister(name="km", group="editor.machine", modID="create")
public class CraeteKinecticMachineProject
extends MachineProject {
    public static final IRenderer GEARBOX_RENDERER = new IModelRenderer(MBD2.id("block/gearbox"));
    public static final IModelRenderer SHAFT_RENDERER = new IModelRenderer(Create.asResource((String)"block/shaft"));
    private boolean isRotating = true;
    private float stress = 128.0f;

    public CraeteKinecticMachineProject(Resources resources, CreateKineticMachineDefinition definition, WidgetGroup ui) {
        super(resources, definition, ui);
    }

    public float getSpeed() {
        return Math.min(256.0f, this.stress / Math.max(this.getDefinition().kineticMachineSettings.torque(), Float.MIN_VALUE));
    }

    @Override
    protected Map<String, Resource<?>> createResources() {
        Map<String, Resource<?>> resources = super.createResources();
        Resource<?> resource = resources.get("ldlib.gui.editor.group.renderer");
        if (resource instanceof IRendererResource) {
            IRendererResource rendererResource = (IRendererResource)resource;
            rendererResource.addResource(Either.left((Object)"shaft"), (Object)new IModelRenderer(Create.asResource((String)"block/shaft")));
        }
        return resources;
    }

    @Override
    public CreateKineticMachineDefinition getDefinition() {
        return (CreateKineticMachineDefinition)super.getDefinition();
    }

    @Override
    protected CreateKineticMachineDefinition createDefinition() {
        CreateKineticMachineDefinition.Builder builder = CreateKineticMachineDefinition.builder();
        builder.id(MBD2.id("new_machine")).rootState((MachineState)CreateMachineState.builder().rotationRenderer(SHAFT_RENDERER).name("base").renderer(GEARBOX_RENDERER).shape(Shapes.m_83144_()).lightLevel(0).child((MachineState)CreateMachineState.builder().name("working").child((MachineState)CreateMachineState.builder().name("waiting").build()).build()).child((MachineState)CreateMachineState.builder().name("suspend").build()).build());
        return builder.build();
    }

    @Override
    public CraeteKinecticMachineProject newEmptyProject() {
        return new CraeteKinecticMachineProject(new Resources(this.createResources()), this.createDefinition(), this.createDefaultUI());
    }

    @Override
    public File getProjectWorkSpace(Editor editor) {
        return new File(editor.getWorkSpace(), "kinetic_machine");
    }

    @Override
    protected MachineConfigPanel createMachineConfigPanel(MachineEditor editor) {
        MachineConfigPanel panel = super.createMachineConfigPanel(editor);
        panel.addSwitch((IGuiTexture)Icons.ROTATION, null, "config.create_kinetic_machine.is_preview_rotating", this::isRotating, this::setRotating);
        panel.refreshButtonGroupPosition();
        WidgetGroup buttonGroup = panel.getButtonGroup();
        NumberConfigurator stressConfigurator = new NumberConfigurator("config.create_kinetic_machine.preview_stress", this::getStress, number -> this.setStress(number.floatValue()), (Number)Float.valueOf(this.getStress()), true);
        stressConfigurator.setRange((Number)0, (Number)Float.valueOf(Float.MAX_VALUE));
        stressConfigurator.setWheel((Number)1);
        stressConfigurator.init(200);
        stressConfigurator.setSelfPosition(buttonGroup.getSizeWidth() - 200, 25);
        buttonGroup.addWidget((Widget)stressConfigurator);
        buttonGroup.addWidget((Widget)new ImageWidget(buttonGroup.getSizeWidth() - 200 + 3, 50, 100, 10, (IGuiTexture)new TextTexture(() -> LocalizationUtils.format((String)"config.create_kinetic_machine.preview_speed", (Object[])new Object[]{Float.valueOf(this.getSpeed())})).setType(TextTexture.TextType.LEFT)));
        return panel;
    }

    public CraeteKinecticMachineProject() {
    }

    public boolean isRotating() {
        return this.isRotating;
    }

    public void setRotating(boolean isRotating) {
        this.isRotating = isRotating;
    }

    public float getStress() {
        return this.stress;
    }

    public void setStress(float stress) {
        this.stress = stress;
    }
}

