/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.ae2.trait;

import appeng.core.definitions.AEBlocks;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.ae2.trait.AEInterfaceSlotWidget;
import com.lowdragmc.mbd2.integration.ae2.trait.MEInterfaceTrait;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import net.minecraft.world.item.Item;

@LDLRegister(name="ae2_me_interface", group="trait", modID="ae2")
public class MEInterfaceTraitDefinition
extends SimpleCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.ae2_me_interface.slot_size")
    @NumberRange(range={1.0, 2.147483647E9})
    private int slotSize = 9;

    @Override
    public SimpleCapabilityTrait createTrait(MBDMachine machine) {
        return new MEInterfaceTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{AEBlocks.INTERFACE.m_5456_()});
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        double row = this.slotSize <= 9 ? (double)this.slotSize : Math.ceil(Math.sqrt(this.slotSize));
        String prefix = this.uiPrefixName();
        for (int i = 0; i < this.slotSize; ++i) {
            AEInterfaceSlotWidget slotWidget = new AEInterfaceSlotWidget();
            slotWidget.setSelfPosition(new Position(10 + i % (int)row * 18, 10 + i / (int)row * 72));
            slotWidget.initTemplate();
            slotWidget.setId(prefix + "_" + i);
            ui.addWidget((Widget)slotWidget);
        }
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof MEInterfaceTrait) {
            MEInterfaceTrait interfaceTrait = (MEInterfaceTrait)trait;
            String prefix = this.uiPrefixName();
            IO guiIO = this.getGuiIO();
            IngredientIO ingredientIO = guiIO == IO.IN ? IngredientIO.INPUT : (guiIO == IO.OUT ? IngredientIO.OUTPUT : (guiIO == IO.BOTH ? IngredientIO.BOTH : IngredientIO.RENDER_ONLY));
            WidgetUtils.widgetByIdForEach(group, "^%s_[0-9]+$".formatted(prefix), AEInterfaceSlotWidget.class, slotWidget -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slotWidget);
                if (index >= 0 && index < this.slotSize) {
                    slotWidget.setItemInterfaceLogic(interfaceTrait.getInterfaceLogic(), index);
                    slotWidget.setIngredientIO(ingredientIO);
                    slotWidget.setCanTakeItems(guiIO.support(IO.OUT));
                    slotWidget.setCanPutItems(guiIO.support(IO.IN));
                }
            });
        }
    }

    public int getSlotSize() {
        return this.slotSize;
    }

    public void setSlotSize(int slotSize) {
        this.slotSize = slotSize;
    }
}

