/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.item;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineTraitPanel;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoWorldIO;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import com.lowdragmc.mbd2.common.trait.item.ItemFancyRendererSettings;
import com.lowdragmc.mbd2.common.trait.item.ItemFilterSettings;
import com.lowdragmc.mbd2.common.trait.item.ItemSlotCapabilityTrait;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="item_slot", group="trait", priority=-100)
public class ItemSlotCapabilityTraitDefinition
extends SimpleCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.item_slot.slot_size", tips={"config.definition.trait.item_slot.slot_size.tooltip"})
    @NumberRange(range={1.0, 2.147483647E9})
    private int slotSize = 1;
    @Configurable(name="config.definition.trait.item_slot.slot_limit", tips={"config.definition.trait.item_slot.slot_limit.tooltip"})
    @NumberRange(range={1.0, 64.0})
    private int slotLimit = 64;
    @Configurable(name="config.definition.trait.item_slot.filter", subConfigurable=true, tips={"config.definition.trait.item_slot.filter.tooltip"})
    private final ItemFilterSettings itemFilterSettings = new ItemFilterSettings();
    @Configurable(name="config.definition.trait.auto_io", subConfigurable=true, tips={"config.definition.trait.item_slot.auto_io.tooltip"})
    private final ToggleAutoIO autoIO = new ToggleAutoIO();
    @Configurable(name="config.definition.trait.auto_world_io.input", subConfigurable=true, tips={"config.definition.trait.auto_world_io.input.tooltip"})
    private final AutoWorldIO autoInput = new AutoWorldIO();
    @Configurable(name="config.definition.trait.auto_world_io.output", subConfigurable=true, tips={"config.definition.trait.auto_world_io.output.tooltip"})
    private final AutoWorldIO autoOutput = new AutoWorldIO();
    @Configurable(name="config.definition.trait.item_slot.fancy_renderer", subConfigurable=true, tips={"config.definition.trait.item_slot.fancy_renderer.tooltip"})
    private final ItemFancyRendererSettings itemRendererSettings = new ItemFancyRendererSettings(this);

    @Override
    public ItemSlotCapabilityTrait createTrait(MBDMachine machine) {
        return new ItemSlotCapabilityTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{Items.f_42009_});
    }

    @Override
    public IRenderer getBESRenderer(IMachine machine) {
        return this.itemRendererSettings.getFancyRenderer(machine);
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        double row = Math.ceil(Math.sqrt(this.slotSize));
        String prefix = this.uiPrefixName();
        for (int i = 0; i < this.slotSize; ++i) {
            SlotWidget slotWidget = new SlotWidget();
            slotWidget.setSelfPosition(new Position(10 + i % (int)row * 18, 10 + i / (int)row * 18));
            slotWidget.initTemplate();
            slotWidget.setId(prefix + "_" + i);
            ui.addWidget((Widget)slotWidget);
        }
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof ItemSlotCapabilityTrait) {
            ItemSlotCapabilityTrait itemSlotTrait = (ItemSlotCapabilityTrait)trait;
            String prefix = this.uiPrefixName();
            IO guiIO = this.getGuiIO();
            IngredientIO ingredientIO = guiIO == IO.IN ? IngredientIO.INPUT : (guiIO == IO.OUT ? IngredientIO.OUTPUT : (guiIO == IO.BOTH ? IngredientIO.BOTH : IngredientIO.RENDER_ONLY));
            WidgetUtils.widgetByIdForEach(group, "^%s_[0-9]+$".formatted(prefix), SlotWidget.class, slotWidget -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slotWidget);
                if (index >= 0 && index < itemSlotTrait.storage.getSlots()) {
                    slotWidget.setHandlerSlot((IItemTransfer)itemSlotTrait.storage, index);
                    slotWidget.setIngredientIO(ingredientIO);
                    slotWidget.setCanTakeItems(guiIO.support(IO.OUT));
                    slotWidget.setCanPutItems(guiIO.support(IO.IN));
                }
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderAfterWorldInTraitPanel(MachineTraitPanel panel) {
        int color;
        super.renderAfterWorldInTraitPanel(panel);
        if (!this.autoInput.enable && !this.autoOutput.enable) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFunc((int)770, (int)771);
        poseStack.m_85836_();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172757_);
        buffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        RenderSystem.lineWidth((float)5.0f);
        if (this.autoOutput.enable) {
            color = -1153792;
            RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)this.autoOutput.range.f_82288_), (float)((float)this.autoOutput.range.f_82289_), (float)((float)this.autoOutput.range.f_82290_), (float)((float)this.autoOutput.range.f_82291_), (float)((float)this.autoOutput.range.f_82292_), (float)((float)this.autoOutput.range.f_82293_), (float)ColorUtils.red((int)color), (float)ColorUtils.green((int)color), (float)ColorUtils.blue((int)color), (float)ColorUtils.alpha((int)color));
        }
        if (this.autoInput.enable) {
            color = -15619346;
            RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)this.autoInput.range.f_82288_), (float)((float)this.autoInput.range.f_82289_), (float)((float)this.autoInput.range.f_82290_), (float)((float)this.autoInput.range.f_82291_), (float)((float)this.autoInput.range.f_82292_), (float)((float)this.autoInput.range.f_82293_), (float)ColorUtils.red((int)color), (float)ColorUtils.green((int)color), (float)ColorUtils.blue((int)color), (float)ColorUtils.alpha((int)color));
        }
        tessellator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    public int getSlotSize() {
        return this.slotSize;
    }

    public int getSlotLimit() {
        return this.slotLimit;
    }

    public ItemFilterSettings getItemFilterSettings() {
        return this.itemFilterSettings;
    }

    public ToggleAutoIO getAutoIO() {
        return this.autoIO;
    }

    public AutoWorldIO getAutoInput() {
        return this.autoInput;
    }

    public AutoWorldIO getAutoOutput() {
        return this.autoOutput;
    }

    public ItemFancyRendererSettings getItemRendererSettings() {
        return this.itemRendererSettings;
    }

    public void setSlotSize(int slotSize) {
        this.slotSize = slotSize;
    }

    public void setSlotLimit(int slotLimit) {
        this.slotLimit = slotLimit;
    }
}

