/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.item;

import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ItemHandlerWrapper
implements IItemHandlerModifiable {
    private final ItemStackTransfer storage;
    private final IO io;

    public ItemHandlerWrapper(ItemStackTransfer storage, IO io) {
        this.storage = storage;
        this.io = io;
    }

    private boolean canCapInput() {
        return this.io == IO.IN || this.io == IO.BOTH;
    }

    private boolean canCapOutput() {
        return this.io == IO.OUT || this.io == IO.BOTH;
    }

    public int getSlots() {
        return this.storage.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.storage.getStackInSlot(slot);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.storage.setStackInSlot(slot, stack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.canCapInput()) {
            return this.storage.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canCapOutput()) {
            return this.storage.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return this.storage.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.storage.isItemValid(slot, stack);
    }
}

