/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.item;

import java.util.Arrays;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public record ItemHandlerList(IItemHandler[] handlers) implements IItemHandlerModifiable
{
    public int getSlots() {
        return Arrays.stream(this.handlers).mapToInt(IItemHandler::getSlots).sum();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        int index = 0;
        for (IItemHandler handler : this.handlers) {
            if (slot - index < handler.getSlots()) {
                return handler.getStackInSlot(slot - index);
            }
            index += handler.getSlots();
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        int index = 0;
        for (IItemHandler handler : this.handlers) {
            if (slot - index < handler.getSlots()) {
                if (handler instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
                    modifiable.setStackInSlot(slot - index, stack);
                }
                return;
            }
            index += handler.getSlots();
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        int index = 0;
        for (IItemHandler handler : this.handlers) {
            if (slot - index < handler.getSlots()) {
                return handler.insertItem(slot - index, stack, simulate);
            }
            index += handler.getSlots();
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int index = 0;
        for (IItemHandler handler : this.handlers) {
            if (slot - index < handler.getSlots()) {
                return handler.extractItem(slot - index, amount, simulate);
            }
            index += handler.getSlots();
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        int index = 0;
        for (IItemHandler handler : this.handlers) {
            if (slot - index < handler.getSlots()) {
                return handler.getSlotLimit(slot - index);
            }
            index += handler.getSlots();
        }
        return 0;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        int index = 0;
        for (IItemHandler handler : this.handlers) {
            if (slot - index < handler.getSlots()) {
                return handler.isItemValid(slot - index, stack);
            }
            index += handler.getSlots();
        }
        return false;
    }
}

