/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.item;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IToggleConfigurable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.utils.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFilterSettings
implements IToggleConfigurable,
Predicate<ItemStack> {
    @Persisted
    private boolean enable;
    @Configurable(name="config.definition.trait.filter.whitelist")
    private boolean isWhitelist = true;
    @Configurable(name="config.definition.trait.filter.match_nbt")
    private boolean matchNBT = false;
    @Configurable(name="config.definition.trait.filter.items")
    private List<ItemStack> filterItems = new ArrayList<ItemStack>();
    @Configurable(name="config.definition.trait.filter.item_tags", forceUpdate=false)
    @DefaultValue(stringValue={"forge:ingots/iron"})
    private List<ResourceLocation> filterTags = new ArrayList<ResourceLocation>();

    @Override
    public boolean test(ItemStack itemStack) {
        if (!this.enable) {
            return true;
        }
        for (ItemStack filterItem : this.filterItems) {
            if (!(this.matchNBT ? ItemStack.m_150942_((ItemStack)filterItem, (ItemStack)itemStack) : ItemStack.m_41656_((ItemStack)filterItem, (ItemStack)itemStack))) continue;
            return this.isWhitelist;
        }
        for (ResourceLocation filterTag : this.filterTags) {
            if (!itemStack.m_204117_(TagUtil.optionalTag(ForgeRegistries.ITEMS.getRegistryKey(), filterTag))) continue;
            return this.isWhitelist;
        }
        return !this.isWhitelist;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    public void setWhitelist(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNBT) {
        this.matchNBT = matchNBT;
    }

    public List<ItemStack> getFilterItems() {
        return this.filterItems;
    }

    public void setFilterItems(List<ItemStack> filterItems) {
        this.filterItems = filterItems;
    }

    public List<ResourceLocation> getFilterTags() {
        return this.filterTags;
    }

    public void setFilterTags(List<ResourceLocation> filterTags) {
        this.filterTags = filterTags;
    }
}

