/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.forgeenergy;

import java.util.Arrays;
import net.minecraftforge.energy.IEnergyStorage;

public record EnergyStorageList(IEnergyStorage[] storages) implements IEnergyStorage
{
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = 0;
        for (IEnergyStorage storage : this.storages) {
            if ((received += storage.receiveEnergy(maxReceive - received, simulate)) >= maxReceive) break;
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = 0;
        for (IEnergyStorage storage : this.storages) {
            if ((extracted += storage.extractEnergy(maxExtract - extracted, simulate)) >= maxExtract) break;
        }
        return extracted;
    }

    public int getEnergyStored() {
        return Arrays.stream(this.storages).reduce(0, (acc, storage) -> acc + storage.getEnergyStored(), Integer::sum);
    }

    public int getMaxEnergyStored() {
        return Arrays.stream(this.storages).reduce(0, (acc, storage) -> acc + storage.getMaxEnergyStored(), Integer::sum);
    }

    public boolean canExtract() {
        return Arrays.stream(this.storages).anyMatch(IEnergyStorage::canExtract);
    }

    public boolean canReceive() {
        return Arrays.stream(this.storages).anyMatch(IEnergyStorage::canReceive);
    }
}

