/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class RedstoneSignalCondition
extends RecipeCondition {
    public static final RedstoneSignalCondition INSTANCE = new RedstoneSignalCondition();
    @Configurable(name="config.recipe.condition.redstone_signal.signal.min")
    @NumberRange(range={0.0, 15.0})
    private int minSignal;
    @Configurable(name="config.recipe.condition.redstone_signal.signal.max")
    @NumberRange(range={0.0, 15.0})
    private int maxSignal;

    public RedstoneSignalCondition(int minSignal, int maxSignal) {
        this.minSignal = minSignal;
        this.maxSignal = maxSignal;
    }

    @Override
    public String getType() {
        return "redstone_signal";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.redstone_signal.tooltip", (Object[])new Object[]{this.minSignal, this.maxSignal});
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{Items.f_41978_});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        BlockPos pos = recipeLogic.getMachine().getPos();
        int signal = recipeLogic.getMachine().getLevel().m_277086_(pos);
        return signal >= this.minSignal && signal <= this.maxSignal;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("minSignal", (Number)this.minSignal);
        config.addProperty("maxSignal", (Number)this.maxSignal);
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.minSignal = GsonHelper.m_13824_((JsonObject)config, (String)"minSignal", (int)0);
        this.maxSignal = GsonHelper.m_13824_((JsonObject)config, (String)"maxSignal", (int)1);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.minSignal = buf.m_130242_();
        this.maxSignal = buf.m_130242_();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130130_(this.minSignal);
        buf.m_130130_(this.maxSignal);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128405_("minSignal", this.minSignal);
        tag.m_128405_("maxSignal", this.maxSignal);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.minSignal = tag.m_128451_("minSignal");
        this.maxSignal = tag.m_128451_("maxSignal");
        return this;
    }

    public int getMinSignal() {
        return this.minSignal;
    }

    public int getMaxSignal() {
        return this.maxSignal;
    }

    public void setMinSignal(int minSignal) {
        this.minSignal = minSignal;
    }

    public void setMaxSignal(int maxSignal) {
        this.maxSignal = maxSignal;
    }

    public RedstoneSignalCondition() {
    }
}

