/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public class PositionYCondition
extends RecipeCondition {
    public static final PositionYCondition INSTANCE = new PositionYCondition();
    @Configurable(name="config.recipe.condition.pos_y.min")
    @NumberRange(range={-2.147483648E9, 2.147483647E9})
    private int min;
    @Configurable(name="config.recipe.condition.pos_y.max")
    @NumberRange(range={-2.147483648E9, 2.147483647E9})
    private int max;

    public PositionYCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public String getType() {
        return "pos_y";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.pos_y.tooltip", (Object[])new Object[]{this.min, this.max});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        int y = recipeLogic.machine.getPos().m_123342_();
        return y >= this.min && y <= this.max;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("min", (Number)this.min);
        config.addProperty("max", (Number)this.max);
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.min = GsonHelper.m_13824_((JsonObject)config, (String)"min", (int)Integer.MIN_VALUE);
        this.max = GsonHelper.m_13824_((JsonObject)config, (String)"max", (int)Integer.MAX_VALUE);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.min = buf.m_130242_();
        this.max = buf.m_130242_();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130130_(this.min);
        buf.m_130130_(this.max);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128405_("min", this.min);
        tag.m_128405_("max", this.max);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.min = tag.m_128451_("min");
        this.max = tag.m_128451_("max");
        return this;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public PositionYCondition() {
    }
}

