/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config.toggle;

import com.lowdragmc.lowdraglib.gui.editor.configurator.AABBConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ToggleShape
extends ToggleObject<VoxelShape>
implements ITagSerializable<CompoundTag> {
    public static final AABB BLOCK = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final List<AABB> aabbs = new ArrayList<AABB>();
    private VoxelShape value;

    public ToggleShape(VoxelShape value, boolean enable) {
        this.setValue(value);
        this.enable = enable;
    }

    public ToggleShape(VoxelShape value) {
        this(value, true);
    }

    public ToggleShape(boolean enable) {
        this(Shapes.m_83144_(), enable);
    }

    public ToggleShape() {
        this(false);
    }

    @Override
    public VoxelShape getValue() {
        if (this.value == null) {
            this.value = this.aabbs.stream().map(Shapes::m_83064_).reduce(Shapes.m_83040_(), Shapes::m_83110_);
        }
        return this.value;
    }

    @Override
    public void setValue(VoxelShape value) {
        this.value = null;
        this.aabbs.clear();
        this.aabbs.addAll(value.m_83299_());
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ArrayConfiguratorGroup shapeGroup = new ArrayConfiguratorGroup("shapes", false, () -> new ArrayList<AABB>(this.aabbs), (getter, setter) -> new AABBConfigurator("cube", getter, setter, BLOCK, true), true);
        shapeGroup.setAddDefault(() -> new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        shapeGroup.setOnAdd(this.aabbs::add);
        shapeGroup.setOnRemove(this.aabbs::remove);
        shapeGroup.setOnUpdate(list -> {
            this.aabbs.clear();
            this.aabbs.addAll((Collection<AABB>)list);
            this.value = null;
        });
        father.addConfigurators(new Configurator[]{shapeGroup});
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("enable", this.enable);
        ListTag shape = new ListTag();
        for (AABB aabb : this.aabbs) {
            CompoundTag aabbTag = new CompoundTag();
            aabbTag.m_128347_("minX", aabb.f_82288_);
            aabbTag.m_128347_("minY", aabb.f_82289_);
            aabbTag.m_128347_("minZ", aabb.f_82290_);
            aabbTag.m_128347_("maxX", aabb.f_82291_);
            aabbTag.m_128347_("maxY", aabb.f_82292_);
            aabbTag.m_128347_("maxZ", aabb.f_82293_);
            shape.add((Object)aabbTag);
        }
        tag.m_128365_("value", (Tag)shape);
        return tag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        this.enable = compoundTag.m_128471_("enable");
        this.aabbs.clear();
        ListTag shape = compoundTag.m_128437_("value", 10);
        for (Tag tag : shape) {
            CompoundTag aabbTag = (CompoundTag)tag;
            AABB aabb = new AABB(aabbTag.m_128459_("minX"), aabbTag.m_128459_("minY"), aabbTag.m_128459_("minZ"), aabbTag.m_128459_("maxX"), aabbTag.m_128459_("maxY"), aabbTag.m_128459_("maxZ"));
            this.aabbs.add(aabb);
        }
    }
}

