/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config.toggle;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IToggleConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.client.MachineSound;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ToggleMachineSound
implements IToggleConfigurable {
    @Persisted
    protected boolean enable;
    @Persisted
    private ResourceLocation sound = SoundEvents.f_11907_.m_11660_();
    @Configurable(name="config.machine_sound.source", tips={"config.machine_sound.source.tooltip"})
    private SoundSource soundSource = SoundSource.BLOCKS;
    @Configurable(name="config.machine_sound.loop", tips={"config.machine_sound.loop.tooltip"})
    private boolean loop = true;
    @Configurable(name="config.machine_sound.loop_with_shuffle", tips={"config.machine_sound.loop_with_shuffle.tooltip"})
    private boolean loopWithShuffle;
    @Configurable(name="config.machine_sound.delay", tips={"config.machine_sound.delay.tooltip"})
    @NumberRange(range={0.0, 2.147483647E9})
    private int delay = 0;
    @Configurable(name="config.machine_sound.volume", tips={"config.machine_sound.volume.tooltip"})
    @NumberRange(range={0.0, 100.0})
    private float volume = 1.0f;
    @Configurable(name="config.machine_sound.pitch", tips={"config.machine_sound.pitch.tooltip"})
    @NumberRange(range={0.0, 100.0})
    private float pitch = 1.0f;
    private SoundEvent soundEvent;

    public SoundEvent getSoundEvent() {
        if (this.soundEvent == null) {
            this.soundEvent = Optional.ofNullable((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.sound)).orElse(SoundEvents.f_271165_);
        }
        return this.soundEvent;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MachineSound createMachineSound(BlockPos pos, BooleanSupplier predicate) {
        return new MachineSound(this.getSoundEvent(), this.soundSource, predicate, pos, this.loop, this.loopWithShuffle, this.delay, this.volume, this.pitch);
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        father.addConfigurators(new Configurator[]{this.createSoundConfigurator("config.machine_sound.sound", this::setSound, this::getSound)});
        super.buildConfigurator(father);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Configurator createSoundConfigurator(String name, Consumer<ResourceLocation> setter, Supplier<ResourceLocation> getter) {
        return new SearchComponentConfigurator(name, getter, sound -> {
            setter.accept((ResourceLocation)sound);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(sound)), (float)this.pitch));
        }, (Object)SoundEvents.f_12447_.m_11660_(), true, (word, find) -> {
            for (ResourceLocation key : ForgeRegistries.SOUND_EVENTS.getKeys()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (!key.toString().contains(word.toLowerCase())) continue;
                find.accept(key);
            }
        }, Object::toString);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public ResourceLocation getSound() {
        return this.sound;
    }

    public SoundSource getSoundSource() {
        return this.soundSource;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public boolean isLoopWithShuffle() {
        return this.loopWithShuffle;
    }

    public int getDelay() {
        return this.delay;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setSound(ResourceLocation sound) {
        this.sound = sound;
    }

    public void setSoundSource(SoundSource soundSource) {
        this.soundSource = soundSource;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setLoopWithShuffle(boolean loopWithShuffle) {
        this.loopWithShuffle = loopWithShuffle;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setSoundEvent(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
    }
}

