/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config.event;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.mbd2.common.graphprocessor.GraphParameterGet;
import com.lowdragmc.mbd2.common.graphprocessor.GraphParameterSet;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineEvent;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

@LDLRegister(name="MachineDropsEvent", group="MachineEvent")
public class MachineDropsEvent
extends MachineEvent {
    @GraphParameterGet
    public final Entity entity;
    @GraphParameterGet(identity="drops.in")
    @GraphParameterSet(identity="drops.out")
    public List<ItemStack> drops;

    public MachineDropsEvent(MBDMachine machine, Entity entity, List<ItemStack> drops) {
        super(machine);
        this.entity = entity;
        this.drops = drops;
    }

    @Override
    public void bindParameters(Map<String, ExposedParameter> exposedParameters) {
        super.bindParameters(exposedParameters);
        Optional.ofNullable(exposedParameters.get("entity")).ifPresent(p -> p.setValue((Object)this.entity));
        Optional.ofNullable(exposedParameters.get("drops.in")).ifPresent(p -> p.setValue(this.drops));
    }

    @Override
    public void gatherParameters(Map<String, ExposedParameter> exposedParameters) {
        super.gatherParameters(exposedParameters);
        Optional.ofNullable(exposedParameters.get("drops.out")).ifPresent(p -> {
            Object patt1681$temp = p.getValue();
            if (patt1681$temp instanceof List) {
                List list = (List)patt1681$temp;
                if (list.isEmpty()) {
                    this.drops.clear();
                } else {
                    this.drops.clear();
                    for (Object o : list) {
                        if (!(o instanceof ItemStack)) continue;
                        ItemStack itemStack = (ItemStack)o;
                        this.drops.add(itemStack);
                    }
                }
            }
        });
    }

    public Entity getEntity() {
        return this.entity;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }
}

