/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config;

import com.lowdragmc.lowdraglib.gui.editor.accessors.EnumAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.api.block.RotationState;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MultiblockMachineProject;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.StateMachine;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigBlockProperties
implements IPersistedSerializable,
IConfigurable {
    @Configurable(name="config.block_properties.render_types", subConfigurable=true, tips={"config.block_properties.render_types.tooltip", "config.require_restart"})
    private final RenderTypes renderTypes;
    @Configurable(name="config.block_properties.use_ao", tips={"config.block_properties.use_ao.tooltip"})
    private boolean useAO;
    @Configurable(name="config.block_properties.rotation_state", tips={"config.block_properties.rotation_state.tooltip", "config.require_restart"})
    private RotationState rotationState;
    @Configurable(name="config.block_properties.has_collision", tips={"config.block_properties.has_collision.tooltip", "config.require_restart"})
    private boolean hasCollision;
    @Configurable(name="config.block_properties.can_occlude", tips={"config.block_properties.can_occlude.tooltip", "config.require_restart"})
    private boolean canOcclude;
    @Configurable(name="config.block_properties.ignited_by_lava", tips={"config.block_properties.ignited_by_lava.tooltip", "config.require_restart"})
    private boolean ignitedByLava;
    @Configurable(name="config.block_properties.is_air", tips={"config.block_properties.is_air.tooltip", "config.require_restart"})
    private boolean isAir;
    @Configurable(name="config.block_properties.is_suffocating", tips={"config.block_properties.is_suffocating.tooltip", "config.require_restart"})
    private boolean isSuffocating;
    @Configurable(name="config.block_properties.emissive", tips={"config.block_properties.emissive.tooltip", "config.require_restart"})
    private boolean emissive;
    @Configurable(name="config.block_properties.friction", tips={"config.block_properties.friction.tooltip", "config.require_restart"})
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float friction;
    @Configurable(name="config.block_properties.speed_factor", tips={"config.block_properties.speed_factor.tooltip", "config.require_restart"})
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float speedFactor;
    @Configurable(name="config.block_properties.jump_factor", tips={"config.block_properties.jump_factor.tooltip", "config.require_restart"})
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float jumpFactor;
    @Configurable(name="config.block_properties.destroy_time", tips={"config.block_properties.destroy_time.tooltip", "config.require_restart"})
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float destroyTime;
    @Configurable(name="config.block_properties.explosion_resistance", tips={"config.block_properties.explosion_resistance.tooltip", "config.require_restart"})
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float explosionResistance;
    @Configurable(name="config.block_properties.block_sound", subConfigurable=true)
    private BlockSound blockSound;
    @Configurable(name="config.block_properties.transparent", tips={"config.block_properties.transparent.tooltip"})
    private boolean transparent;
    @Configurable(name="config.block_properties.force_solid", tips={"config.block_properties.force_solid.tooltip", "config.require_restart"})
    private boolean forceSolid;
    @Configurable(name="config.block_properties.replaceable", tips={"config.block_properties.replaceable.tooltip", "config.require_restart"})
    private boolean replaceable;
    @Configurable(name="config.block_properties.no_particle_on_break", tips={"config.block_properties.no_particle_on_break.tooltip", "config.require_restart"})
    private boolean noParticleOnBreak;
    @Configurable(name="config.block_properties.can_be_waterlogged", tips={"config.block_properties.can_be_waterlogged.tooltip"})
    private boolean canBeWaterlogged;
    @Configurable(name="config.block_properties.collision_shape_full_block", tips={"config.block_properties.collision_shape_full_block.tooltip"})
    private boolean collisionShapeFullBlock;

    public void buildConfigurator(ConfiguratorGroup father) {
        MachineEditor editor;
        super.buildConfigurator(father);
        int index = 0;
        Editor editor2 = Editor.INSTANCE;
        if (editor2 instanceof MachineEditor && (editor = (MachineEditor)editor2).getCurrentProject() instanceof MultiblockMachineProject) {
            for (Configurator configurator : father.getConfigurators()) {
                if (configurator.getName().equals("config.block_properties.rotation_state") && configurator instanceof SelectorConfigurator) {
                    SelectorConfigurator selector = (SelectorConfigurator)configurator;
                    father.removeConfigurator((Configurator)selector);
                    SelectorConfigurator newSelector = new SelectorConfigurator("config.block_properties.rotation_state", () -> this.rotationState, r -> {
                        this.rotationState = r;
                    }, (Object)RotationState.NON_Y_AXIS, true, List.of(RotationState.NONE, RotationState.NON_Y_AXIS), EnumAccessor::getEnumName);
                    newSelector.setTips(new String[]{"config.block_properties.rotation_state.tooltip", "config.require_restart"});
                    father.addConfigurator(index, (Configurator)newSelector);
                    break;
                }
                ++index;
            }
        }
    }

    public BlockBehaviour.Properties apply(StateMachine<?> stateMachine, BlockBehaviour.Properties properties) {
        if (this.forceSolid) {
            properties = properties.m_280606_();
        }
        if (this.replaceable) {
            properties = properties.m_280170_();
        }
        if (this.noParticleOnBreak) {
            properties = properties.m_246721_();
        }
        if (this.hasCollision) {
            properties = properties.m_60955_();
        }
        if (!this.canOcclude) {
            properties = properties.m_60955_();
        }
        if (this.ignitedByLava) {
            properties = properties.m_278183_();
        }
        if (this.isAir) {
            properties = properties.m_60996_();
        }
        if (this.isSuffocating) {
            properties = properties.m_60960_((state, level, pos) -> true);
        }
        if (this.emissive) {
            properties = properties.m_60991_((state, level, pos) -> true);
        }
        properties = properties.m_60911_(this.friction);
        properties = properties.m_60956_(this.speedFactor);
        properties = properties.m_60967_(this.jumpFactor);
        properties = properties.m_155954_(this.destroyTime);
        properties = properties.m_155956_(this.explosionResistance);
        properties = properties.m_60918_((SoundType)this.blockSound.createSoundType());
        VoxelShape shape = null;
        for (MachineState state2 : stateMachine.states.values()) {
            VoxelShape stateShape = state2.getShape(Direction.NORTH);
            if (shape == null) {
                shape = stateShape;
                continue;
            }
            if (shape == stateShape) continue;
            properties.m_60988_();
            break;
        }
        if (shape != Shapes.m_83144_() || !shape.m_83281_()) {
            properties.m_60988_();
        }
        return properties;
    }

    private static RenderTypes $default$renderTypes() {
        return new RenderTypes();
    }

    private static boolean $default$useAO() {
        return true;
    }

    private static RotationState $default$rotationState() {
        return RotationState.NON_Y_AXIS;
    }

    private static boolean $default$hasCollision() {
        return true;
    }

    private static boolean $default$canOcclude() {
        return true;
    }

    private static boolean $default$ignitedByLava() {
        return false;
    }

    private static boolean $default$isAir() {
        return false;
    }

    private static boolean $default$isSuffocating() {
        return false;
    }

    private static boolean $default$emissive() {
        return false;
    }

    private static float $default$friction() {
        return 0.6f;
    }

    private static float $default$speedFactor() {
        return 1.0f;
    }

    private static float $default$jumpFactor() {
        return 1.0f;
    }

    private static float $default$destroyTime() {
        return 1.5f;
    }

    private static float $default$explosionResistance() {
        return 6.0f;
    }

    private static BlockSound $default$blockSound() {
        return new BlockSound();
    }

    private static boolean $default$transparent() {
        return false;
    }

    private static boolean $default$forceSolid() {
        return false;
    }

    private static boolean $default$replaceable() {
        return false;
    }

    private static boolean $default$noParticleOnBreak() {
        return false;
    }

    private static boolean $default$canBeWaterlogged() {
        return false;
    }

    private static boolean $default$collisionShapeFullBlock() {
        return false;
    }

    ConfigBlockProperties(RenderTypes renderTypes, boolean useAO, RotationState rotationState, boolean hasCollision, boolean canOcclude, boolean ignitedByLava, boolean isAir, boolean isSuffocating, boolean emissive, float friction, float speedFactor, float jumpFactor, float destroyTime, float explosionResistance, BlockSound blockSound, boolean transparent, boolean forceSolid, boolean replaceable, boolean noParticleOnBreak, boolean canBeWaterlogged, boolean collisionShapeFullBlock) {
        this.renderTypes = renderTypes;
        this.useAO = useAO;
        this.rotationState = rotationState;
        this.hasCollision = hasCollision;
        this.canOcclude = canOcclude;
        this.ignitedByLava = ignitedByLava;
        this.isAir = isAir;
        this.isSuffocating = isSuffocating;
        this.emissive = emissive;
        this.friction = friction;
        this.speedFactor = speedFactor;
        this.jumpFactor = jumpFactor;
        this.destroyTime = destroyTime;
        this.explosionResistance = explosionResistance;
        this.blockSound = blockSound;
        this.transparent = transparent;
        this.forceSolid = forceSolid;
        this.replaceable = replaceable;
        this.noParticleOnBreak = noParticleOnBreak;
        this.canBeWaterlogged = canBeWaterlogged;
        this.collisionShapeFullBlock = collisionShapeFullBlock;
    }

    public static ConfigBlockPropertiesBuilder builder() {
        return new ConfigBlockPropertiesBuilder();
    }

    public RenderTypes renderTypes() {
        return this.renderTypes;
    }

    public boolean useAO() {
        return this.useAO;
    }

    public RotationState rotationState() {
        return this.rotationState;
    }

    public boolean hasCollision() {
        return this.hasCollision;
    }

    public boolean canOcclude() {
        return this.canOcclude;
    }

    public boolean ignitedByLava() {
        return this.ignitedByLava;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public boolean isSuffocating() {
        return this.isSuffocating;
    }

    public boolean emissive() {
        return this.emissive;
    }

    public float friction() {
        return this.friction;
    }

    public float speedFactor() {
        return this.speedFactor;
    }

    public float jumpFactor() {
        return this.jumpFactor;
    }

    public float destroyTime() {
        return this.destroyTime;
    }

    public float explosionResistance() {
        return this.explosionResistance;
    }

    public BlockSound blockSound() {
        return this.blockSound;
    }

    public boolean transparent() {
        return this.transparent;
    }

    public boolean forceSolid() {
        return this.forceSolid;
    }

    public boolean replaceable() {
        return this.replaceable;
    }

    public boolean noParticleOnBreak() {
        return this.noParticleOnBreak;
    }

    public boolean canBeWaterlogged() {
        return this.canBeWaterlogged;
    }

    public boolean collisionShapeFullBlock() {
        return this.collisionShapeFullBlock;
    }

    public static class BlockSound
    implements IPersistedSerializable,
    IConfigurable {
        @Configurable(name="config.block_properties.block_sound.volume", tips={"config.require_restart"})
        @NumberRange(range={0.0, 3.4028234663852886E38})
        private float volumeIn = 1.0f;
        @Configurable(name="config.block_properties.block_sound.pitch", tips={"config.require_restart"})
        @NumberRange(range={0.0, 3.4028234663852886E38})
        private float pitchIn = 1.0f;
        @Persisted
        private ResourceLocation breakSound = SoundEvents.f_12442_.m_11660_();
        @Persisted
        private ResourceLocation stepSound = SoundEvents.f_12450_.m_11660_();
        @Persisted
        private ResourceLocation placeSound = SoundEvents.f_12447_.m_11660_();
        @Persisted
        private ResourceLocation hitSound = SoundEvents.f_12446_.m_11660_();
        @Persisted
        private ResourceLocation fallSound = SoundEvents.f_12445_.m_11660_();
        private SoundEvent breakSoundEvent;
        private SoundEvent stepSoundEvent;
        private SoundEvent placeSoundEvent;
        private SoundEvent hitSoundEvent;
        private SoundEvent fallSoundEvent;

        public ForgeSoundType createSoundType() {
            return new ForgeSoundType(1.0f, 1.0f, this::getBreakSoundEvent, this::getStepSoundEvent, this::getPlaceSoundEvent, this::getHitSoundEvent, this::getFallSoundEvent);
        }

        public SoundEvent getBreakSoundEvent() {
            if (this.breakSoundEvent == null) {
                this.breakSoundEvent = Optional.ofNullable((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.breakSound)).orElse(SoundEvents.f_271165_);
            }
            return this.breakSoundEvent;
        }

        public SoundEvent getStepSoundEvent() {
            if (this.stepSoundEvent == null) {
                this.stepSoundEvent = Optional.ofNullable((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.stepSound)).orElse(SoundEvents.f_271165_);
            }
            return this.stepSoundEvent;
        }

        public SoundEvent getPlaceSoundEvent() {
            if (this.placeSoundEvent == null) {
                this.placeSoundEvent = Optional.ofNullable((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.placeSound)).orElse(SoundEvents.f_271165_);
            }
            return this.placeSoundEvent;
        }

        public SoundEvent getHitSoundEvent() {
            if (this.hitSoundEvent == null) {
                this.hitSoundEvent = Optional.ofNullable((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.hitSound)).orElse(SoundEvents.f_271165_);
            }
            return this.hitSoundEvent;
        }

        public SoundEvent getFallSoundEvent() {
            if (this.fallSoundEvent == null) {
                this.fallSoundEvent = Optional.ofNullable((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.fallSound)).orElse(SoundEvents.f_271165_);
            }
            return this.fallSoundEvent;
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            super.buildConfigurator(father);
            father.addConfigurators(new Configurator[]{this.createSoundConfigurator("config.block_properties.block_sound.break", this::breakSound, this::breakSound), this.createSoundConfigurator("config.block_properties.block_sound.step", this::stepSound, this::stepSound), this.createSoundConfigurator("config.block_properties.block_sound.place", this::placeSound, this::placeSound), this.createSoundConfigurator("config.block_properties.block_sound.hit", this::hitSound, this::hitSound), this.createSoundConfigurator("config.block_properties.block_sound.fall", this::fallSound, this::fallSound)});
        }

        @OnlyIn(value=Dist.CLIENT)
        public Configurator createSoundConfigurator(String name, Consumer<ResourceLocation> setter, Supplier<ResourceLocation> getter) {
            return new SearchComponentConfigurator(name, getter, sound -> {
                setter.accept((ResourceLocation)sound);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(sound)), (float)1.0f));
            }, (Object)SoundEvents.f_12447_.m_11660_(), true, (word, find) -> {
                for (ResourceLocation key : ForgeRegistries.SOUND_EVENTS.getKeys()) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (!key.toString().contains(word.toLowerCase())) continue;
                    find.accept(key);
                }
            }, Object::toString);
        }

        public float volumeIn() {
            return this.volumeIn;
        }

        public float pitchIn() {
            return this.pitchIn;
        }

        public ResourceLocation breakSound() {
            return this.breakSound;
        }

        public ResourceLocation stepSound() {
            return this.stepSound;
        }

        public ResourceLocation placeSound() {
            return this.placeSound;
        }

        public ResourceLocation hitSound() {
            return this.hitSound;
        }

        public ResourceLocation fallSound() {
            return this.fallSound;
        }

        public SoundEvent breakSoundEvent() {
            return this.breakSoundEvent;
        }

        public SoundEvent stepSoundEvent() {
            return this.stepSoundEvent;
        }

        public SoundEvent placeSoundEvent() {
            return this.placeSoundEvent;
        }

        public SoundEvent hitSoundEvent() {
            return this.hitSoundEvent;
        }

        public SoundEvent fallSoundEvent() {
            return this.fallSoundEvent;
        }

        public BlockSound volumeIn(float volumeIn) {
            this.volumeIn = volumeIn;
            return this;
        }

        public BlockSound pitchIn(float pitchIn) {
            this.pitchIn = pitchIn;
            return this;
        }

        public BlockSound breakSound(ResourceLocation breakSound) {
            this.breakSound = breakSound;
            return this;
        }

        public BlockSound stepSound(ResourceLocation stepSound) {
            this.stepSound = stepSound;
            return this;
        }

        public BlockSound placeSound(ResourceLocation placeSound) {
            this.placeSound = placeSound;
            return this;
        }

        public BlockSound hitSound(ResourceLocation hitSound) {
            this.hitSound = hitSound;
            return this;
        }

        public BlockSound fallSound(ResourceLocation fallSound) {
            this.fallSound = fallSound;
            return this;
        }

        public BlockSound breakSoundEvent(SoundEvent breakSoundEvent) {
            this.breakSoundEvent = breakSoundEvent;
            return this;
        }

        public BlockSound stepSoundEvent(SoundEvent stepSoundEvent) {
            this.stepSoundEvent = stepSoundEvent;
            return this;
        }

        public BlockSound placeSoundEvent(SoundEvent placeSoundEvent) {
            this.placeSoundEvent = placeSoundEvent;
            return this;
        }

        public BlockSound hitSoundEvent(SoundEvent hitSoundEvent) {
            this.hitSoundEvent = hitSoundEvent;
            return this;
        }

        public BlockSound fallSoundEvent(SoundEvent fallSoundEvent) {
            this.fallSoundEvent = fallSoundEvent;
            return this;
        }
    }

    public static class RenderTypes
    implements IPersistedSerializable {
        @Configurable(name="config.block_properties.render_types.solid")
        private boolean solid;
        @Configurable(name="config.block_properties.render_types.cutout")
        private boolean cutout = true;
        @Configurable(name="config.block_properties.render_types.cutout_mipped")
        private boolean cutoutMipped;
        @Configurable(name="config.block_properties.render_types.translucent")
        private boolean translucent;

        public boolean solid() {
            return this.solid;
        }

        public boolean cutout() {
            return this.cutout;
        }

        public boolean cutoutMipped() {
            return this.cutoutMipped;
        }

        public boolean translucent() {
            return this.translucent;
        }

        public RenderTypes solid(boolean solid) {
            this.solid = solid;
            return this;
        }

        public RenderTypes cutout(boolean cutout) {
            this.cutout = cutout;
            return this;
        }

        public RenderTypes cutoutMipped(boolean cutoutMipped) {
            this.cutoutMipped = cutoutMipped;
            return this;
        }

        public RenderTypes translucent(boolean translucent) {
            this.translucent = translucent;
            return this;
        }
    }

    public static class ConfigBlockPropertiesBuilder {
        private boolean renderTypes$set;
        private RenderTypes renderTypes$value;
        private boolean useAO$set;
        private boolean useAO$value;
        private boolean rotationState$set;
        private RotationState rotationState$value;
        private boolean hasCollision$set;
        private boolean hasCollision$value;
        private boolean canOcclude$set;
        private boolean canOcclude$value;
        private boolean ignitedByLava$set;
        private boolean ignitedByLava$value;
        private boolean isAir$set;
        private boolean isAir$value;
        private boolean isSuffocating$set;
        private boolean isSuffocating$value;
        private boolean emissive$set;
        private boolean emissive$value;
        private boolean friction$set;
        private float friction$value;
        private boolean speedFactor$set;
        private float speedFactor$value;
        private boolean jumpFactor$set;
        private float jumpFactor$value;
        private boolean destroyTime$set;
        private float destroyTime$value;
        private boolean explosionResistance$set;
        private float explosionResistance$value;
        private boolean blockSound$set;
        private BlockSound blockSound$value;
        private boolean transparent$set;
        private boolean transparent$value;
        private boolean forceSolid$set;
        private boolean forceSolid$value;
        private boolean replaceable$set;
        private boolean replaceable$value;
        private boolean noParticleOnBreak$set;
        private boolean noParticleOnBreak$value;
        private boolean canBeWaterlogged$set;
        private boolean canBeWaterlogged$value;
        private boolean collisionShapeFullBlock$set;
        private boolean collisionShapeFullBlock$value;

        ConfigBlockPropertiesBuilder() {
        }

        public ConfigBlockPropertiesBuilder renderTypes(RenderTypes renderTypes) {
            this.renderTypes$value = renderTypes;
            this.renderTypes$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder useAO(boolean useAO) {
            this.useAO$value = useAO;
            this.useAO$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder rotationState(RotationState rotationState) {
            this.rotationState$value = rotationState;
            this.rotationState$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder hasCollision(boolean hasCollision) {
            this.hasCollision$value = hasCollision;
            this.hasCollision$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder canOcclude(boolean canOcclude) {
            this.canOcclude$value = canOcclude;
            this.canOcclude$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder ignitedByLava(boolean ignitedByLava) {
            this.ignitedByLava$value = ignitedByLava;
            this.ignitedByLava$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder isAir(boolean isAir) {
            this.isAir$value = isAir;
            this.isAir$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder isSuffocating(boolean isSuffocating) {
            this.isSuffocating$value = isSuffocating;
            this.isSuffocating$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder emissive(boolean emissive) {
            this.emissive$value = emissive;
            this.emissive$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder friction(float friction) {
            this.friction$value = friction;
            this.friction$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder speedFactor(float speedFactor) {
            this.speedFactor$value = speedFactor;
            this.speedFactor$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder jumpFactor(float jumpFactor) {
            this.jumpFactor$value = jumpFactor;
            this.jumpFactor$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder destroyTime(float destroyTime) {
            this.destroyTime$value = destroyTime;
            this.destroyTime$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder explosionResistance(float explosionResistance) {
            this.explosionResistance$value = explosionResistance;
            this.explosionResistance$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder blockSound(BlockSound blockSound) {
            this.blockSound$value = blockSound;
            this.blockSound$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder transparent(boolean transparent) {
            this.transparent$value = transparent;
            this.transparent$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder forceSolid(boolean forceSolid) {
            this.forceSolid$value = forceSolid;
            this.forceSolid$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder replaceable(boolean replaceable) {
            this.replaceable$value = replaceable;
            this.replaceable$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder noParticleOnBreak(boolean noParticleOnBreak) {
            this.noParticleOnBreak$value = noParticleOnBreak;
            this.noParticleOnBreak$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder canBeWaterlogged(boolean canBeWaterlogged) {
            this.canBeWaterlogged$value = canBeWaterlogged;
            this.canBeWaterlogged$set = true;
            return this;
        }

        public ConfigBlockPropertiesBuilder collisionShapeFullBlock(boolean collisionShapeFullBlock) {
            this.collisionShapeFullBlock$value = collisionShapeFullBlock;
            this.collisionShapeFullBlock$set = true;
            return this;
        }

        public ConfigBlockProperties build() {
            RenderTypes renderTypes$value = this.renderTypes$value;
            if (!this.renderTypes$set) {
                renderTypes$value = ConfigBlockProperties.$default$renderTypes();
            }
            boolean useAO$value = this.useAO$value;
            if (!this.useAO$set) {
                useAO$value = ConfigBlockProperties.$default$useAO();
            }
            RotationState rotationState$value = this.rotationState$value;
            if (!this.rotationState$set) {
                rotationState$value = ConfigBlockProperties.$default$rotationState();
            }
            boolean hasCollision$value = this.hasCollision$value;
            if (!this.hasCollision$set) {
                hasCollision$value = ConfigBlockProperties.$default$hasCollision();
            }
            boolean canOcclude$value = this.canOcclude$value;
            if (!this.canOcclude$set) {
                canOcclude$value = ConfigBlockProperties.$default$canOcclude();
            }
            boolean ignitedByLava$value = this.ignitedByLava$value;
            if (!this.ignitedByLava$set) {
                ignitedByLava$value = ConfigBlockProperties.$default$ignitedByLava();
            }
            boolean isAir$value = this.isAir$value;
            if (!this.isAir$set) {
                isAir$value = ConfigBlockProperties.$default$isAir();
            }
            boolean isSuffocating$value = this.isSuffocating$value;
            if (!this.isSuffocating$set) {
                isSuffocating$value = ConfigBlockProperties.$default$isSuffocating();
            }
            boolean emissive$value = this.emissive$value;
            if (!this.emissive$set) {
                emissive$value = ConfigBlockProperties.$default$emissive();
            }
            float friction$value = this.friction$value;
            if (!this.friction$set) {
                friction$value = ConfigBlockProperties.$default$friction();
            }
            float speedFactor$value = this.speedFactor$value;
            if (!this.speedFactor$set) {
                speedFactor$value = ConfigBlockProperties.$default$speedFactor();
            }
            float jumpFactor$value = this.jumpFactor$value;
            if (!this.jumpFactor$set) {
                jumpFactor$value = ConfigBlockProperties.$default$jumpFactor();
            }
            float destroyTime$value = this.destroyTime$value;
            if (!this.destroyTime$set) {
                destroyTime$value = ConfigBlockProperties.$default$destroyTime();
            }
            float explosionResistance$value = this.explosionResistance$value;
            if (!this.explosionResistance$set) {
                explosionResistance$value = ConfigBlockProperties.$default$explosionResistance();
            }
            BlockSound blockSound$value = this.blockSound$value;
            if (!this.blockSound$set) {
                blockSound$value = ConfigBlockProperties.$default$blockSound();
            }
            boolean transparent$value = this.transparent$value;
            if (!this.transparent$set) {
                transparent$value = ConfigBlockProperties.$default$transparent();
            }
            boolean forceSolid$value = this.forceSolid$value;
            if (!this.forceSolid$set) {
                forceSolid$value = ConfigBlockProperties.$default$forceSolid();
            }
            boolean replaceable$value = this.replaceable$value;
            if (!this.replaceable$set) {
                replaceable$value = ConfigBlockProperties.$default$replaceable();
            }
            boolean noParticleOnBreak$value = this.noParticleOnBreak$value;
            if (!this.noParticleOnBreak$set) {
                noParticleOnBreak$value = ConfigBlockProperties.$default$noParticleOnBreak();
            }
            boolean canBeWaterlogged$value = this.canBeWaterlogged$value;
            if (!this.canBeWaterlogged$set) {
                canBeWaterlogged$value = ConfigBlockProperties.$default$canBeWaterlogged();
            }
            boolean collisionShapeFullBlock$value = this.collisionShapeFullBlock$value;
            if (!this.collisionShapeFullBlock$set) {
                collisionShapeFullBlock$value = ConfigBlockProperties.$default$collisionShapeFullBlock();
            }
            return new ConfigBlockProperties(renderTypes$value, useAO$value, rotationState$value, hasCollision$value, canOcclude$value, ignitedByLava$value, isAir$value, isSuffocating$value, emissive$value, friction$value, speedFactor$value, jumpFactor$value, destroyTime$value, explosionResistance$value, blockSound$value, transparent$value, forceSolid$value, replaceable$value, noParticleOnBreak$value, canBeWaterlogged$value, collisionShapeFullBlock$value);
        }

        public String toString() {
            return "ConfigBlockProperties.ConfigBlockPropertiesBuilder(renderTypes$value=" + String.valueOf(this.renderTypes$value) + ", useAO$value=" + this.useAO$value + ", rotationState$value=" + String.valueOf(this.rotationState$value) + ", hasCollision$value=" + this.hasCollision$value + ", canOcclude$value=" + this.canOcclude$value + ", ignitedByLava$value=" + this.ignitedByLava$value + ", isAir$value=" + this.isAir$value + ", isSuffocating$value=" + this.isSuffocating$value + ", emissive$value=" + this.emissive$value + ", friction$value=" + this.friction$value + ", speedFactor$value=" + this.speedFactor$value + ", jumpFactor$value=" + this.jumpFactor$value + ", destroyTime$value=" + this.destroyTime$value + ", explosionResistance$value=" + this.explosionResistance$value + ", blockSound$value=" + String.valueOf(this.blockSound$value) + ", transparent$value=" + this.transparent$value + ", forceSolid$value=" + this.forceSolid$value + ", replaceable$value=" + this.replaceable$value + ", noParticleOnBreak$value=" + this.noParticleOnBreak$value + ", canBeWaterlogged$value=" + this.canBeWaterlogged$value + ", collisionShapeFullBlock$value=" + this.collisionShapeFullBlock$value + ")";
        }
    }
}

