/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.machine.IMultiPart;
import com.lowdragmc.mbd2.api.pattern.BlockPattern;
import com.lowdragmc.mbd2.api.pattern.MultiblockShapeInfo;
import com.lowdragmc.mbd2.common.gui.editor.MultiblockMachineProject;
import com.lowdragmc.mbd2.common.gui.editor.PredicateResource;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.BlockPlaceholder;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.MBDMultiblockMachine;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigBlockProperties;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigItemProperties;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigMachineEvents;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigMachineSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigMultiblockSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigRecipeLogicSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.StateMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.IUIProviderTrait;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

@LDLRegister(name="multiblock", group="machine_definition")
public class MultiblockMachineDefinition
extends MBDMachineDefinition {
    public static final Map<Block, Set<MultiblockMachineDefinition>> CATALYST_CANDIDATES = Collections.synchronizedMap(new HashMap());
    @Configurable(name="config.definition.multiblock_settings", subConfigurable=true, tips={"config.definition.multiblock_settings.tooltip"}, collapse=false)
    protected ConfigMultiblockSettings multiblockSettings;
    protected ConfigMultiblockSettingsFactory multiblockSettingsFactory;
    private Function<MBDMultiblockMachine, BlockPattern> blockPatternFactory;
    private Function<MultiblockMachineDefinition, MultiblockShapeInfo[]> shapeInfoFactory;

    public MultiblockMachineDefinition(ResourceLocation id, @Nullable MachineState rootState, @Nullable ConfigBlockProperties blockProperties, @Nullable ConfigItemProperties itemProperties, @Nullable MBDMachineDefinition.ConfigMachineSettingsFactory machineSettingsFactory, @Nullable ConfigRecipeLogicSettings recipeLogicSettings, @Nullable ConfigMultiblockSettingsFactory multiblockSettingsFactory) {
        super(id, rootState, blockProperties, itemProperties, machineSettingsFactory, recipeLogicSettings, null);
        this.multiblockSettingsFactory = multiblockSettingsFactory == null ? () -> ConfigMultiblockSettings.builder().build() : multiblockSettingsFactory;
    }

    @Override
    public boolean allowPartSettings() {
        return false;
    }

    public static MultiblockMachineDefinition createDefault() {
        return new MultiblockMachineDefinition(MBD2.id("dummy"), (MachineState)StateMachine.createDefault(MachineState::builder), ConfigBlockProperties.builder().build(), ConfigItemProperties.builder().build(), () -> ConfigMachineSettings.builder().build(), ConfigRecipeLogicSettings.builder().build(), () -> ConfigMultiblockSettings.builder().build());
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ConfigMachineEvents createMachineEvents() {
        return super.createMachineEvents().registerEventGroup("MachineEvent.Multiblock");
    }

    @Override
    public void loadFactory() {
        super.loadFactory();
        this.multiblockSettings = (ConfigMultiblockSettings)this.multiblockSettingsFactory.get();
    }

    @Override
    public MBDMultiblockMachine createMachine(IMachineBlockEntity blockEntity) {
        return new MBDMultiblockMachine(blockEntity, this, new Object[0]);
    }

    @Override
    public MultiblockMachineDefinition loadProductiveTag(@Nullable File file, CompoundTag projectTag, Deque<Runnable> postTask) {
        super.loadProductiveTag(file, projectTag, postTask);
        postTask.add(() -> {
            this.multiblockSettings.deserializeNBT(projectTag.m_128469_("definition").m_128469_("multiblockSettings"));
            if (this.multiblockSettings.catalyst().isEnable() && this.multiblockSettings.catalyst().getCandidates().isEnable()) {
                for (Block block : this.multiblockSettings.catalyst().getCandidates().getValue()) {
                    CATALYST_CANDIDATES.computeIfAbsent(block, b -> new HashSet()).add(this);
                }
            }
            PredicateResource predicateResource = new PredicateResource();
            predicateResource.deserializeNBT(projectTag.m_128469_("resources").m_128469_("mbd2.gui.editor.group.predicate"));
            BlockPlaceholder[][][] placeholders = MultiblockMachineProject.deserializeBlockPlaceholders(projectTag.m_128469_("placeholders"), predicateResource);
            Direction.Axis layerAxis = Direction.Axis.valueOf((String)projectTag.m_128461_("layer_axis"));
            int aisleLength = switch (layerAxis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> placeholders.length;
                case Direction.Axis.Y -> placeholders[0].length;
                case Direction.Axis.Z -> placeholders[0][0].length;
            };
            int[][] aisleRepetitions = new int[aisleLength][2];
            int[] repetitions = projectTag.m_128465_("aisle_repetitions");
            for (int i = 0; i < aisleLength; ++i) {
                aisleRepetitions[i][0] = repetitions[i * 2];
                aisleRepetitions[i][1] = repetitions[i * 2 + 1];
            }
            BlockPattern blockPattern = MultiblockMachineProject.createBlockPattern(placeholders, layerAxis, aisleRepetitions, this);
            this.blockPatternFactory(controller -> blockPattern);
            this.shapeInfoFactory(Util.m_143827_(definition -> {
                ArrayList<MultiblockShapeInfo> shapeInfos = new ArrayList<MultiblockShapeInfo>(projectTag.m_128437_("shape_infos", 10).stream().map(CompoundTag.class::cast).map(MultiblockShapeInfo::loadFromTag).toList());
                if (shapeInfos.isEmpty()) {
                    int[] repetition = Arrays.stream(aisleRepetitions).mapToInt(range -> range[0]).toArray();
                    shapeInfos.add(new MultiblockShapeInfo(blockPattern.getPreview(repetition)));
                    for (int layer = 0; layer < aisleRepetitions.length; ++layer) {
                        int[] range2 = aisleRepetitions[layer];
                        int i = range2[0] + 1;
                        while (i <= range2[1]) {
                            repetition[layer] = i++;
                            shapeInfos.add(new MultiblockShapeInfo(blockPattern.getPreview(repetition)));
                            repetition[layer] = range2[0];
                        }
                    }
                }
                return shapeInfos.toArray(new MultiblockShapeInfo[0]);
            }));
        });
        return this;
    }

    @Override
    protected void bindMachineUI(MBDMachine machine, WidgetGroup ui) {
        super.bindMachineUI(machine, ui);
        if (machine instanceof MBDMultiblockMachine) {
            MBDMultiblockMachine multiblock = (MBDMultiblockMachine)machine;
            String prefix = "part:";
            String midTag = "@ui:";
            for (Widget widget : ui.getWidgetsById("part:.*?@ui:")) {
                int atIndex;
                String id = widget.getId();
                if (!id.startsWith(prefix) || (atIndex = id.indexOf(midTag)) == -1) continue;
                String traitName = id.substring(prefix.length(), atIndex);
                String uiName = "ui:" + id.substring(atIndex + midTag.length());
                for (IMultiPart part : multiblock.getParts()) {
                    IUIProviderTrait provider;
                    TraitDefinition traitDefinition;
                    MBDMachine mbdMachine;
                    ITrait trait;
                    if (!(part instanceof MBDMachine) || (trait = (mbdMachine = (MBDMachine)((Object)part)).getTraitByName(traitName)) == null || !((traitDefinition = trait.getDefinition()) instanceof IUIProviderTrait) || !uiName.startsWith((provider = (IUIProviderTrait)((Object)traitDefinition)).uiPrefixName())) continue;
                    widget.setId(uiName);
                    provider.initTraitUI(trait, ui);
                }
            }
        }
    }

    public BlockPattern getPattern(MBDMultiblockMachine controller) {
        return this.blockPatternFactory.apply(controller);
    }

    public void sortParts(List<IMultiPart> parts) {
    }

    public ConfigMultiblockSettings multiblockSettings() {
        return this.multiblockSettings;
    }

    public ConfigMultiblockSettingsFactory multiblockSettingsFactory() {
        return this.multiblockSettingsFactory;
    }

    public Function<MBDMultiblockMachine, BlockPattern> blockPatternFactory() {
        return this.blockPatternFactory;
    }

    public Function<MultiblockMachineDefinition, MultiblockShapeInfo[]> shapeInfoFactory() {
        return this.shapeInfoFactory;
    }

    public MultiblockMachineDefinition blockPatternFactory(Function<MBDMultiblockMachine, BlockPattern> blockPatternFactory) {
        this.blockPatternFactory = blockPatternFactory;
        return this;
    }

    public MultiblockMachineDefinition shapeInfoFactory(Function<MultiblockMachineDefinition, MultiblockShapeInfo[]> shapeInfoFactory) {
        this.shapeInfoFactory = shapeInfoFactory;
        return this;
    }

    @FunctionalInterface
    public static interface ConfigMultiblockSettingsFactory
    extends Supplier<ConfigMultiblockSettings> {
    }

    public static class Builder
    extends MBDMachineDefinition.Builder {
        protected ConfigMultiblockSettingsFactory multiblockSettings;

        protected Builder() {
        }

        @Override
        public MultiblockMachineDefinition build() {
            return new MultiblockMachineDefinition(this.id, this.rootState, this.blockProperties, this.itemProperties, this.machineSettings, this.recipeLogicSettings, this.multiblockSettings);
        }

        public Builder multiblockSettings(ConfigMultiblockSettingsFactory multiblockSettings) {
            this.multiblockSettings = multiblockSettings;
            return this;
        }
    }
}

