/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.item;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.pattern.MultiblockState;
import com.lowdragmc.mbd2.api.pattern.error.PatternError;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.machine.MBDMultiblockMachine;
import com.lowdragmc.mbd2.common.network.MBD2Network;
import com.lowdragmc.mbd2.common.network.packets.SPatternErrorPosPacket;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MBDGadgetsItem
extends Item
implements HeldItemUIFactory.IHeldItemUIHolder {
    private boolean isUsed;

    public MBDGadgetsItem() {
        super(new Item.Properties().m_41486_().m_41487_(1));
    }

    public boolean isMultiblockBuilder(ItemStack stack) {
        return stack.m_41773_() == 0;
    }

    public boolean isRecipeDebugger(ItemStack stack) {
        return stack.m_41773_() == 1;
    }

    public boolean isMultiblockDebugger(ItemStack stack) {
        return stack.m_41773_() == 2;
    }

    @Nullable
    public ResourceLocation getRecipe(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? (tag.m_128441_("recipe") ? new ResourceLocation(tag.m_128461_("recipe")) : null) : null;
    }

    public void setRecipe(ItemStack stack, ResourceLocation recipe) {
        stack.m_41784_().m_128359_("recipe", recipe.toString());
    }

    public String m_5671_(ItemStack pStack) {
        String id = super.m_5671_(pStack);
        if (this.isMultiblockBuilder(pStack)) {
            return id + ".multiblock_builder";
        }
        if (this.isRecipeDebugger(pStack)) {
            return id + ".recipe_debugger";
        }
        if (this.isMultiblockDebugger(pStack)) {
            return id + ".multiblock_debugger";
        }
        return id;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, components, isAdvanced);
        components.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")));
        String id = this.m_5671_(stack);
        if (this.isMultiblockBuilder(stack)) {
            components.add((Component)Component.m_237115_((String)(id + ".tooltip")));
        } else if (this.isRecipeDebugger(stack)) {
            components.add((Component)Component.m_237115_((String)(id + ".tooltip.0")));
            components.add((Component)Component.m_237115_((String)(id + ".tooltip.1")));
            ResourceLocation recipe = this.getRecipe(stack);
            if (recipe != null) {
                components.add((Component)Component.m_237110_((String)(id + ".tooltip.2"), (Object[])new Object[]{recipe.toString()}));
            }
        } else if (this.isMultiblockDebugger(stack)) {
            components.add((Component)Component.m_237115_((String)(id + ".tooltip")));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (this.isUsed) {
            this.isUsed = false;
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (pPlayer.m_6047_()) {
            if (this.isMultiblockBuilder(stack)) {
                stack.m_41721_(1);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (this.isRecipeDebugger(stack)) {
                stack.m_41721_(2);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (this.isMultiblockDebugger(stack)) {
                stack.m_41721_(0);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        } else if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (this.isRecipeDebugger(stack)) {
                HeldItemUIFactory.INSTANCE.openUI(serverPlayer, pUsedHand);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        ServerPlayer serverPlayer;
        Player player = context.m_43723_();
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).m_6047_()) {
            if (this.isMultiblockBuilder(stack)) {
                IMultiController controller = IMultiController.ofController((BlockGetter)player.m_9236_(), context.m_8083_()).orElse(null);
                if (controller != null) {
                    controller.getPattern().autoBuild(player, new MultiblockState(player.m_9236_(), context.m_8083_()));
                    this.isUsed = true;
                    return InteractionResult.SUCCESS;
                }
            } else {
                IMachine machine;
                if (this.isMultiblockDebugger(stack)) {
                    IMultiController controller = IMultiController.ofController((BlockGetter)player.m_9236_(), context.m_8083_()).orElse(null);
                    if (controller != null) {
                        if (controller.isFormed()) {
                            serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.multiblock_debugger.is_formed"));
                        } else if (controller.checkPatternWithLock()) {
                            MBDMultiblockMachine multiblock;
                            serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.multiblock_debugger.success"));
                            if (controller instanceof MBDMultiblockMachine && (multiblock = (MBDMultiblockMachine)controller).getDefinition().multiblockSettings().catalyst().isEnable()) {
                                if (!multiblock.getDefinition().multiblockSettings().catalyst().getFilterItems().isEmpty()) {
                                    MutableComponent items = Component.m_237113_((String)"[");
                                    for (ItemStack filterItem : multiblock.getDefinition().multiblockSettings().catalyst().getFilterItems()) {
                                        items.m_7220_(filterItem.m_41611_()).m_7220_((Component)Component.m_237113_((String)", "));
                                    }
                                    items.m_7220_((Component)Component.m_237113_((String)"]"));
                                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"item.mbd2.mbd_gadgets.multiblock_debugger.catalyst.items", (Object[])new Object[]{items}));
                                }
                                if (!multiblock.getDefinition().multiblockSettings().catalyst().getFilterTags().isEmpty()) {
                                    MutableComponent tags = Component.m_237113_((String)"[");
                                    for (ResourceLocation filterTag : multiblock.getDefinition().multiblockSettings().catalyst().getFilterTags()) {
                                        tags.m_7220_((Component)Component.m_237113_((String)filterTag.toString())).m_7220_((Component)Component.m_237113_((String)", "));
                                    }
                                    tags.m_7220_((Component)Component.m_237113_((String)"]"));
                                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"item.mbd2.mbd_gadgets.multiblock_debugger.catalyst.tags", (Object[])new Object[]{tags}));
                                }
                            }
                        } else {
                            PatternError error = controller.getMultiblockState().error;
                            if (error != null) {
                                MBD2Network.NETWORK.sendToPlayer((IPacket)new SPatternErrorPosPacket(error.getPos()), serverPlayer);
                                serverPlayer.m_213846_((Component)Component.m_237110_((String)"item.mbd2.mbd_gadgets.multiblock_debugger.failure.error.info", (Object[])new Object[]{error.getErrorInfo()}));
                            } else {
                                serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.multiblock_debugger.failure.no_error"));
                            }
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.isRecipeDebugger(stack) && this.getRecipe(stack) != null && serverPlayer.m_20194_() != null && (machine = (IMachine)IMachine.ofMachine((BlockGetter)player.m_9236_(), context.m_8083_()).orElse(null)) != null) {
                    ResourceLocation recipe = this.getRecipe(stack);
                    RecipeManager recipeManager = serverPlayer.m_20194_().m_129894_();
                    for (MBDRecipeType recipeType : MBDRegistries.RECIPE_TYPES) {
                        for (MBDRecipe mbdRecipe : recipeManager.m_44013_((RecipeType)recipeType)) {
                            MBDRecipe.ActionResult result;
                            if (!Objects.equals(mbdRecipe.id, recipe)) continue;
                            if (machine.getRecipeType() != recipeType) {
                                serverPlayer.m_213846_((Component)Component.m_237110_((String)"item.mbd2.mbd_gadgets.recipe_debugger.warning.recipe_type", (Object[])new Object[]{Component.m_237113_((String)"id").m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)machine.getRecipeType().toString())))), Component.m_237113_((String)"id").m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)mbdRecipe.id.toString()))))}));
                            }
                            if ((result = mbdRecipe.matchRecipe(machine)).isSuccess() && (result = mbdRecipe.matchTickRecipe(machine)).isSuccess()) {
                                result = mbdRecipe.checkConditions(machine.getRecipeLogic());
                            }
                            if (result.isSuccess()) {
                                serverPlayer.m_213846_((Component)Component.m_237110_((String)"item.mbd2.mbd_gadgets.recipe_debugger.raw.success", (Object[])new Object[]{Component.m_237113_((String)"id").m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)mbdRecipe.id.toString()))))}));
                                MBDRecipe modifiedRecipe = machine.doModifyRecipe(mbdRecipe);
                                if (modifiedRecipe == mbdRecipe) {
                                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.recipe_debugger.modified.empty"));
                                } else if (modifiedRecipe == null) {
                                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.recipe_debugger.modified.failure.0"));
                                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.recipe_debugger.modified.failure.1"));
                                } else {
                                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.recipe_debugger.modified.has"));
                                    result = modifiedRecipe.matchRecipe(machine);
                                    if (result.isSuccess() && (result = modifiedRecipe.matchTickRecipe(machine)).isSuccess()) {
                                        result = modifiedRecipe.checkConditions(machine.getRecipeLogic());
                                    }
                                    if (result.isSuccess()) {
                                        serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.recipe_debugger.modified.success"));
                                    } else {
                                        serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.recipe_debugger.modified.failure.0"));
                                        if (result.reason() != null) {
                                            serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.recipe_debugger.failure.reason").m_7220_(result.reason().get()));
                                        }
                                    }
                                }
                                this.isUsed = true;
                                return InteractionResult.SUCCESS;
                            }
                            serverPlayer.m_213846_((Component)Component.m_237110_((String)"item.mbd2.mbd_gadgets.recipe_debugger.raw.failure.0", (Object[])new Object[]{Component.m_237113_((String)"id").m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)mbdRecipe.id.toString()))))}));
                            if (result.reason() != null) {
                                serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.mbd2.mbd_gadgets.recipe_debugger.failure.reason").m_7220_(result.reason().get()));
                            }
                            this.isUsed = true;
                            return InteractionResult.SUCCESS;
                        }
                    }
                    this.isUsed = true;
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public ModularUI createUI(Player entityPlayer, final HeldItemUIFactory.HeldItemHolder holder) {
        int x = 25;
        int y = 20;
        SearchComponentWidget searchComponent = new SearchComponentWidget(x, y, 150, 10, (SearchComponentWidget.IWidgetSearch)new SearchComponentWidget.IWidgetSearch<ResourceLocation>(){

            public String resultDisplay(ResourceLocation value) {
                return value.toString();
            }

            public void selectResult(ResourceLocation value) {
                MBDGadgetsItem.this.setRecipe(holder.getHeld(), value);
            }

            public void search(String word, Consumer<ResourceLocation> find) {
                if (Platform.getMinecraftServer() != null) {
                    RecipeManager recipeManager = Platform.getMinecraftServer().m_129894_();
                    for (MBDRecipeType recipeType : MBDRegistries.RECIPE_TYPES) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        for (MBDRecipe recipe : recipeManager.m_44013_((RecipeType)recipeType)) {
                            if (!recipe.id.toString().contains(word.toLowerCase())) continue;
                            find.accept(recipe.id);
                        }
                    }
                }
            }

            public void serialize(ResourceLocation value, FriendlyByteBuf buf) {
                buf.m_130070_(value.toString());
            }

            public ResourceLocation deserialize(FriendlyByteBuf buf) {
                return new ResourceLocation(buf.m_130277_());
            }
        }, true);
        ResourceLocation currentRecipe = this.getRecipe(holder.getHeld());
        searchComponent.setShowUp(true);
        searchComponent.setCapacity(5);
        TextFieldWidget textFieldWidget = searchComponent.textFieldWidget;
        textFieldWidget.setCurrentString((Object)(currentRecipe == null ? "" : currentRecipe.toString()));
        return new ModularUI(200, 50, (IUIHolder)holder, entityPlayer).background(new IGuiTexture[]{ResourceBorderTexture.BORDERED_BACKGROUND}).widget((Widget)searchComponent).widget((Widget)new ImageWidget(x, y - 12, 150, 10, (IGuiTexture)new TextTexture("item.mbd2.mbd_gadgets.recipe_debugger.recipe_id").setWidth(150)));
    }
}

