/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.recipe.ingredient.entity;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.api.recipe.ingredient.EntityIngredient;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeSpawnEggItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@LDLRegister(name="entity_preview", group="widget.container")
public class EntityPreviewWidget
extends Widget
implements IRecipeIngredientSlot,
IConfigurableWidget {
    @Nullable
    private EntityIngredient entityIngredient;
    @Configurable(name="ldlib.gui.editor.name.showAmount")
    protected boolean showAmount = true;
    @Configurable(name="ldlib.gui.editor.name.drawHoverOverlay")
    public boolean drawHoverOverlay = true;
    @Configurable(name="ldlib.gui.editor.name.drawHoverTips")
    protected boolean drawHoverTips = true;
    protected BiConsumer<EntityPreviewWidget, List<Component>> onAddedTooltips;
    protected IngredientIO ingredientIO = IngredientIO.RENDER_ONLY;
    protected float XEIChance = 1.0f;
    private final List<Entity> entities = new ArrayList<Entity>();
    private TrackedDummyWorld dummyWorld;

    public EntityPreviewWidget() {
        this(null, 0, 0, 30, 30);
    }

    public EntityPreviewWidget(EntityIngredient entityIngredient, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setEntityIngredient(entityIngredient);
    }

    public void initTemplate() {
        this.setBackground(new IGuiTexture[]{TankWidget.FLUID_SLOT_TEXTURE});
    }

    public EntityPreviewWidget setEntityIngredient(EntityIngredient entityIngredient) {
        this.entityIngredient = entityIngredient;
        this.entities.clear();
        if (entityIngredient != null && LDLib.isClient()) {
            if (this.dummyWorld == null) {
                this.dummyWorld = new TrackedDummyWorld();
            }
            for (EntityType<?> entityType : entityIngredient.getTypes()) {
                Entity entity = entityType.m_20615_((Level)this.dummyWorld);
                if (entity == null) continue;
                if (entityIngredient.getNbt() != null) {
                    CompoundTag tag = entity.serializeNBT();
                    tag.m_128391_(entityIngredient.getNbt());
                    entity.m_20258_(tag);
                }
                this.entities.add(entity);
            }
        }
        return this;
    }

    public List<Component> getTooltipTexts() {
        List<Component> tooltips = this.getAdditionalToolTips(new ArrayList<Component>());
        tooltips.addAll(this.tooltipTexts);
        return tooltips;
    }

    public List<Component> getAdditionalToolTips(List<Component> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        return list;
    }

    public List<Object> getXEIIngredients() {
        List<ItemStack> items = this.entities.stream().map(Entity::m_6095_).map(ForgeSpawnEggItem::fromEntityType).filter(Objects::nonNull).map(ItemStack::new).toList();
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ItemStack realStack = items.get(0);
        if (LDLib.isJeiLoaded()) {
            Object ingredient = JEIPlugin.getItemIngredient((ItemStack)realStack, (int)this.getPosition().x, (int)this.getPosition().y, (int)this.getSize().width, (int)this.getSize().height);
            return ingredient == null ? Collections.emptyList() : List.of(ingredient);
        }
        if (LDLib.isReiLoaded()) {
            return SlotWidget.REICallWrapper.getReiIngredients((ItemStack)realStack);
        }
        if (LDLib.isEmiLoaded()) {
            return SlotWidget.EMICallWrapper.getEmiIngredients((ItemStack)realStack, (float)this.getXEIChance());
        }
        return List.of(realStack);
    }

    @Nullable
    public Object getXEICurrentIngredient() {
        List<ItemStack> items = this.entities.stream().map(Entity::m_6095_).map(ForgeSpawnEggItem::fromEntityType).filter(Objects::nonNull).map(ItemStack::new).toList();
        if (items.isEmpty()) {
            return null;
        }
        ItemStack realStack = items.get(0);
        if (LDLib.isJeiLoaded()) {
            return JEIPlugin.getItemIngredient((ItemStack)realStack, (int)this.getPosition().x, (int)this.getPosition().y, (int)this.getSize().width, (int)this.getSize().height);
        }
        return null;
    }

    public List<Component> getFullTooltipTexts() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Entity entity = this.getCurrentEntity();
        if (entity != null) {
            tooltips.add(entity.m_5446_());
        }
        tooltips.addAll(this.getTooltipTexts());
        return tooltips;
    }

    @Nullable
    public Entity getCurrentEntity() {
        if (this.entities.isEmpty()) {
            return null;
        }
        int index = Math.abs((int)(System.currentTimeMillis() / 1000L) % this.entities.size());
        return this.entities.get(index);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Entity currentEntity = this.getCurrentEntity();
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (currentEntity != null) {
            float scaleH = (float)size.height / currentEntity.m_20206_();
            float scaleW = (float)size.width / currentEntity.m_20205_();
            EntityPreviewWidget.renderEntityInInventory(graphics, pos.x + size.width / 2, pos.y + size.height / 2, (double)Math.min(scaleW, scaleH) * 0.45, currentEntity);
        }
        if (this.showAmount && this.entityIngredient != null) {
            graphics.m_280168_().m_85836_();
            String s = TextFormattingUtil.formatLongToCompactString((long)this.entityIngredient.getCount(), (int)3);
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int n = pos.x + size.width - fontRenderer.m_92895_(s) - 2;
            int n2 = pos.y + size.height;
            Objects.requireNonNull(fontRenderer);
            graphics.m_280056_(fontRenderer, s, n, n2 - 9 - 2, 0xFFFFFF, true);
            graphics.m_280168_().m_85849_();
        }
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        if (this.drawHoverOverlay && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(this.getPosition().x + 1), (int)(this.getPosition().y + 1), (int)(this.getSize().width - 2), (int)(this.getSize().height - 2), (int)-2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            if (this.gui != null) {
                this.gui.getModularUIGui().setHoverTooltip(this.getFullTooltipTexts(), ItemStack.f_41583_, null, null);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderEntityInInventory(GuiGraphics pGuiGraphics, int x, int y, double pScale, Entity entity) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        float offset = (float)(System.currentTimeMillis() % 3600L) / 3600.0f;
        Quaternionf quaternionf = new Quaternionf().rotateXYZ(0.0f, (float)Math.PI * 2 * offset, (float)Math.PI);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        pGuiGraphics.m_280168_().m_252931_(new Matrix4f().scaling((float)pScale, (float)pScale, (float)(-pScale)));
        pGuiGraphics.m_280168_().m_252880_(0.0f, entity.m_20206_() / 2.0f, 0.0f);
        pGuiGraphics.m_280168_().m_252781_(quaternionf);
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        entityrenderdispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pGuiGraphics.m_280168_(), (MultiBufferSource)pGuiGraphics.m_280091_(), 0xF000F0));
        pGuiGraphics.m_280262_();
        entityrenderdispatcher.m_114468_(true);
        pGuiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
    }

    @Nullable
    public EntityIngredient getEntityIngredient() {
        return this.entityIngredient;
    }

    public EntityPreviewWidget setShowAmount(boolean showAmount) {
        this.showAmount = showAmount;
        return this;
    }

    public EntityPreviewWidget setDrawHoverOverlay(boolean drawHoverOverlay) {
        this.drawHoverOverlay = drawHoverOverlay;
        return this;
    }

    public EntityPreviewWidget setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    public EntityPreviewWidget setOnAddedTooltips(BiConsumer<EntityPreviewWidget, List<Component>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public EntityPreviewWidget setIngredientIO(IngredientIO ingredientIO) {
        this.ingredientIO = ingredientIO;
        return this;
    }

    public IngredientIO getIngredientIO() {
        return this.ingredientIO;
    }

    public EntityPreviewWidget setXEIChance(float XEIChance) {
        this.XEIChance = XEIChance;
        return this;
    }

    public float getXEIChance() {
        return this.XEIChance;
    }
}

