/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.texture;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class IRendererSlotTexture
implements IGuiTexture {
    @Nullable
    public static MBDMachineDefinition CURRENT_MACHINE_DEFINITION;
    private Supplier<IRenderer> rendererSupplier;
    private IGuiTexture slotTexture = new ResourceTexture("ldlib:textures/gui/slot.png");

    public IRendererSlotTexture(Supplier<IRenderer> rendererSupplier) {
        this.rendererSupplier = rendererSupplier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        this.slotTexture.draw(graphics, mouseX, mouseY, x, y, width, height);
        float itemW = (float)width * 16.0f / 18.0f;
        float itemH = (float)height * 16.0f / 18.0f;
        float itemX = x + ((float)width - itemW) / 2.0f;
        float itemY = y + ((float)height - itemH) / 2.0f;
        IRenderer renderer = this.rendererSupplier.get();
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_85841_(itemW / 16.0f, itemH / 16.0f, 1.0f);
        pose.m_252880_(itemX * 16.0f / itemW, itemY * 16.0f / itemH, -200.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        Minecraft mc = Minecraft.m_91087_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 232.0f);
        pose.m_85836_();
        pose.m_252880_(8.0f, 8.0f, 150.0f);
        try {
            MachineEditor editor;
            boolean flag;
            pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            pose.m_85841_(16.0f, 16.0f, 16.0f);
            boolean bl = flag = !renderer.useBlockLight(ItemStack.f_41583_);
            if (flag) {
                Lighting.m_84930_();
            }
            MultiBufferSource.BufferSource buffers = graphics.m_280091_();
            Editor editor2 = Editor.INSTANCE;
            if (editor2 instanceof MachineEditor && (editor2 = (editor = (MachineEditor)editor2).getCurrentProject()) instanceof MachineProject) {
                MachineProject project = (MachineProject)editor2;
                CURRENT_MACHINE_DEFINITION = project.getDefinition();
            }
            renderer.renderItem(Items.f_42174_.m_7968_(), ItemDisplayContext.GUI, false, pose, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_, Minecraft.m_91087_().m_91304_().getModel(LDLib.location((String)"block/renderer_model")));
            CURRENT_MACHINE_DEFINITION = null;
            RenderSystem.disableDepthTest();
            buffers.m_109911_();
            RenderSystem.enableDepthTest();
            if (flag) {
                Lighting.m_84931_();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pose.m_85849_();
        pose.m_85849_();
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        pose.m_85849_();
    }

    public Supplier<IRenderer> getRendererSupplier() {
        return this.rendererSupplier;
    }

    public void setRendererSupplier(Supplier<IRenderer> rendererSupplier) {
        this.rendererSupplier = rendererSupplier;
    }

    public void setSlotTexture(IGuiTexture slotTexture) {
        this.slotTexture = slotTexture;
    }
}

