/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.recipe.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.RecipeTypeProject;
import com.lowdragmc.mbd2.common.recipe.DimensionCondition;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

public class RecipeTypeUIFloatView
extends FloatViewWidget {
    protected final DraggableScrollableWidgetGroup uiList;
    private final boolean isFuel;

    public RecipeTypeUIFloatView(boolean isFuel) {
        super(200, 200, 206, 120, false);
        this.isFuel = isFuel;
        this.uiList = new DraggableScrollableWidgetGroup(5, 5, 196, 110);
        this.uiList.setYScrollBarWidth(2).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(1.0f).transform(-0.5f, 0.0f));
    }

    public String name() {
        return "recipe_type_ui_view";
    }

    public String group() {
        return "editor.machine";
    }

    public IGuiTexture getIcon() {
        return new ProgressTexture();
    }

    public IGuiTexture getHoverIcon() {
        return Icons.REMOVE;
    }

    public MachineEditor getEditor() {
        return (MachineEditor)this.editor;
    }

    public void initWidget() {
        super.initWidget();
        this.content.addWidget((Widget)this.uiList);
        this.reloadList();
    }

    public void reloadList() {
        this.uiList.clearAllWidgets();
        IProject iProject = this.getEditor().getCurrentProject();
        if (iProject instanceof RecipeTypeProject) {
            RecipeTypeProject project = (RecipeTypeProject)iProject;
            WidgetGroup ui = this.isFuel ? project.getFuelUI() : project.getUi();
            this.addButton((Widget)new ImageWidget(0, 0, 18, 18, (IGuiTexture)new ProgressTexture((IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.5, 1.0, 0.5))), () -> "editor.machine.recipe_type_ui_view.progress", () -> {
                if (WidgetUtils.getFirstWidgetById(ui, "^@progress_bar$") == null) {
                    ProgressWidget progress = new ProgressWidget(ProgressWidget.JEIProgress, 5, 5, 18, 18, new ProgressTexture((IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.5, 1.0, 0.5)));
                    progress.setId("@progress_bar");
                    ui.addWidget((Widget)progress);
                }
            });
            this.addButton((Widget)new ImageWidget(0, 0, 18, 18, (IGuiTexture)Icons.FILE), () -> "editor.machine.recipe_type_ui_view.duration", () -> {
                if (WidgetUtils.getFirstWidgetById(ui, "^@duration$") == null) {
                    LabelWidget duration = new LabelWidget(5, 5, (Component)Component.m_237110_((String)"recipe.duration.value", (Object[])new Object[]{100}));
                    duration.setId("@duration");
                    ui.addWidget((Widget)duration);
                }
            });
            this.addButton((Widget)new ImageWidget(0, 0, 18, 18, DimensionCondition.INSTANCE.getIcon()), () -> "editor.machine.recipe_type_ui_view.condition", () -> {
                if (WidgetUtils.getFirstWidgetById(ui, "^@condition$") == null) {
                    TextBoxWidget duration = new TextBoxWidget(5, 5, ui.getSizeWidth() - 10, List.of(DimensionCondition.INSTANCE.getTooltips().getString()));
                    duration.isShadow = true;
                    duration.fontColor = -1;
                    duration.setId("@condition");
                    ui.addWidget((Widget)duration);
                }
            });
            HashMap<RecipeCapability, Integer> maxInputs = new HashMap<RecipeCapability, Integer>();
            HashMap<RecipeCapability, Integer> maxOutputs = new HashMap<RecipeCapability, Integer>();
            for (MBDRecipe recipe : project.getRecipeType().getBuiltinRecipes().values()) {
                Integer cap2;
                if (recipe.isFuel != this.isFuel) continue;
                for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipe.inputs.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    cap2 = maxInputs.getOrDefault(entry.getKey(), 0);
                    maxInputs.put(entry.getKey(), Math.max(cap2, entry.getValue().size()));
                }
                for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipe.outputs.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    cap2 = maxOutputs.getOrDefault(entry.getKey(), 0);
                    maxOutputs.put(entry.getKey(), Math.max(cap2, entry.getValue().size()));
                }
            }
            maxInputs.forEach((cap, maxSize) -> this.addCap((RecipeCapability)cap, (int)maxSize, IO.IN));
            maxOutputs.forEach((cap, maxSize) -> this.addCap((RecipeCapability)cap, (int)maxSize, IO.OUT));
        }
    }

    public void addButton(Widget icon, Supplier<String> value, Runnable onClick) {
        int yOffset = 3 + this.uiList.getAllWidgetSize() * 20;
        WidgetGroup widgetGroup = new WidgetGroup(0, yOffset, 90, 18);
        icon.setSelfPosition(1, 0);
        widgetGroup.addWidget(icon);
        widgetGroup.addWidget((Widget)new ImageWidget(20, 1, 120, 18, (IGuiTexture)new TextTexture().setSupplier(value).setType(TextTexture.TextType.ROLL_ALWAYS).setWidth(120)));
        widgetGroup.addWidget((Widget)new ButtonWidget(145, 2, 45, 14, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setRadius(7.0f), ColorPattern.WHITE.borderTexture(-1).setRadius(7.0f), new TextTexture("editor.machine.recipe_type_ui_view.add")}), cd -> onClick.run()).setHoverTexture(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setRadius(7.0f), ColorPattern.GREEN.borderTexture(-1).setRadius(7.0f), new TextTexture("editor.machine.recipe_type_ui_view.add")})}));
        this.uiList.addWidget((Widget)widgetGroup);
    }

    public void addCap(RecipeCapability cap, int maxSize, IO io) {
        IProject iProject = this.getEditor().getCurrentProject();
        if (iProject instanceof RecipeTypeProject) {
            RecipeTypeProject project = (RecipeTypeProject)iProject;
            WidgetGroup ui = this.isFuel ? project.getFuelUI() : project.getUi();
            this.addButton(cap.createPreviewWidget(cap.createDefaultContent()), () -> {
                int found = 0;
                for (int i = 0; i < maxSize; ++i) {
                    String id = "@%s_%s_%d".formatted(cap.name, io.name, i);
                    if (WidgetUtils.getFirstWidgetById(ui, "^%s$".formatted(id)) == null) continue;
                    ++found;
                }
                if (found < maxSize) {
                    return "%s: \u00a7e%d\u00a7r/ %d".formatted(io.name, found, maxSize);
                }
                return "%s: \u00a72%d\u00a7r/ %d".formatted(io.name, found, maxSize);
            }, () -> {
                int x = 5;
                for (int i = 0; i < maxSize; ++i) {
                    String id = "@%s_%s_%d".formatted(cap.name, io.name, i);
                    if (WidgetUtils.getFirstWidgetById(ui, "^%s$".formatted(id)) != null) continue;
                    Widget template = cap.createXEITemplate();
                    template.setSelfPosition(x, 5);
                    template.setId(id);
                    x += template.getSize().width;
                    ui.addWidget(template);
                }
            });
        }
    }

    public DraggableScrollableWidgetGroup getUiList() {
        return this.uiList;
    }

    public boolean isFuel() {
        return this.isFuel;
    }
}

