/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.recipe;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.WidgetTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.ContentWidget;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContentContainer
extends WidgetGroup {
    private final Map<RecipeCapability<?>, List<Content>> contents;
    private final DraggableScrollableWidgetGroup container;
    private final Runnable onContentUpdate;
    @Nullable
    private Tuple<RecipeCapability, Content> selected;
    @Nullable
    private Runnable onSelected;

    public ContentContainer(int x, int y, int width, int height, Map<RecipeCapability<?>, List<Content>> contents, Runnable onContentUpdate) {
        super(x, y, width, height);
        this.contents = contents;
        this.onContentUpdate = onContentUpdate;
        this.container = new DraggableScrollableWidgetGroup(0, 15, width, height - 15);
        this.container.setYScrollBarWidth(4).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(2.0f).transform(-0.5f, 0.0f));
        this.container.setBackground((IGuiTexture)ColorPattern.T_WHITE.borderTexture(1));
        this.addWidget((Widget)this.container);
        this.createTitle();
        this.reloadContents();
    }

    public void clearSelected() {
        this.container.setSelected(null);
    }

    private void createTitle() {
        int width = this.container.getSizeWidth() - 5;
        int dur = 5;
        int x = 0;
        int textFieldWidth = Math.max(50, (width - 20 - dur - 20 - dur) / 4 - dur);
        this.appendTitleWidget(x, 20, "C");
        if ((x += 20 + dur) + 20 > width) {
            return;
        }
        this.appendTitleWidget(x, 20, "tick");
        if ((x += 20 + dur) + textFieldWidth > width) {
            return;
        }
        this.appendTitleWidget(x, textFieldWidth, "editor.machine.recipe_type.content.chance");
        if ((x += textFieldWidth + dur) + textFieldWidth > width) {
            return;
        }
        this.appendTitleWidget(x, textFieldWidth, "editor.machine.recipe_type.content.tier_chance_boost");
        if ((x += textFieldWidth + dur) + textFieldWidth > width) {
            return;
        }
        this.appendTitleWidget(x, textFieldWidth, "editor.machine.recipe_type.content.slot_name");
        if ((x += textFieldWidth + dur) + textFieldWidth > width) {
            return;
        }
        this.appendTitleWidget(x, textFieldWidth, "editor.machine.recipe_type.content.ui_name");
    }

    private void appendTitleWidget(int x, int width, String C) {
        this.addWidget((Widget)new ImageWidget(x, 0, width, 15, (IGuiTexture)new TextTexture(C).setWidth(width)));
    }

    private void reloadContents() {
        this.container.clearAllWidgets();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : this.contents.entrySet()) {
            final RecipeCapability<?> cap = entry.getKey();
            List<Content> contentList = entry.getValue();
            for (final Content content : contentList) {
                SelectableWidgetGroup contentLine = this.createContentLine(cap, content);
                contentLine.setSelfPosition(0, this.container.getAllWidgetSize() * 20);
                contentLine.setSelectedTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture()}));
                contentLine.setOnSelected(group -> {
                    this.selected = new Tuple((Object)cap, (Object)content);
                    if (this.onSelected != null) {
                        this.onSelected.run();
                    }
                    if (Editor.INSTANCE != null) {
                        Editor.INSTANCE.getConfigPanel().openConfigurator(MachineEditor.SECOND, new IConfigurable(){

                            public void buildConfigurator(ConfiguratorGroup father) {
                                ConfiguratorGroup contentGroup = new ConfiguratorGroup("editor.machine.basic_settings");
                                ConfiguratorParser.createConfigurators((ConfiguratorGroup)contentGroup, new HashMap(), content.getClass(), (Object)content);
                                father.addConfigurators(new Configurator[]{contentGroup});
                                cap.createContentConfigurator(father, () -> cap.of(content2.content), c -> {
                                    content2.content = c;
                                });
                            }
                        });
                    }
                });
                contentLine.setOnUnSelected(group -> {
                    this.selected = null;
                    if (Editor.INSTANCE != null) {
                        Editor.INSTANCE.getConfigPanel().clearAllConfigurators(MachineEditor.SECOND);
                    }
                });
                this.container.addWidget((Widget)contentLine);
            }
        }
    }

    private SelectableWidgetGroup createContentLine(RecipeCapability<?> cap, Content content) {
        int width = this.container.getSizeWidth() - 5;
        SelectableWidgetGroup contentLine = new SelectableWidgetGroup(0, 0, width, 20);
        ContentWidget contentWidget = new ContentWidget(0, 0, cap, content);
        int dur = 5;
        int x = 0;
        int textFieldWidth = Math.max(50, (width - 20 - dur - 20 - dur) / 4 - dur);
        contentLine.addWidget(contentWidget);
        if ((x += 20 + dur) + 20 > width) {
            return contentLine;
        }
        contentLine.addWidget((Widget)new SwitchWidget(x + 1, 1, 18, 18, (cd, pressed) -> {
            content.perTick = pressed;
        }).setSupplier(() -> content.perTick).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.WHITE.borderTexture(-2)}).scale(0.6f), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.WHITE.borderTexture(-2), ColorPattern.WHITE.rectTexture().scale(0.5f)}).scale(0.6f)));
        if ((x += 20 + dur) + textFieldWidth > width) {
            return contentLine;
        }
        ContentContainer.createFloatField((WidgetGroup)contentLine, x, textFieldWidth, content.chance, f -> {
            content.chance = f.floatValue();
        }, 0.0f, 1.0f);
        if ((x += textFieldWidth + dur) + textFieldWidth > width) {
            return contentLine;
        }
        ContentContainer.createFloatField((WidgetGroup)contentLine, x, textFieldWidth, content.tierChanceBoost, f -> {
            content.tierChanceBoost = f.floatValue();
        }, 0.0f, 1.0f);
        if ((x += textFieldWidth + dur) + textFieldWidth > width) {
            return contentLine;
        }
        ContentContainer.createStringField((WidgetGroup)contentLine, x, textFieldWidth, content.slotName, s -> {
            content.slotName = s;
        });
        if ((x += textFieldWidth + dur) + textFieldWidth > width) {
            return contentLine;
        }
        ContentContainer.createStringField((WidgetGroup)contentLine, x, textFieldWidth, content.uiName, s -> {
            content.uiName = s;
        });
        return contentLine;
    }

    private static void createFloatField(WidgetGroup contentLine, int x, int textFieldWidth, float initial, Consumer<Float> setter, float min, float max) {
        TextFieldWidget textField = new TextFieldWidget(x + 3, 5, textFieldWidth - 3, 10, null, s -> setter.accept(Float.valueOf(Float.parseFloat(s)))).setCurrentString((Object)String.valueOf(initial)).setNumbersOnly(min, max);
        textField.setBordered(false);
        textField.setWheelDur(0.1f);
        contentLine.addWidget((Widget)new ImageWidget(x, 5, textFieldWidth, 10, (IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)));
        contentLine.addWidget((Widget)textField);
    }

    private static void createStringField(WidgetGroup contentLine, int x, int textFieldWidth, @Nullable String initial, Consumer<String> setter) {
        TextFieldWidget textField = new TextFieldWidget(x + 3, 5, textFieldWidth - 3, 10, null, setter).setCurrentString((Object)(initial == null ? "" : initial));
        textField.setBordered(false);
        contentLine.addWidget((Widget)new ImageWidget(x, 5, textFieldWidth, 10, (IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)));
        contentLine.addWidget((Widget)textField);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.container.isMouseOverElement(mouseX, mouseY) && button == 1 && Editor.INSTANCE != null) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().branch((IGuiTexture)Icons.ADD_FILE, "editor.machine.recipe_type.add_content", m -> {
                for (RecipeCapability cap : MBDRegistries.RECIPE_CAPABILITIES.values()) {
                    m.leaf((IGuiTexture)new WidgetTexture(cap.createPreviewWidget(cap.createDefaultContent()).setClientSideWidget()), "recipe.capability.%s.name".formatted(cap.name), () -> {
                        Object content = cap.createDefaultContent();
                        this.contents.computeIfAbsent(cap, c -> new ArrayList()).add(new Content(content, false, 1.0f, 0.0f));
                        this.reloadContents();
                        this.onContentUpdate.run();
                    });
                }
            });
            if (this.selected != null) {
                menu.crossLine();
                menu.leaf((IGuiTexture)Icons.COPY, "ldlib.gui.editor.menu.copy", () -> {
                    Content copied = ((Content)this.selected.m_14419_()).deepCopy((RecipeCapability)this.selected.m_14418_(), null);
                    this.contents.computeIfAbsent((RecipeCapability)this.selected.m_14418_(), cap -> new ArrayList()).add(copied);
                    this.reloadContents();
                    this.onContentUpdate.run();
                });
                menu.leaf((IGuiTexture)Icons.REMOVE_FILE, "editor.machine.recipe_type.remove_content", () -> {
                    List contentList = this.contents.getOrDefault(this.selected.m_14418_(), Collections.emptyList());
                    contentList.remove(this.selected.m_14419_());
                    if (contentList.isEmpty()) {
                        this.contents.remove(this.selected.m_14418_());
                    }
                    this.selected = null;
                    Editor.INSTANCE.getConfigPanel().clearAllConfigurators(MachineEditor.SECOND);
                    this.reloadContents();
                    this.onContentUpdate.run();
                });
            }
            Editor.INSTANCE.openMenu(mouseX, mouseY, menu);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Nullable
    public Tuple<RecipeCapability, Content> getSelected() {
        return this.selected;
    }

    public void setOnSelected(@Nullable Runnable onSelected) {
        this.onSelected = onSelected;
    }
}

