/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.machine.widget;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.MenuWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.blockentity.MachineBlockEntity;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineConfigPanel;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MachineStatePreview
extends DraggableWidgetGroup {
    private final MachineConfigPanel panel;
    private final MachineState state;
    private final WidgetGroup title;
    private final WidgetGroup content;
    private boolean isCollapse;
    protected MBDMachine previewMachine;
    private long lastClickTick;

    public MachineStatePreview(MachineConfigPanel panel, MachineState state) {
        super(0, 0, 100, 115);
        this.panel = panel;
        this.state = state;
        this.title = new WidgetGroup(0, 0, this.getSize().width, 15);
        this.addWidget((Widget)this.title);
        this.title.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setTopRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setTopRadius(5.0f)})});
        this.title.addWidget((Widget)new ImageWidget(2, 2, 11, 11, (IGuiTexture)Icons.FILE));
        this.title.addWidget((Widget)new ImageWidget(15, 0, this.getSize().width - 15, 15, (IGuiTexture)new TextTexture("").setSupplier(state::name).setType(TextTexture.TextType.LEFT_ROLL).setWidth(this.getSize().width - 15)));
        this.content = new WidgetGroup(0, 15, this.getSize().width, this.getSize().height - 15);
        this.addWidget((Widget)this.content);
        this.content.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.BLACK.rectTexture().setBottomRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setBottomRadius(5.0f)})});
        SceneWidget scene = new SceneWidget(4, 4, this.content.getSize().width - 8, this.content.getSize().height - 8, null);
        TrackedDummyWorld level = new TrackedDummyWorld();
        this.content.addWidget((Widget)scene);
        scene.setIntractable(false);
        scene.setRenderFacing(false);
        scene.setRenderSelect(false);
        scene.createScene((Level)level);
        scene.getRenderer().setOnLookingAt(null);
        scene.setRenderedCore(Collections.singleton(BlockPos.f_121853_), null);
        level.addBlock(BlockPos.f_121853_, BlockInfo.fromBlock((Block)MBDRegistries.FAKE_MACHINE().block()));
        Optional.ofNullable(level.m_7702_(BlockPos.f_121853_)).ifPresent(blockEntity -> {
            if (blockEntity instanceof MachineBlockEntity) {
                MachineBlockEntity holder = (MachineBlockEntity)blockEntity;
                IProject patt3353$temp = panel.getEditor().getCurrentProject();
                if (patt3353$temp instanceof MachineProject) {
                    MachineProject project = (MachineProject)patt3353$temp;
                    this.previewMachine = project.getDefinition().createMachine(holder);
                    holder.setMachine(this.previewMachine);
                    this.previewMachine.setMachineState(state.name());
                }
            }
        });
        this.setSelectedTexture((IGuiTexture)ColorPattern.GREEN.borderTexture(1).setRadius(5.0f));
        ImageWidget draggingBorder = new ImageWidget(0, 0, this.getSize().width, this.getSize().height, (IGuiTexture)ColorPattern.YELLOW.borderTexture(2).setRadius(5.0f));
        draggingBorder.setVisible(false);
        this.addWidget((Widget)draggingBorder);
        this.setDraggingConsumer(IRenderer.class::isInstance, o -> {
            draggingBorder.setVisible(true);
            draggingBorder.setSize(this.getSize().width, this.getSize().height);
        }, o -> draggingBorder.setVisible(false), o -> {
            draggingBorder.setVisible(false);
            if (o instanceof IRenderer) {
                IRenderer renderer = (IRenderer)o;
                state.renderer().setEnable(true);
                state.renderer().setValue(renderer);
            }
        });
    }

    public void collapse() {
        boolean bl = this.isCollapse = !this.isCollapse;
        if (this.isCollapse) {
            this.title.setSize(new Size(this.content.getSize().width, 15));
            this.title.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setRadius(5.0f)})});
            this.content.setVisible(false);
            this.content.setActive(false);
            this.setSize(new Size(this.content.getSize().width, 15));
        } else {
            this.title.setSize(new Size(this.content.getSize().width, 15));
            this.title.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setTopRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setTopRadius(5.0f)})});
            this.content.setVisible(true);
            this.content.setActive(true);
            this.setSize(new Size(this.content.getSize().width, this.content.getSize().height + 15));
        }
    }

    public IGuiTexture getIcon() {
        return Icons.HISTORY;
    }

    public boolean isRoot() {
        return this.state.isRoot();
    }

    public boolean canDragOutRange() {
        return true;
    }

    public void onSelected() {
        super.onSelected();
        this.panel.onStateSelected(this.state);
    }

    protected TreeBuilder.Menu createMenuTree() {
        TreeBuilder.Menu menu = TreeBuilder.Menu.start();
        menu.leaf((IGuiTexture)Icons.ADD, "editor.machine_state.add", () -> DialogWidget.showStringEditorDialog((WidgetGroup)this.panel, (String)"editor.machine_state.add", (String)"new_state", s -> true, s -> {
            if (s != null && this.state.stateMachine() != null && !this.state.stateMachine().hasState((String)s)) {
                MachineState newState = this.state.addChild((String)s);
                this.panel.onStateAdded(newState);
            }
        }));
        if (!this.isRoot() && this.state.parent() != null) {
            menu.leaf((IGuiTexture)Icons.REMOVE, "editor.machine_state.remove", () -> {
                this.panel.onStateRemoved(this.state);
                this.state.parent().removeChild(this.state);
            });
        }
        return menu;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        TreeBuilder.Menu menu;
        if (this.content.isMouseOverElement(mouseX, mouseY) && button == 1 && (menu = this.createMenuTree()) != null) {
            this.panel.waitToAdded(new MenuWidget((int)mouseX, (int)mouseY, 14, menu.build()).setNodeTexture(MenuWidget.NODE_TEXTURE).setLeafTexture(MenuWidget.LEAF_TEXTURE).setNodeHoverTexture(MenuWidget.NODE_HOVER_TEXTURE).setCrossLinePredicate(TreeBuilder.Menu::isCrossLine).setKeyIconSupplier(TreeBuilder.Menu::getIcon).setKeyNameSupplier(TreeBuilder.Menu::getName).setOnNodeClicked(TreeBuilder.Menu::handle).setBackground(new IGuiTexture[]{MenuWidget.BACKGROUND}));
            return true;
        }
        if (this.title.isMouseOverElement(mouseX, mouseY) && button == 0) {
            if (this.lastClickTick != 0L && this.gui.getTickCount() - this.lastClickTick < 10L) {
                MachineStatePreview.playButtonClickSound();
                this.collapse();
            } else {
                this.lastClickTick = this.gui.getTickCount();
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public MachineConfigPanel getPanel() {
        return this.panel;
    }

    public MachineState getState() {
        return this.state;
    }

    public boolean isCollapse() {
        return this.isCollapse;
    }
}

