/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.machine;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineScenePanel;
import com.lowdragmc.mbd2.common.gui.editor.machine.widget.TraitList;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import javax.annotation.Nullable;

public class MachineTraitPanel
extends MachineScenePanel {
    @Nullable
    private TraitList traitList;

    public MachineTraitPanel(MachineEditor editor) {
        super(editor);
    }

    public void onPanelSelected() {
        this.editor.getConfigPanel().clearAllConfigurators();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getToolPanel().setTitle("editor.machine.machine_traits");
        this.editor.getToolPanel().addNewToolBox("editor.machine.machine_traits.list", Icons.WIDGET_CUSTOM, size -> {
            this.traitList = new TraitList(this.editor, (Size)size);
            return this.traitList;
        });
        if (this.editor.getToolPanel().inAnimate()) {
            this.editor.getToolPanel().getAnimation().appendOnFinish(() -> this.editor.getToolPanel().show());
        } else {
            this.editor.getToolPanel().show();
        }
    }

    public void onPanelDeselected() {
        this.editor.getToolPanel().setTitle("ldlib.gui.editor.group.tool_box");
        this.editor.getToolPanel().hide();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getConfigPanel().clearAllConfigurators();
    }

    @Override
    public void renderAfterWorld(SceneWidget sceneWidget) {
        super.renderAfterWorld(sceneWidget);
        if (this.traitList != null && this.traitList.getSelected() != null) {
            TraitDefinition definition = this.traitList.getSelected();
            definition.renderAfterWorldInTraitPanel(this);
        }
    }
}

