/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.machine;

import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.blockentity.MachineBlockEntity;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MachineScenePanel
extends WidgetGroup {
    protected final MachineEditor editor;
    protected final TrackedDummyWorld level;
    protected final SceneWidget scene;
    protected final WidgetGroup buttonGroup;
    @Nullable
    protected MBDMachine previewMachine;
    protected boolean drawShapeFrameLines = false;
    protected boolean drawRenderingBoxFrameLines = false;

    public MachineScenePanel(MachineEditor editor) {
        super(0, 16, editor.getSize().getWidth() - 252, editor.getSize().height - 16 - 16);
        this.editor = editor;
        this.scene = new SceneWidget(0, 0, this.getSize().width, this.getSize().height, null);
        this.addWidget((Widget)this.scene);
        this.buttonGroup = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget((Widget)this.buttonGroup);
        this.scene.setRenderFacing(false);
        this.scene.setRenderSelect(false);
        this.level = new TrackedDummyWorld();
        this.scene.createScene((Level)this.level);
        this.scene.getRenderer().setOnLookingAt(null);
        this.scene.setRenderedCore(Collections.singleton(BlockPos.f_121853_), null);
        this.scene.setAfterWorldRender(this::renderAfterWorld);
        this.scene.getRenderer().setEndBatchLast(false);
        this.resetScene();
        this.prepareButtonGroup();
    }

    public void resetScene() {
        this.level.clear();
        this.level.addBlock(BlockPos.f_121853_, BlockInfo.fromBlock((Block)MBDRegistries.FAKE_MACHINE().block()));
        Optional.ofNullable(this.level.m_7702_(BlockPos.f_121853_)).ifPresent(blockEntity -> {
            if (blockEntity instanceof MachineBlockEntity) {
                MachineBlockEntity holder = (MachineBlockEntity)blockEntity;
                IProject patt3250$temp = this.editor.getCurrentProject();
                if (patt3250$temp instanceof MachineProject) {
                    MachineProject project = (MachineProject)patt3250$temp;
                    this.previewMachine = project.getDefinition().createMachine(holder);
                    holder.setMachine(this.previewMachine);
                }
            }
        });
        this.reloadAdditionalTraits();
    }

    public void reloadAdditionalTraits() {
        if (this.previewMachine != null) {
            this.previewMachine.loadAdditionalTraits();
            this.previewMachine.getAdditionalTraits().forEach(ITrait::onLoadingTraitInPreview);
        }
    }

    public void prepareButtonGroup() {
        this.buttonGroup.clearAllWidgets();
        this.addSwitch((IGuiTexture)Icons.icon((String)"mbd2", (String)"cube_outline"), null, "editor.machine_scene.draw_shape_frame_lines", this::isDrawShapeFrameLines, this::setDrawShapeFrameLines);
        this.addSwitch((IGuiTexture)Icons.icon((String)"mbd2", (String)"cube_outline").copy().setColor(-1123072), null, "editor.machine_scene.draw_rendering_box_frame_lines", this::isDrawRenderingBoxFrameLines, this::setDrawRenderingBoxFrameLines);
        this.refreshButtonGroupPosition();
    }

    public void addSwitch(IGuiTexture baseTexture, @Nullable IGuiTexture pressedTexture, @Nullable String tooltips, BooleanSupplier getter, BooleanConsumer setter) {
        Widget switchWidget = new SwitchWidget(this.buttonGroup.widgets.size() * 25, 0, 20, 20, (cd, pressed) -> setter.accept(pressed.booleanValue())).setSupplier(getter::getAsBoolean).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), baseTexture}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GREEN.rectTexture().setRadius(5.0f), pressedTexture == null ? baseTexture : pressedTexture})).setHoverTooltips(new String[]{tooltips});
        this.buttonGroup.addWidget(switchWidget);
    }

    public void addButton(IGuiTexture baseTexture, @Nullable String tooltips, Runnable action) {
        Widget buttonWidget = new ButtonWidget(this.buttonGroup.widgets.size() * 25, 0, 20, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), baseTexture}), cd -> action.run()).setHoverTooltips(new String[]{tooltips});
        this.buttonGroup.addWidget(buttonWidget);
    }

    public void refreshButtonGroupPosition() {
        this.buttonGroup.setSize(new Size(Math.max(0, this.buttonGroup.widgets.size() * 25 - 5), 20));
        this.buttonGroup.setSelfPosition(new Position(this.getSize().width - this.buttonGroup.getSize().width - 25, 25));
    }

    public void renderAfterWorld(SceneWidget sceneWidget) {
        AABB aabb;
        if (this.previewMachine == null) {
            return;
        }
        boolean drawFrameLines = this.drawShapeFrameLines || this.drawRenderingBoxFrameLines;
        PoseStack poseStack = new PoseStack();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        if (drawFrameLines) {
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.blendFunc((int)770, (int)771);
            poseStack.m_85836_();
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::m_172757_);
            buffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
            RenderSystem.lineWidth((float)5.0f);
        }
        if (this.drawShapeFrameLines) {
            this.previewMachine.getMachineState().getShape(null).m_83224_((x0, y0, z0, x1, y1, z1) -> {
                float f = (float)(x1 - x0);
                float f1 = (float)(y1 - y0);
                float f2 = (float)(z1 - z0);
                float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
                buffer.m_252986_(matrix4f, (float)x0, (float)y0, (float)z0).m_193479_(-1).m_252939_(normal, f /= f3, f1 /= f3, f2 /= f3).m_5752_();
                buffer.m_252986_(matrix4f, (float)x1, (float)y1, (float)z1).m_193479_(-1).m_252939_(normal, f, f1, f2).m_5752_();
            });
        }
        if (this.drawRenderingBoxFrameLines && (aabb = this.previewMachine.getMachineState().getRenderingBox(null)) != null) {
            int color = -1123072;
            RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)aabb.f_82288_), (float)((float)aabb.f_82289_), (float)((float)aabb.f_82290_), (float)((float)aabb.f_82291_), (float)((float)aabb.f_82292_), (float)((float)aabb.f_82293_), (float)ColorUtils.red((int)color), (float)ColorUtils.green((int)color), (float)ColorUtils.blue((int)color), (float)ColorUtils.alpha((int)color));
        }
        if (drawFrameLines) {
            tessellator.m_85914_();
            poseStack.m_85849_();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
        }
    }

    public MachineEditor getEditor() {
        return this.editor;
    }

    public TrackedDummyWorld getLevel() {
        return this.level;
    }

    public SceneWidget getScene() {
        return this.scene;
    }

    public WidgetGroup getButtonGroup() {
        return this.buttonGroup;
    }

    @Nullable
    public MBDMachine getPreviewMachine() {
        return this.previewMachine;
    }

    public boolean isDrawShapeFrameLines() {
        return this.drawShapeFrameLines;
    }

    public boolean isDrawRenderingBoxFrameLines() {
        return this.drawRenderingBoxFrameLines;
    }

    public void setDrawShapeFrameLines(boolean drawShapeFrameLines) {
        this.drawShapeFrameLines = drawShapeFrameLines;
    }

    public void setDrawRenderingBoxFrameLines(boolean drawRenderingBoxFrameLines) {
        this.drawRenderingBoxFrameLines = drawRenderingBoxFrameLines;
    }
}

