/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.StringTabContainer;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.pattern.BlockPattern;
import com.lowdragmc.mbd2.api.pattern.MultiblockShapeInfo;
import com.lowdragmc.mbd2.api.pattern.TraceabilityPredicate;
import com.lowdragmc.mbd2.api.pattern.predicates.PredicateBlocks;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import com.lowdragmc.mbd2.api.pattern.util.RelativeDirection;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.gui.editor.PredicateResource;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.BlockPlaceholder;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.MultiblockAreaPanel;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.MultiblockPatternPanel;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.MultiblockShapeInfoPanel;
import com.lowdragmc.mbd2.common.machine.definition.MultiblockMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.StateMachine;
import com.lowdragmc.mbd2.utils.ControllerBlockInfo;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;

@LDLRegister(name="mb", group="editor.machine")
public class MultiblockMachineProject
extends MachineProject {
    protected BlockPlaceholder[][][] blockPlaceholders;
    protected Direction.Axis layerAxis = Direction.Axis.Y;
    protected int[][] aisleRepetitions;
    protected PredicateResource predicateResource;
    protected List<MultiblockShapeInfo> multiblockShapeInfos = new ArrayList<MultiblockShapeInfo>();

    public MultiblockMachineProject(Resources resources, MultiblockMachineDefinition definition, WidgetGroup ui) {
        super(resources, definition, ui);
        this.blockPlaceholders = new BlockPlaceholder[1][1][1];
        Object v = resources.resources.get("mbd2.gui.editor.group.predicate");
        if (v instanceof PredicateResource) {
            PredicateResource resource;
            this.predicateResource = resource = (PredicateResource)((Object)v);
            this.blockPlaceholders[0][0][0] = BlockPlaceholder.controller(this.predicateResource, new Either[0]);
            this.setBlockPlaceholders(this.blockPlaceholders);
        }
    }

    @Override
    protected Map<String, Resource<?>> createResources() {
        Map<String, Resource<?>> resources = super.createResources();
        PredicateResource predicate = new PredicateResource();
        resources.put("mbd2.gui.editor.group.predicate", predicate);
        return resources;
    }

    @Override
    public MultiblockMachineDefinition getDefinition() {
        return (MultiblockMachineDefinition)super.getDefinition();
    }

    @Override
    protected MultiblockMachineDefinition createDefinition() {
        MultiblockMachineDefinition.Builder builder = MultiblockMachineDefinition.builder();
        builder.id(MBD2.id("new_machine")).rootState((MachineState)StateMachine.createMultiblockDefault(MachineState::builder, FURNACE_RENDERER));
        return builder.build();
    }

    public void setLayerAxis(Direction.Axis layerAxis) {
        this.layerAxis = layerAxis;
        int aisleLength = switch (layerAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> this.blockPlaceholders.length;
            case Direction.Axis.Y -> this.blockPlaceholders[0].length;
            case Direction.Axis.Z -> this.blockPlaceholders[0][0].length;
        };
        for (int[] aisleRepetition : this.aisleRepetitions = new int[aisleLength][2]) {
            aisleRepetition[0] = 1;
            aisleRepetition[1] = 1;
        }
    }

    public void setBlockPlaceholders(BlockPlaceholder[][][] blockPlaceholders) {
        this.blockPlaceholders = blockPlaceholders;
        this.setLayerAxis(this.layerAxis);
    }

    public static BlockPattern createBlockPattern(BlockPlaceholder[][][] blockPlaceholders, Direction.Axis layerAxis, int[][] aisleRepetitions, MultiblockMachineDefinition definition) {
        return MultiblockMachineProject.createBlockPattern(blockPlaceholders, layerAxis, aisleRepetitions, definition, false);
    }

    public static BlockPattern createBlockPattern(BlockPlaceholder[][][] blockPlaceholders, Direction.Axis layerAxis, int[][] aisleRepetitions, MultiblockMachineDefinition definition, boolean shapeInfo) {
        int aisleLength = switch (layerAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> blockPlaceholders.length;
            case Direction.Axis.Y -> blockPlaceholders[0].length;
            case Direction.Axis.Z -> blockPlaceholders[0][0].length;
        };
        int aisleHeight = switch (layerAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> blockPlaceholders[0].length;
            case Direction.Axis.Y -> blockPlaceholders.length;
            case Direction.Axis.Z -> blockPlaceholders.length;
        };
        int rowWidth = switch (layerAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> blockPlaceholders[0][0].length;
            case Direction.Axis.Y -> blockPlaceholders[0][0].length;
            case Direction.Axis.Z -> blockPlaceholders[0].length;
        };
        TraceabilityPredicate[][][] predicate = new TraceabilityPredicate[aisleLength][aisleHeight][rowWidth];
        BlockPlaceholder controller = null;
        int x = 0;
        int min = 0;
        int max = 0;
        int[] centerOffset = new int[5];
        for (BlockPlaceholder[][] xSlice : blockPlaceholders) {
            int y = 0;
            for (BlockPlaceholder[] ySlice : xSlice) {
                int z = 0;
                for (BlockPlaceholder placeholder : ySlice) {
                    TraceabilityPredicate traceabilityPredicate = placeholder.getPredicates().stream().map(arg_0 -> ((PredicateResource)placeholder.getPredicateResource()).getResource(arg_0)).filter(Objects::nonNull).map(TraceabilityPredicate::new).reduce(TraceabilityPredicate::or).orElse(new TraceabilityPredicate());
                    if (placeholder.isController()) {
                        controller = placeholder;
                        centerOffset = Direction.Axis.X == layerAxis ? new int[]{z, y, x, min, max} : (Direction.Axis.Y == layerAxis ? new int[]{z, x, y, min, max} : new int[]{y, x, z, min, max});
                        if (shapeInfo) {
                            traceabilityPredicate = new TraceabilityPredicate(new SimplePredicate(state -> state.getBlockState().m_60734_() == MBDRegistries.FAKE_MACHINE().block(), () -> new BlockInfo[]{new ControllerBlockInfo()}));
                        } else {
                            if (definition.multiblockSettings().catalyst().isEnable() && definition.multiblockSettings().catalyst().getCandidates().isEnable()) {
                                for (Block block : definition.multiblockSettings().catalyst().getCandidates().getValue()) {
                                    traceabilityPredicate = new TraceabilityPredicate(new PredicateBlocks(block)).or(traceabilityPredicate);
                                }
                            }
                            traceabilityPredicate = new TraceabilityPredicate(new PredicateBlocks(definition.block())).or(traceabilityPredicate);
                        }
                    }
                    if (Direction.Axis.X == layerAxis) {
                        predicate[x][y][z] = traceabilityPredicate;
                    } else if (Direction.Axis.Y == layerAxis) {
                        predicate[y][x][z] = traceabilityPredicate;
                    } else {
                        predicate[z][x][y] = traceabilityPredicate;
                    }
                    if (layerAxis == Direction.Axis.Z) {
                        min += aisleRepetitions[z][0];
                        max += aisleRepetitions[z][1];
                    }
                    ++z;
                }
                if (layerAxis == Direction.Axis.Y) {
                    min += aisleRepetitions[y][0];
                    max += aisleRepetitions[y][1];
                } else if (layerAxis == Direction.Axis.Z) {
                    min = 0;
                    max = 0;
                }
                ++y;
            }
            if (layerAxis == Direction.Axis.X) {
                min += aisleRepetitions[x][0];
                max += aisleRepetitions[x][1];
            } else if (layerAxis == Direction.Axis.Y) {
                min = 0;
                max = 0;
            }
            ++x;
        }
        Direction controllerFace = controller.getFacing().m_122434_() == Direction.Axis.Y ? Direction.NORTH : controller.getFacing();
        RelativeDirection[] structureDir = new RelativeDirection[]{RelativeDirection.getSliceYDirection(layerAxis, controllerFace), RelativeDirection.getSliceXDirection(layerAxis, controllerFace), RelativeDirection.getAisleDirection(layerAxis, controllerFace)};
        return new BlockPattern(predicate, structureDir, aisleRepetitions, centerOffset);
    }

    @Override
    public MultiblockMachineProject newEmptyProject() {
        return new MultiblockMachineProject(new Resources(this.createResources()), this.createDefinition(), this.createDefaultUI());
    }

    @Override
    public File getProjectWorkSpace(Editor editor) {
        return new File(editor.getWorkSpace(), "multiblock");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("placeholders", (Tag)MultiblockMachineProject.serializeBlockPlaceholders(this.blockPlaceholders));
        tag.m_128359_("layer_axis", this.layerAxis.name());
        tag.m_128385_("aisle_repetitions", Arrays.stream(this.aisleRepetitions).flatMapToInt(Arrays::stream).toArray());
        ListTag shapeInfoList = new ListTag();
        for (MultiblockShapeInfo shapeInfo : this.getMultiblockShapeInfos()) {
            shapeInfoList.add((Object)shapeInfo.serializeNBT());
        }
        tag.m_128365_("shape_infos", (Tag)shapeInfoList);
        return tag;
    }

    public static CompoundTag serializeBlockPlaceholders(BlockPlaceholder[][][] blockPlaceholders) {
        ArrayList<BlockPlaceholder> placeholders = new ArrayList<BlockPlaceholder>();
        HashMap<BlockPlaceholder, Integer> placeHolderMap = new HashMap<BlockPlaceholder, Integer>();
        ArrayList<Integer> placeHolderIndex = new ArrayList<Integer>();
        BlockPlaceholder[][][] blockPlaceholderArray = blockPlaceholders;
        int n = blockPlaceholderArray.length;
        for (int j = 0; j < n; ++j) {
            BlockPlaceholder[][] blockPlaceholder;
            BlockPlaceholder[][] blockPlaceholderArray2 = blockPlaceholder = blockPlaceholderArray[j];
            int n2 = blockPlaceholderArray2.length;
            for (int k = 0; k < n2; ++k) {
                BlockPlaceholder[] value;
                for (BlockPlaceholder holder : value = blockPlaceholderArray2[k]) {
                    if (holder != null) {
                        if (!placeHolderMap.containsKey(holder)) {
                            placeHolderMap.put(holder, placeholders.size());
                            placeholders.add(holder);
                        }
                        placeHolderIndex.add((Integer)placeHolderMap.get(holder));
                        continue;
                    }
                    placeHolderIndex.add(-1);
                }
            }
        }
        CompoundTag placeHoldersTag = new CompoundTag();
        ListTag placeHoldersListTag = new ListTag();
        for (BlockPlaceholder placeholder : placeholders) {
            placeHoldersListTag.add((Object)placeholder.serializeNBT());
        }
        placeHoldersTag.m_128365_("holders", (Tag)placeHoldersListTag);
        placeHoldersTag.m_128405_("x", blockPlaceholders.length);
        placeHoldersTag.m_128405_("y", blockPlaceholders[0].length);
        placeHoldersTag.m_128405_("z", blockPlaceholders[0][0].length);
        placeHoldersTag.m_128385_("pattern", placeHolderIndex.stream().mapToInt(i -> i).toArray());
        return placeHoldersTag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        Object v = this.resources.resources.get("mbd2.gui.editor.group.predicate");
        if (v instanceof PredicateResource) {
            PredicateResource resource;
            this.predicateResource = resource = (PredicateResource)((Object)v);
        }
        CompoundTag placeHoldersTag = tag.m_128469_("placeholders");
        int x = placeHoldersTag.m_128451_("x");
        int y = placeHoldersTag.m_128451_("y");
        int z = placeHoldersTag.m_128451_("z");
        this.blockPlaceholders = MultiblockMachineProject.deserializeBlockPlaceholders(placeHoldersTag, this.predicateResource);
        this.layerAxis = Direction.Axis.valueOf((String)tag.m_128461_("layer_axis"));
        int aisleLength = switch (this.layerAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> x;
            case Direction.Axis.Y -> y;
            case Direction.Axis.Z -> z;
        };
        this.aisleRepetitions = new int[aisleLength][2];
        int[] repetitions = tag.m_128465_("aisle_repetitions");
        for (int i = 0; i < aisleLength; ++i) {
            this.aisleRepetitions[i][0] = repetitions[i * 2];
            this.aisleRepetitions[i][1] = repetitions[i * 2 + 1];
        }
        this.multiblockShapeInfos.clear();
        ListTag shapeInfoList = tag.m_128437_("shape_infos", 10);
        this.multiblockShapeInfos.addAll(shapeInfoList.stream().map(CompoundTag.class::cast).map(MultiblockShapeInfo::loadFromTag).toList());
    }

    public static BlockPlaceholder[][][] deserializeBlockPlaceholders(CompoundTag placeHoldersTag, PredicateResource predicateResource) {
        ListTag placeHoldersListTag = placeHoldersTag.m_128437_("holders", 10);
        int x = placeHoldersTag.m_128451_("x");
        int y = placeHoldersTag.m_128451_("y");
        int z = placeHoldersTag.m_128451_("z");
        int[] pattern = placeHoldersTag.m_128465_("pattern");
        BlockPlaceholder[][][] blockPlaceholders = new BlockPlaceholder[x][y][z];
        for (int i = 0; i < pattern.length; ++i) {
            BlockPlaceholder holder;
            int index = pattern[i];
            blockPlaceholders[i / (y * z)][i / z % y][i % z] = holder = index == -1 ? BlockPlaceholder.create(predicateResource, Either.left((Object)"any")) : BlockPlaceholder.fromTag(predicateResource, placeHoldersListTag.m_128728_(index));
        }
        return blockPlaceholders;
    }

    @Override
    public void onLoad(Editor editor) {
        if (editor instanceof MachineEditor) {
            MachineEditor machineEditor = (MachineEditor)editor;
            super.onLoad(editor);
            StringTabContainer tabContainer = machineEditor.getTabPages();
            MultiblockPatternPanel multiblockPatternPanel = this.createMultiblockPatternPanel(machineEditor);
            MultiblockAreaPanel multiblockAreaPanel = this.createMultiblockAreaPanel(multiblockPatternPanel);
            MultiblockShapeInfoPanel MultiblockShapeInfoPanel2 = this.createMultiblockShapeInfoPanel(machineEditor);
            tabContainer.addTab("editor.machine.multiblock_area", (WidgetGroup)multiblockAreaPanel, multiblockAreaPanel::onPanelSelected, multiblockAreaPanel::onPanelDeselected);
            tabContainer.addTab("editor.machine.multiblock_pattern", (WidgetGroup)multiblockPatternPanel, multiblockPatternPanel::onPanelSelected, multiblockPatternPanel::onPanelDeselected);
            tabContainer.addTab("editor.machine.multiblock.multiblock_shape_info", (WidgetGroup)MultiblockShapeInfoPanel2, MultiblockShapeInfoPanel2::onPanelSelected, MultiblockShapeInfoPanel2::onPanelDeselected);
        }
    }

    public MultiblockPatternPanel createMultiblockPatternPanel(MachineEditor editor) {
        return new MultiblockPatternPanel(editor, this);
    }

    public MultiblockAreaPanel createMultiblockAreaPanel(MultiblockPatternPanel multiblockPatternPanel) {
        return new MultiblockAreaPanel(this, multiblockPatternPanel);
    }

    public MultiblockShapeInfoPanel createMultiblockShapeInfoPanel(MachineEditor editor) {
        return new MultiblockShapeInfoPanel(editor, this);
    }

    public BlockPlaceholder[][][] getBlockPlaceholders() {
        return this.blockPlaceholders;
    }

    public Direction.Axis getLayerAxis() {
        return this.layerAxis;
    }

    public int[][] getAisleRepetitions() {
        return this.aisleRepetitions;
    }

    public PredicateResource getPredicateResource() {
        return this.predicateResource;
    }

    public List<MultiblockShapeInfo> getMultiblockShapeInfos() {
        return this.multiblockShapeInfos;
    }

    public MultiblockMachineProject() {
    }
}

