/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.graphprocessor.node;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;

@LDLRegister(name="modify recipe", group="graph_processor.node.mbd2.machine.recipe")
public class ModifyRecipeNode
extends BaseNode {
    @InputPort
    public MBDRecipe in;
    @InputPort(name="content modifier")
    public ContentModifier contentModifier;
    @InputPort(name="content side")
    public IO contentIO;
    @InputPort(name="duration modifier")
    public ContentModifier durationModifier;
    @OutputPort
    public MBDRecipe out;
    @Configurable(name="content side")
    public IO internalContentIO = IO.BOTH;

    protected void process() {
        this.out = this.in;
        if (this.in != null) {
            IO io;
            boolean copied = false;
            IO iO = io = this.contentIO == null ? this.internalContentIO : this.contentIO;
            if (this.contentModifier != null && !this.contentModifier.isIdentity() && io != IO.NONE) {
                this.out = this.in.copy(this.contentModifier, false, io);
                copied = true;
            }
            if (this.durationModifier != null && !this.durationModifier.isIdentity()) {
                if (copied) {
                    this.out.duration = this.durationModifier.apply(this.out.duration).intValue();
                } else {
                    this.out = this.in.copy(this.durationModifier, true, IO.NONE);
                }
            }
        }
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("contentIO") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

