/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.event;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeSerializer;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.CommonProxy;
import com.lowdragmc.mbd2.common.data.MBDMachineDefinitionTypes;
import com.lowdragmc.mbd2.common.data.MBDTraitDefinitionTypes;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MBDRegistryEvent
extends Event
implements IModBusEvent {

    public static class TraitType
    extends MBDRegistryEvent {
        public void register(Class<? extends TraitDefinition> clazz) {
            MBDTraitDefinitionTypes.register(clazz);
        }
    }

    public static class MachineDefinitionType
    extends MBDRegistryEvent {
        public <T extends MBDMachineDefinition> void register(Class<T> clazz, Supplier<T> creator) {
            MBDMachineDefinitionTypes.register(clazz, creator);
        }
    }

    public static class RecipeCapability
    extends MBDRegistryEvent {
        public void register(String id, com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability<?> capability) {
            MBDRegistries.RECIPE_CAPABILITIES.register(id, capability);
        }
    }

    public static class RecipeCondition
    extends MBDRegistryEvent {
        public void register(String id, Class<? extends com.lowdragmc.mbd2.api.recipe.RecipeCondition> condition) {
            MBDRegistries.RECIPE_CONDITIONS.register(id, condition);
        }
    }

    public static class MBDRecipeType
    extends MBDRegistryEvent {
        public void register(com.lowdragmc.mbd2.api.recipe.MBDRecipeType recipeType) {
            ForgeRegistries.RECIPE_TYPES.register(recipeType.getRegistryName(), (Object)recipeType);
            ForgeRegistries.RECIPE_SERIALIZERS.register(recipeType.getRegistryName(), (Object)new MBDRecipeSerializer());
            MBDRegistries.RECIPE_TYPES.register(recipeType.getRegistryName(), recipeType);
        }

        public void registerFromFile(File file) {
            try {
                CompoundTag tag = NbtIo.m_128953_((File)file);
                if (tag == null) {
                    throw new Exception("tag is null");
                }
                this.register(com.lowdragmc.mbd2.api.recipe.MBDRecipeType.createDefault().loadProductiveTag(null, tag, CommonProxy.getPostTask()));
            }
            catch (Exception e) {
                LDLib.LOGGER.error("error could not load the project from file {}", (Object)file, (Object)e);
            }
        }

        public void registerFromResource(Class<?> source, String projectFile) {
            InputStream inputstream = source.getResourceAsStream(String.format("/assets/%s", projectFile));
            if (inputstream == null) {
                LDLib.LOGGER.error("error could not find the project from resource {}", (Object)projectFile);
                return;
            }
            try {
                CompoundTag tag = NbtIo.m_128928_((DataInput)new DataInputStream(inputstream));
                this.register(com.lowdragmc.mbd2.api.recipe.MBDRecipeType.createDefault().loadProductiveTag(null, tag, CommonProxy.getPostTask()));
            }
            catch (Exception e) {
                LDLib.LOGGER.error("error could not load the project from resource {}", (Object)projectFile, (Object)e);
            }
        }
    }

    public static class Machine
    extends MBDRegistryEvent {
        public void register(MBDMachineDefinition definition) {
            MBDRegistries.MACHINE_DEFINITIONS.register(definition.id(), definition);
        }

        public void registerFromFile(String type, File file) {
            AnnotationDetector.Wrapper definitionType = (AnnotationDetector.Wrapper)MBDRegistries.MACHINE_DEFINITION_TYPES.get(type);
            if (definitionType == null) {
                LDLib.LOGGER.error("error could not find the definition type {} from file {}", (Object)type, (Object)file);
                return;
            }
            try {
                CompoundTag tag = NbtIo.m_128953_((File)file);
                if (tag == null) {
                    throw new Exception("tag is null");
                }
                this.register(((MBDMachineDefinition)definitionType.creator().get()).loadProductiveTag(null, tag, CommonProxy.getPostTask()));
            }
            catch (Exception e) {
                LDLib.LOGGER.error("error could not load the project from file {}", (Object)file, (Object)e);
            }
        }

        public void registerFromResource(Class<?> source, String type, String projectFile) {
            AnnotationDetector.Wrapper definitionType = (AnnotationDetector.Wrapper)MBDRegistries.MACHINE_DEFINITION_TYPES.get(type);
            if (definitionType == null) {
                LDLib.LOGGER.error("error could not find the definition type {} from resource {}", (Object)type, (Object)projectFile);
                return;
            }
            InputStream inputstream = source.getResourceAsStream(String.format("/assets/%s", projectFile));
            if (inputstream == null) {
                LDLib.LOGGER.error("error could not find the project from resource {}", (Object)projectFile);
                return;
            }
            try {
                CompoundTag tag = NbtIo.m_128928_((DataInput)new DataInputStream(inputstream));
                this.register(((MBDMachineDefinition)definitionType.creator().get()).loadProductiveTag(null, tag, CommonProxy.getPostTask()));
            }
            catch (Exception e) {
                LDLib.LOGGER.error("error could not load the project from resource {}", (Object)projectFile, (Object)e);
            }
        }
    }
}

