/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.capability.recipe;

import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.SerializerInteger;
import com.lowdragmc.mbd2.common.gui.recipe.CornerNumberWidget;
import com.lowdragmc.mbd2.utils.EnergyFormattingUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

public class ForgeEnergyRecipeCapability
extends RecipeCapability<Integer> {
    public static final ForgeEnergyRecipeCapability CAP = new ForgeEnergyRecipeCapability();
    public static final ResourceTexture ENERGY_BAR = new ResourceTexture("mbd2:textures/gui/energy_bar_base.png");
    public static final ResourceBorderTexture ENERGY_BASE = new ResourceBorderTexture("mbd2:textures/gui/energy_bar_background.png", 42, 14, 1, 1);

    protected ForgeEnergyRecipeCapability() {
        super("forge_energy", SerializerInteger.INSTANCE);
    }

    @Override
    public Integer createDefaultContent() {
        return 512;
    }

    @Override
    public Widget createPreviewWidget(Integer content) {
        WidgetGroup previewGroup = new WidgetGroup(0, 0, 18, 18);
        previewGroup.setBackground(new IGuiTexture[]{new ResourceTexture("mbd2:textures/gui/forge_energy.png")});
        previewGroup.addWidget((Widget)new CornerNumberWidget(0, 0, 18, 18).setValue(content.intValue()));
        return previewGroup;
    }

    @Override
    public Widget createXEITemplate() {
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 50, 14, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)ENERGY_BAR));
        energyBar.setBackground(new IGuiTexture[]{ENERGY_BASE});
        energyBar.setOverlay((IGuiTexture)new TextTexture("0 FE"));
        return energyBar;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof ProgressWidget) {
            ProgressWidget energyBar = (ProgressWidget)widget;
            String energy = EnergyFormattingUtil.formatExtended(((Integer)this.of(content.content)).intValue());
            IGuiTexture iGuiTexture = energyBar.getOverlay();
            if (iGuiTexture instanceof TextTexture) {
                TextTexture textTexture = (TextTexture)iGuiTexture;
                if (content.perTick) {
                    textTexture.updateText(energy + "FE/t");
                } else {
                    textTexture.updateText(energy + "FE");
                }
            }
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<Integer> supplier, Consumer<Integer> onUpdate) {
        Configurator[] configuratorArray = new Configurator[1];
        configuratorArray[0] = new NumberConfigurator("recipe.capability.forge_energy.energy", supplier::get, number -> onUpdate.accept(number.intValue()), (Number)1, true).setRange((Number)1, (Number)Integer.MAX_VALUE);
        father.addConfigurators(configuratorArray);
    }

    @Override
    public Component getLeftErrorInfo(List<Integer> left) {
        return Component.m_237113_((String)(left.stream().mapToInt(Integer::intValue).sum() + " fe"));
    }
}

