/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.capability.recipe;

import com.lowdragmc.lowdraglib.gui.editor.accessors.CompoundTagAccessor;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorSelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.SerializerEntityIngredient;
import com.lowdragmc.mbd2.api.recipe.ingredient.EntityIngredient;
import com.lowdragmc.mbd2.common.gui.recipe.ingredient.entity.EntityPreviewWidget;
import com.lowdragmc.mbd2.common.gui.recipe.ingredient.entity.EntityTypeConfigurator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class EntityRecipeCapability
extends RecipeCapability<EntityIngredient> {
    public static final String ENTITY_TYPE = "recipe.capability.entity.ingredient.values.entity";
    public static final String TAG_TYPE = "recipe.capability.entity.ingredient.values.tag";
    public static final EntityRecipeCapability CAP = new EntityRecipeCapability();

    protected EntityRecipeCapability() {
        super("entity", SerializerEntityIngredient.INSTANCE);
    }

    @Override
    public EntityIngredient createDefaultContent() {
        return EntityIngredient.of(1, EntityType.f_20510_);
    }

    @Override
    public Widget createPreviewWidget(EntityIngredient content) {
        return new EntityPreviewWidget(content, 0, 0, 18, 18).setDrawHoverOverlay(false);
    }

    @Override
    public Widget createXEITemplate() {
        EntityPreviewWidget preview = new EntityPreviewWidget();
        preview.initTemplate();
        return preview;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof EntityPreviewWidget) {
            EntityPreviewWidget entityPreview = (EntityPreviewWidget)widget;
            EntityIngredient entityIngredient = (EntityIngredient)this.of(content.content);
            entityPreview.setEntityIngredient(entityIngredient);
            entityPreview.setIngredientIO(ingredientIO);
            entityPreview.setXEIChance(content.chance);
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<EntityIngredient> supplier, Consumer<EntityIngredient> onUpdate) {
        father.addConfigurators(new Configurator[]{new NumberConfigurator("recipe.capability.entity.ingredient.count", () -> ((EntityIngredient)supplier.get()).getCount(), number -> {
            int amount = number.intValue();
            onUpdate.accept(((EntityIngredient)supplier.get()).copy(amount));
        }, (Number)1, true).setRange((Number)1, (Number)Integer.MAX_VALUE)});
        ArrayConfiguratorGroup valuesGroup = new ArrayConfiguratorGroup("recipe.capability.entity.ingredient.candidates", false, () -> Arrays.stream(((EntityIngredient)supplier.get()).values).collect(Collectors.toList()), (getter, setter) -> new ConfiguratorSelectorConfigurator("recipe.capability.item.ingredient.values.type", false, getter, setter, (Object)new EntityIngredient.EntityTypeValue(EntityType.f_20510_), true, List.of(new EntityIngredient.EntityTypeValue(EntityType.f_20510_), new EntityIngredient.TagValue(EntityTypeTags.f_13120_)), value -> {
            if (value instanceof EntityIngredient.EntityTypeValue) {
                return ENTITY_TYPE;
            }
            if (value instanceof EntityIngredient.TagValue) {
                return TAG_TYPE;
            }
            return ENTITY_TYPE;
        }, (arg_0, arg_1) -> EntityRecipeCapability.lambda$createContentConfigurator$8((Supplier)supplier, setter, arg_0, arg_1)), true);
        valuesGroup.setAddDefault(() -> new EntityIngredient.EntityTypeValue(EntityType.f_20510_));
        valuesGroup.setOnAdd(value -> {
            EntityIngredient entityIngredient = (EntityIngredient)supplier.get();
            EntityIngredient.Value[] values = entityIngredient.values;
            EntityIngredient.Value[] newValues = Arrays.copyOf(values, values.length + 1);
            newValues[values.length] = value;
            entityIngredient.values = newValues;
            entityIngredient.types = null;
        });
        valuesGroup.setOnRemove(value -> {
            EntityIngredient entityIngredient = (EntityIngredient)supplier.get();
            EntityIngredient.Value[] values = entityIngredient.values;
            entityIngredient.values = (EntityIngredient.Value[])Arrays.stream(values).filter(v -> v != value).toArray(EntityIngredient.Value[]::new);
            entityIngredient.types = null;
        });
        valuesGroup.setOnUpdate(values -> {
            EntityIngredient entityIngredient = (EntityIngredient)supplier.get();
            entityIngredient.values = (EntityIngredient.Value[])values.toArray(EntityIngredient.Value[]::new);
            entityIngredient.types = null;
        });
        father.addConfigurators(new Configurator[]{valuesGroup});
        try {
            father.addConfigurators(new Configurator[]{new CompoundTagAccessor().create("ldlib.gui.editor.configurator.nbt", () -> Optional.ofNullable(((EntityIngredient)supplier.get()).getNbt()).orElseGet(CompoundTag::new), tag -> {
                CompoundTag newTag;
                EntityIngredient entityIngredient = (EntityIngredient)supplier.get();
                CompoundTag compoundTag = newTag = tag.m_128456_() ? null : tag;
                if (Objects.equals(newTag, entityIngredient.getNbt())) {
                    return;
                }
                entityIngredient.setNbt(newTag);
                onUpdate.accept(entityIngredient);
            }, false, RecipeCapability.class.getField("name"))});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getLeftErrorInfo(List<EntityIngredient> left) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < left.size(); ++i) {
            EntityIngredient entityIngredient = left.get(i);
            result.m_130946_(entityIngredient.getCount() + "x ");
            EntityType<?>[] types = entityIngredient.getTypes();
            if (types.length > 0) {
                result.m_7220_(types[0].m_20676_());
            } else {
                result.m_130946_("Unknown");
            }
            if (entityIngredient.getNbt() != null) {
                result.m_130946_(" with NBT");
                result.m_130946_(entityIngredient.getNbt().toString());
            }
            if (i >= left.size() - 1) continue;
            result.m_130946_(", ");
        }
        return result;
    }

    private static /* synthetic */ void lambda$createContentConfigurator$8(Supplier supplier, Consumer setter, EntityIngredient.Value value, ConfiguratorSelectorConfigurator valueGroup) {
        EntityPreviewWidget preview = new EntityPreviewWidget(EntityIngredient.fromValues(Stream.of(value), 1, ((EntityIngredient)supplier.get()).getNbt()), 0, 0, 60, 60);
        preview.setBackground(new IGuiTexture[]{TankWidget.FLUID_SLOT_TEXTURE});
        preview.setShowAmount(false);
        preview.setClientSideWidget();
        if (value instanceof EntityIngredient.EntityTypeValue) {
            EntityIngredient.EntityTypeValue entityTypeValue = (EntityIngredient.EntityTypeValue)value;
            Configurator[] configuratorArray = new Configurator[1];
            configuratorArray[0] = new EntityTypeConfigurator(ENTITY_TYPE, entityTypeValue::getEntityType, arg_0 -> EntityRecipeCapability.lambda$createContentConfigurator$4(entityTypeValue, preview, value, (Supplier)supplier, setter, arg_0), EntityType.f_20510_, true);
            valueGroup.addConfigurators(configuratorArray);
        } else if (value instanceof EntityIngredient.TagValue) {
            EntityIngredient.TagValue tagValue = (EntityIngredient.TagValue)value;
            valueGroup.addConfigurators(new Configurator[]{new SearchComponentConfigurator(TAG_TYPE, () -> tagValue.getTag().f_203868_(), arg_0 -> EntityRecipeCapability.lambda$createContentConfigurator$6(tagValue, preview, value, (Supplier)supplier, setter, arg_0), (Object)EntityTypeTags.f_13120_.f_203868_(), true, (word, find) -> {
                ITagManager tags = ForgeRegistries.ENTITY_TYPES.tags();
                if (tags == null) {
                    return;
                }
                for (ITag tag : tags) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    ResourceLocation tagKey = tag.getKey().f_203868_();
                    if (!tagKey.toString().toLowerCase().contains(word.toLowerCase())) continue;
                    find.accept(tagKey);
                }
            }, ResourceLocation::toString)});
        }
        valueGroup.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", (Widget)preview)});
    }

    private static /* synthetic */ void lambda$createContentConfigurator$6(EntityIngredient.TagValue tagValue, EntityPreviewWidget preview, EntityIngredient.Value value, Supplier supplier, Consumer setter, ResourceLocation tagKey) {
        tagValue.setTag(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagKey));
        preview.setEntityIngredient(EntityIngredient.of(value.getTypes().stream(), 1, ((EntityIngredient)supplier.get()).getNbt()));
        setter.accept(value);
    }

    private static /* synthetic */ void lambda$createContentConfigurator$4(EntityIngredient.EntityTypeValue entityTypeValue, EntityPreviewWidget preview, EntityIngredient.Value value, Supplier supplier, Consumer setter, EntityType entityType) {
        entityTypeValue.setEntityType(entityType);
        preview.setEntityIngredient(EntityIngredient.of(value.getTypes().stream(), 1, ((EntityIngredient)supplier.get()).getNbt()));
        setter.accept(value);
    }
}

