/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.blockentity;

import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.capability.MBDCapabilities;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineBlockEntity
extends BlockEntity
implements IMachineBlockEntity {
    public final MultiManagedStorage rootStorage = new MultiManagedStorage();
    private final long offset = MBD2.RND.nextLong();
    private IMachine metaMachine;

    public MachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, Function<IMachineBlockEntity, IMachine> machineFactory) {
        super(type, pos, blockState);
        this.setMachine(machineFactory.apply(this));
    }

    public void setMachine(IMachine newMachine) {
        IMachine iMachine;
        if (this.metaMachine == newMachine) {
            return;
        }
        if (this.metaMachine != null && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.metaMachine.onUnload();
        }
        if ((iMachine = this.metaMachine) instanceof MBDMachine) {
            MBDMachine machine = (MBDMachine)iMachine;
            machine.detach();
        }
        this.metaMachine = newMachine;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.getMetaMachine().onChunkUnloaded();
    }

    public void m_7651_() {
        super.m_7651_();
        this.getMetaMachine().onUnload();
    }

    public void m_6339_() {
        super.m_6339_();
        this.getMetaMachine().onLoad();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        MBDMachine machine;
        LazyOptional<T> result;
        if (cap == MBDCapabilities.CAPABILITY_MACHINE) {
            return MBDCapabilities.CAPABILITY_MACHINE.orEmpty(cap, LazyOptional.of(this::getMetaMachine));
        }
        IMachine iMachine = this.metaMachine;
        if (iMachine instanceof MBDMachine && (result = (machine = (MBDMachine)iMachine).getCapability(cap, side)).isPresent()) {
            return result;
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        MBDMachine machine;
        AABB value;
        IMachine iMachine = this.metaMachine;
        if (iMachine instanceof MBDMachine && (value = (machine = (MBDMachine)iMachine).getRenderBoundingBox()) != null) {
            return value;
        }
        return super.getRenderBoundingBox();
    }

    public MultiManagedStorage getRootStorage() {
        return this.rootStorage;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public IMachine getMetaMachine() {
        return this.metaMachine;
    }
}

