/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common;

import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.pattern.MultiblockState;
import com.lowdragmc.mbd2.api.pattern.MultiblockWorldSavedData;
import com.lowdragmc.mbd2.common.ServerCommands;
import com.lowdragmc.mbd2.common.item.MBDGadgetsItem;
import com.lowdragmc.mbd2.common.machine.MBDMultiblockMachine;
import com.lowdragmc.mbd2.common.machine.definition.MultiblockMachineDefinition;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mbd2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeCommonEventListener {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ServerCommands.createServerCommands().forEach(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0));
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            BlockState originalState;
            Block hitBlock;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = event.getPos();
            if (!event.getEntity().m_6047_() && !(event.getEntity().m_21120_(event.getHand()).m_41720_() instanceof MBDGadgetsItem)) {
                for (MultiblockState state : MultiblockWorldSavedData.getOrCreate(serverLevel).getControllerInPos(pos)) {
                    MBDMultiblockMachine machine;
                    LongSet openUIMask = (LongSet)state.getMatchContext().getOrDefault("openUIMask", LongSets.EMPTY_SET);
                    IMultiController iMultiController = state.getController();
                    if (!(iMultiController instanceof MBDMultiblockMachine) || !(machine = (MBDMultiblockMachine)iMultiController).getDefinition().machineSettings().hasUI() || !machine.getDefinition().multiblockSettings().showUIWhenClickStructure() || !openUIMask.contains(pos.m_121878_())) continue;
                    machine.openUI(event.getEntity());
                    event.setUseBlock(Event.Result.ALLOW);
                    event.setUseItem(Event.Result.DENY);
                    return;
                }
            }
            if (MultiblockMachineDefinition.CATALYST_CANDIDATES.containsKey(hitBlock = (originalState = serverLevel.m_8055_(pos)).m_60734_())) {
                ItemStack held = event.getItemStack();
                Set<MultiblockMachineDefinition> definitions = MultiblockMachineDefinition.CATALYST_CANDIDATES.get(hitBlock);
                for (MultiblockMachineDefinition definition : definitions) {
                    if (!definition.multiblockSettings().catalyst().test(held)) continue;
                    MultiblockState multiblockState = new MultiblockState((Level)serverLevel, pos);
                    for (Direction facing : new Direction[]{Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST}) {
                        if (!definition.blockPatternFactory().apply(null).checkPatternAtWithoutController(multiblockState, facing)) continue;
                        BlockState controllerState = definition.block().m_49966_();
                        if (definition.blockProperties().rotationState().property.isPresent()) {
                            controllerState = (BlockState)controllerState.m_61124_((Property)definition.blockProperties().rotationState().property.get(), (Comparable)facing);
                        }
                        serverLevel.m_46597_(pos, controllerState);
                        if (!IMultiController.ofController((BlockGetter)serverLevel, pos).map(controller -> {
                            boolean success;
                            MBDMultiblockMachine machine;
                            if (controller instanceof MBDMultiblockMachine && (machine = (MBDMultiblockMachine)controller).checkPatternWithLock() && (success = machine.onCatalystUsed(event.getEntity(), event.getHand(), held))) {
                                machine.onStructureFormed();
                                MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                                mwsd.addMapping(machine.getMultiblockState());
                                mwsd.removeAsyncLogic(machine);
                                machine.setOriginalBlock(originalState);
                                return true;
                            }
                            return false;
                        }).orElse(false).booleanValue()) {
                            serverLevel.m_46597_(pos, originalState);
                            continue;
                        }
                        event.setCanceled(true);
                        return;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onWorldUnLoad(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        if (!world.m_5776_() && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            MultiblockWorldSavedData.getOrCreate(serverLevel).releaseExecutorService();
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        Iterable levels = event.getServer().m_129785_();
        for (ServerLevel level : levels) {
            if (level.m_5776_()) continue;
            MultiblockWorldSavedData.getOrCreate(level).releaseExecutorService();
        }
    }
}

