/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = new FluidIngredient(Stream.empty(), 0L, null);
    public Value[] values;
    @Nullable
    public FluidStack[] stacks;
    private long amount;
    @Nullable
    private CompoundTag nbt;
    private boolean changed = true;

    public FluidIngredient(Stream<? extends Value> empty, long amount, @Nullable CompoundTag nbt) {
        this.values = (Value[])empty.toArray(Value[]::new);
        this.amount = amount;
        this.nbt = nbt;
    }

    public static FluidIngredient fromValues(Stream<? extends Value> stream, long amount, @Nullable CompoundTag nbt) {
        FluidIngredient ingredient = new FluidIngredient(stream, amount, nbt);
        return ingredient.isEmpty() ? EMPTY : ingredient;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_236828_(Arrays.asList(this.getStacks()), (buf, stack) -> stack.writeToBuf(buf));
        buffer.m_130103_(this.amount);
        buffer.m_130079_(this.nbt);
    }

    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("amount", (Number)(this.amount * FluidHelper.getBucket() / 1000L));
        if (this.nbt != null) {
            jsonObject.addProperty("nbt", this.nbt.m_7916_());
        }
        if (this.values.length == 1) {
            jsonObject.add("value", (JsonElement)this.values[0].serialize());
        }
        JsonArray jsonArray = new JsonArray();
        for (Value value : this.values) {
            jsonArray.add((JsonElement)value.serialize());
        }
        jsonObject.add("value", (JsonElement)jsonArray);
        return jsonObject;
    }

    public FluidIngredient copy() {
        return new FluidIngredient(Arrays.stream(this.values).map(Value::copy), this.amount, this.nbt == null ? null : this.nbt.m_6426_());
    }

    public FluidIngredient copy(long amount) {
        return new FluidIngredient(Arrays.stream(this.values).map(Value::copy), amount, this.nbt == null ? null : this.nbt.m_6426_());
    }

    @Override
    public boolean test(@Nullable FluidStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.isEmpty()) {
            return stack.isEmpty();
        }
        if (this.nbt != null && !this.nbt.equals((Object)stack.getTag())) {
            return false;
        }
        for (FluidStack fluidStack : this.getStacks()) {
            if (fluidStack.getFluid() != stack.getFluid()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public FluidStack[] getStacks() {
        if (this.changed || this.stacks == null) {
            this.stacks = (FluidStack[])Arrays.stream(this.values).flatMap(entry -> entry.getStacks().stream()).distinct().map(fluid -> FluidStack.create((Fluid)fluid, (long)this.amount, (CompoundTag)this.nbt)).toArray(FluidStack[]::new);
            this.changed = false;
        }
        return this.stacks;
    }

    public void setAmount(long amount) {
        this.amount = amount;
        this.changed = true;
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
        this.changed = true;
    }

    public static FluidIngredient of() {
        return EMPTY;
    }

    public static FluidIngredient of(long amount, Fluid ... items) {
        return FluidIngredient.of(Arrays.stream(items), amount, null);
    }

    public static FluidIngredient of(FluidStack ... stacks) {
        return FluidIngredient.of(Arrays.stream(stacks).map(FluidStack::getFluid), stacks.length == 0 ? 0L : stacks[0].getAmount(), stacks.length == 0 ? null : stacks[0].getTag());
    }

    public static FluidIngredient of(Stream<Fluid> stacks, long amount, CompoundTag nbt) {
        return FluidIngredient.fromValues(stacks.filter(stack -> stack != null && !stack.m_6212_(Fluids.f_76191_)).map(FluidValue::new), amount, nbt);
    }

    public static FluidIngredient of(TagKey<Fluid> tag, long amount) {
        return FluidIngredient.fromValues(Stream.of(new TagValue(tag)), amount, null);
    }

    public static FluidIngredient of(TagKey<Fluid> tag, long amount, CompoundTag nbt) {
        return FluidIngredient.fromValues(Stream.of(new TagValue(tag)), amount, nbt);
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf buffer) {
        return FluidIngredient.fromValues(buffer.m_236845_(FluidStack::readFromBuf).stream().map(stack -> new FluidValue(stack.getFluid())), buffer.m_130258_(), buffer.m_130260_());
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json) {
        return FluidIngredient.fromJson(json, true);
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json, boolean allowAir) {
        CompoundTag nbt;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Fluid ingredient cannot be null");
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected fluid ingredient to be object");
        }
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"ingredient");
        long amount = GsonHelper.m_13828_((JsonObject)jsonObject, (String)"amount", (long)0L);
        CompoundTag compoundTag = nbt = jsonObject.has("nbt") ? CraftingHelper.getNBT((JsonElement)jsonObject.get("nbt")) : null;
        if (GsonHelper.m_144772_((JsonObject)jsonObject, (String)"value")) {
            return FluidIngredient.fromValues(Stream.of(FluidIngredient.valueFromJson(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"value"))), amount, nbt);
        }
        if (GsonHelper.m_13885_((JsonObject)jsonObject, (String)"value")) {
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"value");
            if (jsonArray.size() == 0 && !allowAir) {
                throw new JsonSyntaxException("Fluid array cannot be empty, at least one item must be defined");
            }
            return FluidIngredient.fromValues(StreamSupport.stream(jsonArray.spliterator(), false).map(jsonElement -> FluidIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)jsonElement, (String)"fluid"))), amount, nbt);
        }
        throw new JsonSyntaxException("expected value to be either object or array.");
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("fluid") && json.has("tag")) {
            throw new JsonParseException("A fluid ingredient entry is either a tag or a fluid, not both");
        }
        if (json.has("fluid")) {
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid")));
            return new FluidValue(fluid);
        }
        if (json.has("tag")) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)resourceLocation);
            return new TagValue((TagKey<Fluid>)tagKey);
        }
        throw new JsonParseException("A fluid ingredient entry needs either a tag or a fluid");
    }

    public long getAmount() {
        return this.amount;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public static interface Value {
        public Collection<Fluid> getStacks();

        public JsonObject serialize();

        public Value copy();
    }

    public static class TagValue
    implements Value {
        private TagKey<Fluid> tag;

        public TagValue(TagKey<Fluid> tag) {
            this.tag = tag;
        }

        @Override
        public Collection<Fluid> getStacks() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.f_257020_.m_206058_(this.tag)) {
                list.add((Fluid)holder.m_203334_());
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tag.f_203868_().toString());
            return jsonObject;
        }

        @Override
        public Value copy() {
            return new TagValue(this.tag);
        }

        public TagKey<Fluid> getTag() {
            return this.tag;
        }

        public void setTag(TagKey<Fluid> tag) {
            this.tag = tag;
        }
    }

    public static class FluidValue
    implements Value {
        private Fluid fluid;

        public FluidValue(Fluid item) {
            this.fluid = item;
        }

        @Override
        public Collection<Fluid> getStacks() {
            return Collections.singleton(this.fluid);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid).toString());
            return jsonObject;
        }

        @Override
        public Value copy() {
            return new FluidValue(this.fluid);
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public void setFluid(Fluid fluid) {
            this.fluid = fluid;
        }
    }
}

