/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class EntityIngredient
implements Predicate<Collection<Entity>> {
    public static final EntityIngredient EMPTY = new EntityIngredient(Stream.empty(), 0, null);
    public Value[] values;
    @Nullable
    public EntityType<?>[] types;
    private int count;
    @Nullable
    private CompoundTag nbt;
    private boolean changed = true;

    public EntityIngredient(Stream<? extends Value> empty, int count, @Nullable CompoundTag nbt) {
        this.values = (Value[])empty.toArray(Value[]::new);
        this.count = count;
        this.nbt = nbt;
    }

    public static EntityIngredient fromValues(Stream<? extends Value> stream, int count, @Nullable CompoundTag nbt) {
        EntityIngredient ingredient = new EntityIngredient(stream, count, nbt);
        return ingredient.isEmpty() ? EMPTY : ingredient;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_236828_(Arrays.asList(this.getTypes()), (buf, entityType) -> buf.m_130085_(BuiltInRegistries.f_256780_.m_7981_(entityType)));
        buffer.m_130130_(this.count);
        buffer.m_130079_(this.nbt);
    }

    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("count", (Number)this.count);
        if (this.nbt != null) {
            jsonObject.addProperty("nbt", this.nbt.m_7916_());
        }
        if (this.values.length == 1) {
            jsonObject.add("value", (JsonElement)this.values[0].serialize());
        }
        JsonArray jsonArray = new JsonArray();
        for (Value value : this.values) {
            jsonArray.add((JsonElement)value.serialize());
        }
        jsonObject.add("value", (JsonElement)jsonArray);
        return jsonObject;
    }

    public EntityIngredient copy() {
        return new EntityIngredient(Arrays.stream(this.values).map(Value::copy), this.count, this.nbt == null ? null : this.nbt.m_6426_());
    }

    public EntityIngredient copy(int count) {
        return new EntityIngredient(Arrays.stream(this.values).map(Value::copy), count, this.nbt == null ? null : this.nbt.m_6426_());
    }

    @Override
    public boolean test(@Nullable Collection<Entity> entities) {
        if (entities == null) {
            return false;
        }
        if (this.isEmpty()) {
            return entities.isEmpty();
        }
        int matches = 0;
        Set types = Arrays.stream(this.getTypes()).collect(Collectors.toSet());
        for (Entity entity : entities) {
            if (!entity.m_6084_() || !types.contains(entity.m_6095_())) continue;
            if (this.nbt != null && !this.nbt.m_128456_()) {
                CompoundTag held = entity.serializeNBT();
                CompoundTag copied = this.nbt.m_6426_();
                copied.m_128391_(held);
                if (!this.nbt.equals((Object)copied)) continue;
            }
            ++matches;
        }
        return matches >= this.count;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public EntityType<?>[] getTypes() {
        if (this.changed || this.types == null) {
            this.types = (EntityType[])Arrays.stream(this.values).flatMap(entry -> entry.getTypes().stream()).distinct().toArray(EntityType[]::new);
            this.changed = false;
        }
        return this.types;
    }

    public void setCount(int count) {
        this.count = count;
        this.changed = true;
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
        this.changed = true;
    }

    public static EntityIngredient of() {
        return EMPTY;
    }

    public static EntityIngredient of(int count, EntityType<?> ... entityTypes) {
        return EntityIngredient.of(Arrays.stream(entityTypes), count, null);
    }

    public static EntityIngredient of(Stream<EntityType<?>> types, int count, CompoundTag nbt) {
        return EntityIngredient.fromValues(types.map(EntityTypeValue::new), count, nbt);
    }

    public static EntityIngredient of(TagKey<EntityType<?>> tag, int count) {
        return EntityIngredient.fromValues(Stream.of(new TagValue(tag)), count, null);
    }

    public static EntityIngredient of(TagKey<EntityType<?>> tag, int count, CompoundTag nbt) {
        return EntityIngredient.fromValues(Stream.of(new TagValue(tag)), count, nbt);
    }

    public static EntityIngredient fromNetwork(FriendlyByteBuf buffer) {
        return EntityIngredient.fromValues(buffer.m_236845_(buf -> (EntityType)BuiltInRegistries.f_256780_.m_7745_(buf.m_130281_())).stream().map(EntityTypeValue::new), buffer.m_130242_(), buffer.m_130260_());
    }

    public static EntityIngredient fromJson(@Nullable JsonElement json) {
        return EntityIngredient.fromJson(json, true);
    }

    public static EntityIngredient fromJson(@Nullable JsonElement json, boolean allowAir) {
        CompoundTag nbt;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Entity ingredient cannot be null");
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected entity ingredient to be object");
        }
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"ingredient");
        int count = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"count", (int)0);
        CompoundTag compoundTag = nbt = jsonObject.has("nbt") ? CraftingHelper.getNBT((JsonElement)jsonObject.get("nbt")) : null;
        if (GsonHelper.m_144772_((JsonObject)jsonObject, (String)"value")) {
            return EntityIngredient.fromValues(Stream.of(EntityIngredient.valueFromJson(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"value"))), count, nbt);
        }
        if (GsonHelper.m_13885_((JsonObject)jsonObject, (String)"value")) {
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"value");
            if (jsonArray.isEmpty() && !allowAir) {
                throw new JsonSyntaxException("Entity array cannot be empty, at least one item must be defined");
            }
            return EntityIngredient.fromValues(StreamSupport.stream(jsonArray.spliterator(), false).map(jsonElement -> EntityIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)jsonElement, (String)"entityType"))), count, nbt);
        }
        throw new JsonSyntaxException("expected value to be either object or array.");
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("entityType") && json.has("tag")) {
            throw new JsonParseException("A entity ingredient entry is either a tag or a entityType, not both");
        }
        if (json.has("entityType")) {
            EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"entityType")));
            return new EntityTypeValue(entityType);
        }
        if (json.has("tag")) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)resourceLocation);
            return new TagValue(tagKey);
        }
        throw new JsonParseException("A entity ingredient entry needs either a tag or a entityType");
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public static interface Value {
        public Collection<EntityType<?>> getTypes();

        public JsonObject serialize();

        public Value copy();
    }

    public static class TagValue
    implements Value {
        private TagKey<EntityType<?>> tag;

        public TagValue(TagKey<EntityType<?>> tag) {
            this.tag = tag;
        }

        @Override
        public Collection<EntityType<?>> getTypes() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.f_256780_.m_206058_(this.tag)) {
                list.add((EntityType)holder.m_203334_());
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tag.f_203868_().toString());
            return jsonObject;
        }

        @Override
        public Value copy() {
            return new TagValue(this.tag);
        }

        public TagKey<EntityType<?>> getTag() {
            return this.tag;
        }

        public void setTag(TagKey<EntityType<?>> tag) {
            this.tag = tag;
        }
    }

    public static class EntityTypeValue
    implements Value {
        private EntityType<?> entityType;

        public EntityTypeValue(EntityType<?> item) {
            this.entityType = item;
        }

        @Override
        public Collection<EntityType<?>> getTypes() {
            return Collections.singleton(this.entityType);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("entityType", BuiltInRegistries.f_256780_.m_7981_(this.entityType).toString());
            return jsonObject;
        }

        @Override
        public Value copy() {
            return new EntityTypeValue(this.entityType);
        }

        public EntityType<?> getEntityType() {
            return this.entityType;
        }

        public void setEntityType(EntityType<?> entityType) {
            this.entityType = entityType;
        }
    }
}

