/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.content;

import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ContentWidget<T>
extends WidgetGroup {
    private final RecipeCapability<T> cap;
    private final Content content;
    private Tag lastContentTag;

    public ContentWidget(int x, int y, RecipeCapability<T> cap, Content content) {
        super(x, y, 20, 20);
        this.cap = cap;
        this.content = content;
        this.lastContentTag = cap.serializer.toNBT(cap.of(content.getContent()));
        Widget contentWidget = cap.createPreviewWidget(cap.of(content.getContent()));
        contentWidget.setSelfPosition(1, 1);
        this.addWidget(contentWidget);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        Tag currentTag = this.cap.serializer.toNBT(this.cap.of(this.content.getContent()));
        if (!currentTag.equals(this.lastContentTag)) {
            this.clearAllWidgets();
            this.lastContentTag = currentTag;
            Widget contentWidget = this.cap.createPreviewWidget(this.cap.of(this.content.getContent()));
            contentWidget.setSelfPosition(1, 1);
            this.addWidget(contentWidget);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        this.content.createOverlay().draw(graphics, mouseX, mouseY, (float)(this.getPositionX() + 1), (float)(this.getPositionY() + 1), 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        if (ContentWidget.isMouseOver((int)(this.getPositionX() + 1), (int)(this.getPositionY() + 1), (int)18, (int)18, (double)mouseX, (double)mouseY)) {
            ArrayList<Component> tooltips = new ArrayList<Component>();
            if (this.gui.getModularUIGui().tooltipTexts != null) {
                tooltips.addAll(this.gui.getModularUIGui().tooltipTexts);
            }
            this.content.appendTooltip(tooltips);
            if (Editor.INSTANCE instanceof MachineEditor) {
                if (!this.content.slotName.isEmpty()) {
                    tooltips.add((Component)Component.m_237110_((String)"mbd2.gui.content.slot_name", (Object[])new Object[]{this.content.slotName}));
                }
                if (!this.content.uiName.isEmpty()) {
                    tooltips.add((Component)Component.m_237110_((String)"mbd2.gui.content.ui_name", (Object[])new Object[]{this.content.uiName}));
                }
            }
            if (!tooltips.isEmpty()) {
                this.gui.getModularUIGui().tooltipTexts = tooltips;
            }
        }
    }

    public RecipeCapability<T> getCap() {
        return this.cap;
    }

    public Content getContent() {
        return this.content;
    }

    public Tag getLastContentTag() {
        return this.lastContentTag;
    }
}

