/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.content;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ContentModifier
implements IConfigurable {
    public static final ContentModifier IDENTITY = ContentModifier.identity();
    @Configurable(name="content_modifier.multiplier", tips={"content_modifier.multiplier.tips"})
    @NumberRange(range={0.0, 1.7976931348623157E308}, wheel=1.0)
    private double multiplier;
    @Configurable(name="content_modifier.addition", tips={"content_modifier.addition.tips"})
    @NumberRange(range={0.0, 1.7976931348623157E308}, wheel=1.0)
    private double addition;

    public boolean isIdentity() {
        return this.multiplier == 1.0 && this.addition == 0.0;
    }

    public static ContentModifier of(double multiplier, double addition) {
        return new ContentModifier(multiplier, addition);
    }

    public static ContentModifier multiplier(double multiplier) {
        return new ContentModifier(multiplier, 0.0);
    }

    public static ContentModifier addition(double addition) {
        return new ContentModifier(1.0, addition);
    }

    public static ContentModifier identity() {
        return new ContentModifier(1.0, 0.0);
    }

    public ContentModifier(double multiplier, double addition) {
        this.multiplier = multiplier;
        this.addition = addition;
    }

    public Number apply(Number number) {
        if (number instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)number;
            return decimal.multiply(BigDecimal.valueOf(this.multiplier)).add(BigDecimal.valueOf(this.addition));
        }
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            return bigInteger.multiply(BigInteger.valueOf((long)this.multiplier)).add(BigInteger.valueOf((long)this.addition));
        }
        return number.doubleValue() * this.multiplier + this.addition;
    }

    public ContentModifier merge(ContentModifier modifier) {
        return new ContentModifier(this.multiplier * modifier.multiplier, this.addition + modifier.addition);
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getAddition() {
        return this.addition;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setAddition(double addition) {
        this.addition = addition;
    }
}

