/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.pattern;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.utils.ItemStackKey;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.pattern.BlockPattern;
import com.lowdragmc.mbd2.api.pattern.MultiblockShapeInfo;
import com.lowdragmc.mbd2.api.pattern.TraceabilityPredicate;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import com.lowdragmc.mbd2.common.block.MBDMachineBlock;
import com.lowdragmc.mbd2.common.machine.definition.MultiblockMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleCatalyst;
import com.lowdragmc.mbd2.config.ConfigHolder;
import com.lowdragmc.mbd2.utils.ControllerBlockInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.screen.RecipeScreen;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PatternPreviewWidget
extends WidgetGroup {
    private boolean isLoaded;
    private static TrackedDummyWorld LEVEL;
    private static BlockPos LAST_POS;
    private static final Map<MultiblockMachineDefinition, MBPattern[]> CACHE;
    private final SceneWidget sceneWidget;
    public final MultiblockMachineDefinition controllerDefinition;
    public final ImageWidget descriptionWidget;
    public final MBPattern[] patterns;
    private int index;
    public int layer;
    public int candidatePage;
    private final CycleItemStackHandler predicatesItemHandler;
    private final CycleItemStackHandler candidatesItemHandler;
    private final SlotWidget[] predicates;

    protected PatternPreviewWidget(MultiblockMachineDefinition controllerDefinition) {
        super(0, 0, 160, 160);
        int i;
        this.setClientSideWidget();
        this.predicates = new SlotWidget[5];
        ArrayList predicateItems = new ArrayList();
        for (i = 0; i < 5; ++i) {
            predicateItems.add(Collections.emptyList());
        }
        this.predicatesItemHandler = new CycleItemStackHandler(predicateItems);
        for (i = 0; i < this.predicates.length; ++i) {
            SlotWidget slot;
            this.predicates[i] = slot = new SlotWidget((IItemTransfer)this.predicatesItemHandler, i, 6, 9 + i * 18, false, false).setIngredientIO(IngredientIO.INPUT);
            this.addWidget((Widget)slot);
        }
        this.addWidget((Widget)new ImageWidget(26, 7, 106, 106, (IGuiTexture)ResourceBorderTexture.BORDERED_BACKGROUND_INVERSE));
        this.sceneWidget = new SceneWidget(29, 10, 100, 100, (Level)LEVEL).setOnSelected(this::onPosSelected).setRenderFacing(false).setRenderFacing(false);
        this.addWidget((Widget)this.sceneWidget);
        if (ConfigHolder.useVBO) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> ((SceneWidget)this.sceneWidget).useCacheBuffer());
            } else {
                this.sceneWidget.useCacheBuffer();
            }
        }
        this.controllerDefinition = controllerDefinition;
        this.layer = -1;
        this.patterns = CACHE.computeIfAbsent(controllerDefinition, definition -> {
            HashSet<ItemStackKey> drops = new HashSet<ItemStackKey>();
            drops.add(new ItemStackKey(new ItemStack[]{this.controllerDefinition.asStack()}));
            return (MBPattern[])Arrays.stream(controllerDefinition.shapeInfoFactory().apply(controllerDefinition)).map(it -> this.initializePattern((MultiblockShapeInfo)it, drops)).filter(Objects::nonNull).toArray(MBPattern[]::new);
        });
        this.addWidget((Widget)new ImageWidget(29, 10, 100, 15, (IGuiTexture)new TextTexture(controllerDefinition.getDescriptionId(), -1).setType(TextTexture.TextType.ROLL).setWidth(100).setDropShadow(true)));
        GuiTextureGroup buttonTexture = new GuiTextureGroup(new IGuiTexture[]{new ColorRectTexture(ColorUtils.color((int)255, (int)221, (int)221, (int)221)), new ColorBorderTexture(-1, ColorUtils.color((int)255, (int)73, (int)73, (int)73))});
        Widget pageButton = new ButtonWidget(136, 11, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{buttonTexture, new ItemStackTexture(new Item[]{Items.f_42516_}), new TextTexture("0", ColorPattern.BLACK.color).setSupplier(() -> Integer.toString(this.index)).scale(0.8f)}), cd -> this.setPage(this.index + 1 >= this.patterns.length ? 0 : this.index + 1)).setHoverBorderTexture(-1, -1).setHoverTooltips(new String[]{"pattern_preview.page"});
        Widget layerButton = new ButtonWidget(136, 34, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{buttonTexture, new ResourceTexture("mbd2:textures/gui/multiblock_info_page_layer.png"), new TextTexture("", ColorPattern.BLACK.color).setSupplier(() -> this.layer == -1 ? "" : Integer.toString(this.layer)).scale(0.8f)}), cd -> this.updateLayer()).setHoverBorderTexture(-1, -1).setHoverTooltips(new String[]{"pattern_preview.layer"});
        Widget formedButton = new SwitchWidget(136, 57, 18, 18, (cd, pressed) -> this.onFormedSwitch((boolean)pressed)).setSupplier(() -> this.patterns[this.index].controllerBase.isFormed()).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{buttonTexture, new ResourceTexture("mbd2:textures/gui/multiblock_info_page_unformed.png")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{buttonTexture, new ResourceTexture("mbd2:textures/gui/multiblock_info_page.png")})).setHoverBorderTexture(-1, -1).setHoverTooltips(new String[]{"pattern_preview.formed"});
        if (this.patterns.length > 1) {
            this.addWidget(pageButton);
        }
        this.addWidget(layerButton);
        this.addWidget(formedButton);
        if (controllerDefinition.multiblockSettings().catalyst().isEnable()) {
            ToggleCatalyst catalyst = controllerDefinition.multiblockSettings().catalyst();
            ArrayList<ItemStack> catalystItems = new ArrayList<ItemStack>();
            for (ItemStack stack : catalyst.getFilterItems()) {
                catalystItems.add(stack.m_41777_());
            }
            for (ResourceLocation filterTag : catalyst.getFilterTags()) {
                BuiltInRegistries.f_257033_.m_203431_(ItemTags.create((ResourceLocation)filterTag)).ifPresent(values -> {
                    for (Holder stack : values) {
                        catalystItems.add(((Item)stack.m_203334_()).m_7968_());
                    }
                });
            }
            if (!catalystItems.isEmpty()) {
                this.addWidget(new SlotWidget((IItemTransfer)new CycleItemStackHandler(List.of(catalystItems)), 0, 136, 80, false, false).setIngredientIO(IngredientIO.CATALYST).setOnAddedTooltips((widget, tooltips) -> {
                    tooltips.add(Component.m_237115_((String)"config.multiblock_settings.catalyst.tooltip"));
                    tooltips.add(Component.m_237115_((String)catalyst.getCatalystType().getTranslateKey()));
                    if (catalyst.getCatalystType() == ToggleCatalyst.CatalystType.CONSUME_ITEM) {
                        tooltips.add(Component.m_237115_((String)"config.multiblock_settings.catalyst.consume_type.consume_item.amount").m_7220_((Component)Component.m_237113_((String)(" " + catalyst.getConsumeItemAmount()))));
                    } else {
                        tooltips.add(Component.m_237115_((String)"config.multiblock_settings.catalyst.consume_type.consume_durability.amount").m_7220_((Component)Component.m_237113_((String)(" " + catalyst.getConsumeDurabilityValue()))));
                    }
                }).setBackground(new IGuiTexture[]{buttonTexture}));
            }
        }
        this.descriptionWidget = new ImageWidget(this.sceneWidget.getPositionX() + this.sceneWidget.getSizeWidth() - 20, this.sceneWidget.getPositionY() + this.sceneWidget.getSizeHeight() - 20, 16, 16, IGuiTexture.EMPTY);
        this.addWidget((Widget)this.descriptionWidget);
        ArrayList items = new ArrayList();
        for (int i2 = 0; i2 < 14; ++i2) {
            items.add(Collections.emptyList());
        }
        this.candidatesItemHandler = new CycleItemStackHandler(items);
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 2; ++y) {
                SlotWidget slot = new SlotWidget((IItemTransfer)this.candidatesItemHandler, x + y * 7, 6 + x * 18, 117 + y * 18, false, false).setIngredientIO(IngredientIO.INPUT);
                this.addWidget((Widget)slot);
            }
        }
        ResourceBorderTexture buttonBackground = ResourceBorderTexture.BUTTON_COMMON;
        ButtonWidget upButton = new ButtonWidget(137, 118, 16, 16, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{buttonBackground, Icons.UP.copy().scale(0.8f)}), cd -> this.updateCandidatePage(this.candidatePage - 1)).setHoverBorderTexture(-1, ColorPattern.GRAY.color);
        ButtonWidget downButton = new ButtonWidget(137, 136, 16, 16, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{buttonBackground, Icons.DOWN.copy().scale(0.8f)}), cd -> this.updateCandidatePage(this.candidatePage + 1)).setHoverBorderTexture(-1, ColorPattern.GRAY.color);
        this.addWidget((Widget)upButton);
        this.addWidget((Widget)downButton);
        this.setPage(0);
    }

    private void updateCandidatePage(int page) {
        if (this.candidatePage == page) {
            return;
        }
        int maxPage = Math.max(0, (this.patterns[this.index].parts.size() - 1) / 14);
        if (page > maxPage || page < 0) {
            return;
        }
        this.candidatePage = page;
        this.setupPatternCandidates(this.patterns[this.index]);
    }

    private void updateLayer() {
        MBPattern pattern = this.patterns[this.index];
        if (this.layer + 1 >= -1 && this.layer + 1 <= pattern.maxY - pattern.minY) {
            ++this.layer;
            if (pattern.controllerBase.isFormed()) {
                this.onFormedSwitch(false);
            }
        } else {
            this.layer = -1;
            if (!pattern.controllerBase.isFormed()) {
                this.onFormedSwitch(true);
            }
        }
        this.setupScene(pattern);
    }

    private void setupScene(MBPattern pattern) {
        Stream<BlockPos> stream = pattern.blockMap.keySet().stream().filter(pos -> this.layer == -1 || this.layer + pattern.minY == pos.m_123342_());
        if (pattern.controllerBase.isFormed()) {
            LongSet set = (LongSet)pattern.controllerBase.getMultiblockState().getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
            Set modelDisabled = set.stream().map(BlockPos::m_122022_).collect(Collectors.toSet());
            if (!modelDisabled.isEmpty()) {
                this.sceneWidget.setRenderedCore((Collection)stream.filter(pos -> !modelDisabled.contains(pos)).collect(Collectors.toList()), null);
            } else {
                this.sceneWidget.setRenderedCore(stream.toList(), null);
            }
        } else {
            this.sceneWidget.setRenderedCore(stream.toList(), null);
        }
    }

    public static PatternPreviewWidget getPatternWidget(MultiblockMachineDefinition controllerDefinition) {
        if (LEVEL == null) {
            if (Minecraft.m_91087_().f_91073_ == null) {
                MBD2.LOGGER.error("Try to init pattern previews before level load");
                throw new IllegalStateException();
            }
            LEVEL = new TrackedDummyWorld();
        }
        return new PatternPreviewWidget(controllerDefinition);
    }

    public void setPage(int index) {
        if (index >= this.patterns.length || index < 0) {
            return;
        }
        this.index = index;
        this.layer = -1;
        this.candidatePage = 0;
        MBPattern pattern = this.patterns[index];
        this.setupScene(pattern);
        this.setupPatternCandidates(pattern);
        this.setupDescription(pattern);
    }

    private void setupPatternCandidates(MBPattern pattern) {
        List<List<ItemStack>> parts = pattern.parts;
        ArrayList<List<Object>> items = new ArrayList<List<Object>>();
        for (int i = 0; i < 14; ++i) {
            int index = i + this.candidatePage * 14;
            if (pattern.parts.size() > index) {
                items.add(parts.get(index));
                continue;
            }
            items.add(Collections.emptyList());
        }
        this.candidatesItemHandler.updateStacks(items);
    }

    private void setupDescription(MBPattern pattern) {
        List<String> description = pattern.description;
        if (description.isEmpty()) {
            this.descriptionWidget.setImage(IGuiTexture.EMPTY);
            this.descriptionWidget.setHoverTooltips(Collections.emptyList());
        } else {
            this.descriptionWidget.setImage((IGuiTexture)new ResourceTexture("mbd2:textures/gui/information.png"));
            this.descriptionWidget.setHoverTooltips(description.stream().map(Component::m_237115_).collect(Collectors.toList()));
        }
    }

    private void onFormedSwitch(boolean isFormed) {
        MBPattern pattern = this.patterns[this.index];
        IMultiController controllerBase = pattern.controllerBase;
        if (isFormed) {
            this.layer = -1;
            this.loadControllerFormed(pattern.blockMap.keySet(), controllerBase);
        } else {
            this.sceneWidget.setRenderedCore(pattern.blockMap.keySet(), null);
            controllerBase.onStructureInvalid();
        }
    }

    private void onPosSelected(BlockPos pos, Direction facing) {
        int i;
        if (this.index >= this.patterns.length || this.index < 0) {
            return;
        }
        TraceabilityPredicate predicate = this.patterns[this.index].predicateMap.get(pos);
        if (predicate == null) {
            return;
        }
        ArrayList<SimplePredicate> allPredicates = new ArrayList<SimplePredicate>();
        allPredicates.addAll(predicate.common);
        allPredicates.addAll(predicate.limited);
        allPredicates.removeIf(p -> p == null || p.candidates == null);
        ArrayList<List<ItemStack>> candidateStacks = new ArrayList<List<ItemStack>>();
        ArrayList<List<Component>> predicateTips = new ArrayList<List<Component>>();
        for (SimplePredicate simplePredicate : allPredicates) {
            List<ItemStack> itemStacks = simplePredicate.getCandidates();
            if (itemStacks.isEmpty()) continue;
            candidateStacks.add(itemStacks);
            predicateTips.add(simplePredicate.getToolTips(predicate));
        }
        ArrayList predicateItems = new ArrayList();
        for (i = 0; i < 5; ++i) {
            if (candidateStacks.size() > i) {
                predicateItems.add((List)candidateStacks.get(i));
                continue;
            }
            predicateItems.add(Collections.emptyList());
        }
        this.predicatesItemHandler.updateStacks(predicateItems);
        for (i = 0; i < 5; ++i) {
            if (predicateTips.size() > i) {
                this.predicates[i].setHoverTooltips((List)predicateTips.get(i));
                continue;
            }
            this.predicates[i].setHoverTooltips(Collections.emptyList());
        }
    }

    public static BlockPos locateNextRegion(int range) {
        BlockPos pos = LAST_POS;
        LAST_POS = LAST_POS.m_7918_(range, 0, range);
        return pos;
    }

    public void updateScreen() {
        super.updateScreen();
        if (!this.isLoaded && LDLib.isEmiLoaded() && Minecraft.m_91087_().f_91080_ instanceof RecipeScreen) {
            this.setPage(0);
            this.isLoaded = true;
        } else if (!this.isLoaded && LDLib.isReiLoaded() && Minecraft.m_91087_().f_91080_ instanceof AbstractDisplayViewingScreen) {
            this.setPage(0);
            this.isLoaded = true;
        }
    }

    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
    }

    private MBPattern initializePattern(MultiblockShapeInfo shapeInfo, HashSet<ItemStackKey> blockDrops) {
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        IMachine controllerBase = null;
        BlockPos multiPos = PatternPreviewWidget.locateNextRegion(500);
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        for (int x = 0; x < blocks.length; ++x) {
            BlockInfo[][] aisle = blocks[x];
            for (int y = 0; y < aisle.length; ++y) {
                BlockInfo[] column = aisle[y];
                for (int z = 0; z < column.length; ++z) {
                    IMachineBlockEntity holder;
                    BlockInfo blockInfo = column[z];
                    if (blockInfo instanceof ControllerBlockInfo) {
                        ControllerBlockInfo controllerBlockInfo = (ControllerBlockInfo)blockInfo;
                        BlockState state = this.controllerDefinition.block().m_49966_();
                        if (this.controllerDefinition.blockProperties().rotationState().property.isPresent()) {
                            state = (BlockState)state.m_61124_((Property)this.controllerDefinition.blockProperties().rotationState().property.get(), (Comparable)controllerBlockInfo.getFacing());
                        }
                        column[z] = new BlockInfo(state, true);
                    }
                    BlockState blockState = column[z].getBlockState();
                    BlockPos pos = multiPos.m_7918_(x, y, z);
                    Object object = column[z].getBlockEntity(pos);
                    if (object instanceof IMachineBlockEntity && (object = (holder = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiController) {
                        IMultiController controller = (IMultiController)object;
                        holder.getSelf().m_142339_((Level)LEVEL);
                        controllerBase = controller;
                    }
                    blockMap.put(pos, BlockInfo.fromBlockState((BlockState)blockState));
                }
            }
        }
        LEVEL.addBlocks(blockMap);
        if (controllerBase != null) {
            LEVEL.setInnerBlockEntity(controllerBase.getHolder());
        }
        Map<ItemStackKey, PartInfo> parts = this.gatherBlockDrops(blockMap);
        blockDrops.addAll(parts.keySet());
        HashMap<BlockPos, TraceabilityPredicate> predicateMap = new HashMap();
        if (controllerBase != null) {
            this.loadControllerFormed(predicateMap.keySet(), (IMultiController)controllerBase);
            predicateMap = (Map)controllerBase.getMultiblockState().getMatchContext().get("predicates");
        }
        return controllerBase == null ? null : new MBPattern(blockMap, parts.values().stream().sorted((one, two) -> {
            if (one.isController) {
                return -1;
            }
            if (two.isController) {
                return 1;
            }
            if (one.isTile && !two.isTile) {
                return -1;
            }
            if (two.isTile && !one.isTile) {
                return 1;
            }
            if (one.blockId != two.blockId) {
                return two.blockId - one.blockId;
            }
            return two.amount - one.amount;
        }).map(PartInfo::getItemStack).filter(list -> !list.isEmpty()).collect(Collectors.toList()), predicateMap, (IMultiController)controllerBase, shapeInfo.getDescription());
    }

    private void loadControllerFormed(Collection<BlockPos> poses, IMultiController controllerBase) {
        BlockPattern pattern = controllerBase.getPattern();
        if (pattern != null && pattern.checkPatternAt(controllerBase.getMultiblockState(), true)) {
            controllerBase.onStructureFormed();
        }
        if (controllerBase.isFormed()) {
            LongSet set = (LongSet)controllerBase.getMultiblockState().getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
            Set modelDisabled = set.stream().map(BlockPos::m_122022_).collect(Collectors.toSet());
            if (!modelDisabled.isEmpty()) {
                this.sceneWidget.setRenderedCore((Collection)poses.stream().filter(pos -> !modelDisabled.contains(pos)).collect(Collectors.toList()), null);
            } else {
                this.sceneWidget.setRenderedCore(poses, null);
            }
        } else {
            MBD2.LOGGER.warn("Pattern formed checking failed: {}", (Object)controllerBase.getBlockState().m_60734_().m_7705_());
        }
    }

    private Map<ItemStackKey, PartInfo> gatherBlockDrops(Map<BlockPos, BlockInfo> blocks) {
        Object2ObjectOpenHashMap partsMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<BlockPos, BlockInfo> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState blockState = LEVEL.m_8055_(pos);
            ItemStack itemStack = blockState.m_60734_().m_7397_((BlockGetter)LEVEL, pos, blockState);
            if (itemStack.m_41619_() && !blockState.m_60819_().m_76178_()) {
                Fluid fluid = blockState.m_60819_().m_76152_();
                itemStack = fluid.m_6859_().m_7968_();
            }
            ItemStackKey itemStackKey = new ItemStackKey(new ItemStack[]{itemStack});
            ++partsMap.computeIfAbsent(itemStackKey, (Function<ItemStackKey, PartInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$gatherBlockDrops$19(java.util.Map$Entry com.lowdragmc.lowdraglib.utils.ItemStackKey ), (Lcom/lowdragmc/lowdraglib/utils/ItemStackKey;)Lcom/lowdragmc/mbd2/api/pattern/PatternPreviewWidget$PartInfo;)(entry)).amount;
        }
        return partsMap;
    }

    private static /* synthetic */ PartInfo lambda$gatherBlockDrops$19(Map.Entry entry, ItemStackKey key) {
        return new PartInfo(key, (BlockInfo)entry.getValue());
    }

    static {
        LAST_POS = new BlockPos(0, 50, 0);
        CACHE = new HashMap<MultiblockMachineDefinition, MBPattern[]>();
    }

    public static class MBPattern {
        @NotNull
        final List<List<ItemStack>> parts;
        @NotNull
        final Map<BlockPos, TraceabilityPredicate> predicateMap;
        @NotNull
        final Map<BlockPos, BlockInfo> blockMap;
        @NotNull
        final IMultiController controllerBase;
        final int maxY;
        final int minY;
        final List<String> description;

        public MBPattern(@NotNull Map<BlockPos, BlockInfo> blockMap, @NotNull List<List<ItemStack>> parts, @NotNull Map<BlockPos, TraceabilityPredicate> predicateMap, @NotNull IMultiController controllerBase, @NotNull List<String> description) {
            this.parts = parts;
            this.blockMap = blockMap;
            this.predicateMap = predicateMap;
            this.controllerBase = controllerBase;
            this.description = description;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (BlockPos pos : blockMap.keySet()) {
                min = Math.min(min, pos.m_123342_());
                max = Math.max(max, pos.m_123342_());
            }
            this.minY = min;
            this.maxY = max;
        }
    }

    private static class PartInfo {
        final ItemStackKey itemStackKey;
        boolean isController = false;
        boolean isTile = false;
        final int blockId;
        int amount = 0;

        PartInfo(ItemStackKey itemStackKey, BlockInfo blockInfo) {
            MBDMachineBlock block;
            this.itemStackKey = itemStackKey;
            this.blockId = Block.m_49956_((BlockState)blockInfo.getBlockState());
            this.isTile = blockInfo.hasBlockEntity();
            Block block2 = blockInfo.getBlockState().m_60734_();
            if (block2 instanceof MBDMachineBlock && (block = (MBDMachineBlock)block2).getDefinition() instanceof MultiblockMachineDefinition) {
                this.isController = true;
            }
        }

        public List<ItemStack> getItemStack() {
            return Arrays.stream(this.itemStackKey.getItemStack()).map(itemStack -> {
                ItemStack item = itemStack.m_41777_();
                item.m_41764_(this.amount);
                return item;
            }).filter(item -> !item.m_41619_()).toList();
        }
    }
}

