/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.pattern;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.Builder;
import com.lowdragmc.mbd2.utils.ControllerBlockInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MultiblockShapeInfo
implements IConfigurable,
ITagSerializable<CompoundTag> {
    private BlockInfo[][][] blocks;
    @Configurable(name="editor.machine.multiblock.multiblock_shape_info.description", tips={"editor.machine.multiblock.multiblock_shape_info.description.tips"})
    private List<String> description = new ArrayList<String>();

    protected MultiblockShapeInfo() {
    }

    public static MultiblockShapeInfo loadFromTag(CompoundTag tag) {
        MultiblockShapeInfo info = new MultiblockShapeInfo();
        info.deserializeNBT(tag);
        return info;
    }

    public MultiblockShapeInfo(BlockInfo[][][] blocks, List<String> description) {
        this.blocks = blocks;
        this.description.addAll(description);
    }

    public MultiblockShapeInfo(BlockInfo[][][] blocks) {
        this(blocks, Collections.emptyList());
    }

    public static ShapeInfoBuilder builder() {
        return new ShapeInfoBuilder();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", this.blocks.length);
        tag.m_128405_("y", this.blocks[0].length);
        tag.m_128405_("z", this.blocks[0][0].length);
        ListTag blocks = new ListTag();
        BlockInfo[][][] blockInfoArray = this.blocks;
        int n = blockInfoArray.length;
        for (int i = 0; i < n; ++i) {
            BlockInfo[][] block;
            BlockInfo[][] blockInfoArray2 = block = blockInfoArray[i];
            int n2 = blockInfoArray2.length;
            for (int j = 0; j < n2; ++j) {
                BlockInfo[] blockInfos;
                for (BlockInfo blockInfo : blockInfos = blockInfoArray2[j]) {
                    if (blockInfo instanceof ControllerBlockInfo) {
                        ControllerBlockInfo controllerBlockInfo = (ControllerBlockInfo)blockInfo;
                        Direction facing = controllerBlockInfo.getFacing();
                        CompoundTag controllerTag = new CompoundTag();
                        controllerTag.m_128359_("facing", facing == null ? Direction.NORTH.m_7912_() : facing.m_7912_());
                        blocks.add((Object)controllerTag);
                        continue;
                    }
                    blocks.add((Object)blockInfo.serializeNBT());
                }
            }
        }
        tag.m_128365_("blocks", (Tag)blocks);
        ListTag description = new ListTag();
        for (String desc : this.description) {
            description.add((Object)StringTag.m_129297_((String)desc));
        }
        tag.m_128365_("description", (Tag)description);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        int x = tag.m_128451_("x");
        int y = tag.m_128451_("y");
        int z = tag.m_128451_("z");
        BlockInfo[][][] blocks = new BlockInfo[x][y][z];
        ListTag blockList = (ListTag)tag.m_128423_("blocks");
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                for (int k = 0; k < z; ++k) {
                    CompoundTag blockInfoTag = (CompoundTag)blockList.get(i * y * z + j * z + k);
                    if (blockInfoTag.m_128441_("facing")) {
                        ControllerBlockInfo controllerBlockInfo = new ControllerBlockInfo(Direction.m_122402_((String)blockInfoTag.m_128461_("facing")));
                        blocks[i][j][k] = controllerBlockInfo;
                        continue;
                    }
                    BlockInfo blockInfo = new BlockInfo();
                    blockInfo.deserializeNBT(blockInfoTag);
                    blocks[i][j][k] = blockInfo;
                }
            }
        }
        this.blocks = blocks;
        ArrayList<String> description = new ArrayList<String>();
        ListTag descriptionList = tag.m_128437_("description", 8);
        for (Tag desc : descriptionList) {
            description.add(desc.m_7916_());
        }
        this.description = description;
    }

    public BlockInfo[][][] getBlocks() {
        return this.blocks;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public void setBlocks(BlockInfo[][][] blocks) {
        this.blocks = blocks;
    }

    public void setDescription(List<String> description) {
        this.description = description;
    }

    public static class ShapeInfoBuilder
    extends Builder<BlockInfo, ShapeInfoBuilder> {
        public ShapeInfoBuilder where(char symbol, BlockState blockState) {
            return (ShapeInfoBuilder)this.where(symbol, BlockInfo.fromBlockState((BlockState)blockState));
        }

        public ShapeInfoBuilder where(char symbol, Supplier<? extends Block> block) {
            return this.where(symbol, block.get());
        }

        public ShapeInfoBuilder where(char symbol, Block block) {
            return this.where(symbol, block.m_49966_());
        }

        private BlockInfo[][][] bake() {
            return (BlockInfo[][][])this.bakeArray(BlockInfo.class, BlockInfo.EMPTY);
        }

        public MultiblockShapeInfo build() {
            return new MultiblockShapeInfo(this.bake());
        }
    }
}

