/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.guielement;

import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;

public abstract class AbstractGuiElementWidget<T extends IGuiElement>
extends AbstractWidget {
    private final T element;
    private final IMachineScreen screen;

    public AbstractGuiElementWidget(T element, IMachineScreen screen, Component title) {
        super(element.getX() + screen.getX(), element.getY() + screen.getY(), element.getWidth(), element.getHeight(), title);
        this.element = element;
        this.screen = screen;
    }

    public List<Component> getTooltips() {
        return this.element.getTooltips();
    }

    public T getElement() {
        return this.element;
    }

    public IMachineScreen getScreen() {
        return this.screen;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.f_93622_) {
            this.updateTooltips();
        }
    }

    public void m_168797_(NarrationElementOutput output) {
        output.m_169149_(NarratedElementType.HINT, this.getTooltips().toArray(new Component[0]));
    }

    private void updateTooltips() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null) {
            return;
        }
        if (this.m_278622_() != null) {
            screen.m_262791_(this.m_278622_(), this.m_262860_(), this.m_93696_());
            return;
        }
        if (!this.getTooltips().isEmpty()) {
            List tooltips = this.getTooltips().stream().flatMap(component -> Tooltip.m_257868_((Minecraft)Minecraft.m_91087_(), (Component)component).stream()).toList();
            screen.m_262861_(tooltips, this.m_262860_(), this.m_93696_());
        }
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    protected ClientTooltipPositioner m_262860_() {
        return DefaultTooltipPositioner.f_262752_;
    }
}

