/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import java.util.Objects;

public class PairCodec<F, S>
implements NamedCodec<Pair<F, S>> {
    private final NamedCodec<F> first;
    private final NamedCodec<S> second;

    public static <F, S> PairCodec<F, S> of(NamedCodec<F> first, NamedCodec<S> second) {
        return new PairCodec<F, S>(first, second);
    }

    private PairCodec(NamedCodec<F> first, NamedCodec<S> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public <T> DataResult<Pair<Pair<F, S>, T>> decode(DynamicOps<T> ops, T input) {
        return this.first.decode(ops, input).flatMap(p1 -> this.second.decode(ops, p1.getSecond()).map(p2 -> Pair.of((Object)Pair.of((Object)p1.getFirst(), (Object)p2.getFirst()), (Object)p2.getSecond())));
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, Pair<F, S> value, T rest) {
        return this.second.encode(ops, value.getSecond(), rest).flatMap(f -> this.first.encode(ops, value.getFirst(), f));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PairCodec) {
            PairCodec codec = (PairCodec)o;
            return Objects.equals(this.first, codec.first) && Objects.equals(this.second, codec.second);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @Override
    public String name() {
        return "Pair<" + this.first.name() + ", " + this.second.name() + ">";
    }
}

