/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.FieldCodec;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;

public class OptionalFieldCodec<A>
extends NamedMapCodec<Optional<A>> {
    private final String fieldName;
    private final NamedCodec<A> elementCodec;
    private final String name;

    public static <A> NamedMapCodec<Optional<A>> of(String fieldName, NamedCodec<A> elementCodec, String name) {
        return new OptionalFieldCodec<A>(fieldName, elementCodec, name);
    }

    private OptionalFieldCodec(String fieldName, NamedCodec<A> elementCodec, String name) {
        this.fieldName = FieldCodec.toSnakeCase(fieldName);
        this.elementCodec = elementCodec;
        this.name = name;
    }

    @Override
    public OptionalFieldCodec<A> aliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    @Override
    public <T> DataResult<Optional<A>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = FieldCodec.tryGetValue(ops, input, this.fieldName);
        if (value == null) {
            String alias;
            Iterator iterator = this.aliases.iterator();
            while (iterator.hasNext() && (value = input.get(alias = (String)iterator.next())) == null) {
            }
        }
        if (value == null) {
            if (ICustomMachineryAPI.INSTANCE.config().logMissingOptional()) {
                ICustomMachineryAPI.INSTANCE.logger().debug("Missing optional property: \"{}\" of type: {}, using default value", (Object)this.fieldName, (Object)this.name);
            }
            return DataResult.success(Optional.empty());
        }
        DataResult<A> result = this.elementCodec.read(ops, value);
        if (result.result().isPresent()) {
            return result.map(Optional::of);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().warn("Couldn't parse \"{}\" for key \"{}\", using default value\nError: {}", (Object)this.name, (Object)this.fieldName, (Object)((DataResult.PartialResult)result.error().get()).message());
        }
        return DataResult.success(Optional.empty());
    }

    @Override
    public <T> RecordBuilder<T> encode(Optional<A> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (input.isPresent()) {
            return prefix.add(this.fieldName, this.elementCodec.encodeStart(ops, input.get()));
        }
        return prefix;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.fieldName));
    }

    @Override
    public String name() {
        return this.name;
    }
}

