/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;

public class EnhancedDispatchCodec<K, V>
extends NamedMapCodec<V> {
    private final String typeKey;
    private final NamedCodec<K> keyCodec;
    private final Function<? super V, ? extends DataResult<? extends K>> type;
    private final String valueKey = "value";
    private final Function<? super K, ? extends DataResult<? extends NamedCodec<? extends V>>> valueCodec;
    private final String name;

    public static <K, V> EnhancedDispatchCodec<K, V> of(String typeKey, NamedCodec<K> keyCodec, Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends NamedCodec<? extends V>>> decoder, String name) {
        return new EnhancedDispatchCodec<K, V>(typeKey, keyCodec, type, decoder, name);
    }

    private EnhancedDispatchCodec(String typeKey, NamedCodec<K> keyCodec, Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends NamedCodec<? extends V>>> valueCodec, String name) {
        this.typeKey = typeKey;
        this.keyCodec = keyCodec;
        this.type = type;
        this.valueCodec = valueCodec;
        this.name = name;
    }

    @Override
    public <T> DataResult<V> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object elementName = input.get(this.typeKey);
        if (elementName == null) {
            String alias;
            Iterator iterator = this.aliases.iterator();
            while (iterator.hasNext() && (elementName = input.get(alias = (String)iterator.next())) == null) {
            }
        }
        if (elementName == null) {
            return DataResult.error(() -> "Input does not contain a key [" + this.typeKey + "]: " + input);
        }
        return this.keyCodec.decode(ops, elementName).flatMap(type -> {
            DataResult<? extends NamedCodec<? extends V>> elementDecoder = this.valueCodec.apply(type.getFirst());
            return elementDecoder.flatMap(c -> {
                if (ops.compressMaps()) {
                    Object value = input.get(ops.createString("value"));
                    if (value == null) {
                        return DataResult.error(() -> "Input does not have a \"value\" entry: " + input);
                    }
                    return c.read(ops, value).map(Function.identity());
                }
                return c.decode(ops, ops.createMap(input.entries())).map(Pair::getFirst);
            });
        });
    }

    public <T> RecordBuilder<T> encode(V input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        DataResult<NamedCodec<? super V>> elementEncoder = EnhancedDispatchCodec.getCodec(this.type, this.valueCodec, input);
        RecordBuilder builder = prefix.withErrorsFrom(elementEncoder);
        if (elementEncoder.result().isEmpty()) {
            return builder;
        }
        NamedCodec c = (NamedCodec)elementEncoder.result().get();
        if (ops.compressMaps()) {
            return prefix.add(this.typeKey, this.type.apply(input).flatMap(t -> this.keyCodec.encodeStart(ops, t))).add("value", c.encodeStart(ops, input));
        }
        Object typeString = ops.createString(this.typeKey);
        DataResult<T> result = c.encodeStart(ops, input);
        DataResult element = result.flatMap(arg_0 -> ops.getMap(arg_0));
        return element.map(map -> {
            prefix.add(typeString, this.type.apply(input).flatMap(t -> this.keyCodec.encodeStart(ops, t)));
            map.entries().forEach(pair -> {
                if (!pair.getFirst().equals(typeString)) {
                    prefix.add(pair.getFirst(), pair.getSecond());
                }
            });
            return prefix;
        }).result().orElseGet(() -> prefix.withErrorsFrom(element));
    }

    private static <K, V> DataResult<? extends NamedCodec<V>> getCodec(Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends NamedCodec<? extends V>>> valueCodec, V input) {
        return type.apply(input).flatMap(k -> ((DataResult)valueCodec.apply((Object)k)).map(Function.identity())).map(c -> c);
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(this.typeKey, "value").map(arg_0 -> ops.createString(arg_0));
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

