/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.transfer;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.capability.IFluidHandler;

class InteractionFluidStorage
implements IFluidHandler {
    private final FluidComponentHandler handler;

    public InteractionFluidStorage(FluidComponentHandler handler) {
        this.handler = handler;
    }

    public int getTanks() {
        return this.handler.getComponents().size();
    }

    @Nonnull
    public net.minecraftforge.fluids.FluidStack getFluidInTank(int tank) {
        return FluidStackHooksForge.toForge((FluidStack)((FluidMachineComponent)this.handler.getComponents().get(tank)).getFluidStack());
    }

    public int getTankCapacity(int tank) {
        return Utils.toInt(((FluidMachineComponent)this.handler.getComponents().get(tank)).getCapacity());
    }

    public boolean isFluidValid(int tank, @Nonnull net.minecraftforge.fluids.FluidStack stack) {
        return ((FluidMachineComponent)this.handler.getComponents().get(tank)).isFluidValid(FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)stack));
    }

    public int fill(net.minecraftforge.fluids.FluidStack forgeStack, IFluidHandler.FluidAction action) {
        AtomicLong remaining = new AtomicLong(forgeStack.getAmount());
        FluidStack stack = FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)forgeStack);
        this.handler.getComponents().stream().filter(component -> component.isFluidValid(stack) && component.getRemainingSpace() > 0L && component.getMode().isInput()).sorted(Comparator.comparingInt(component -> component.getFluidStack().isFluidEqual(stack) ? -1 : 1)).forEach(component -> {
            long toInput = Math.min(remaining.get(), component.insert(stack.getFluid(), (int)stack.getAmount(), stack.getTag(), true));
            if (toInput > 0L) {
                remaining.addAndGet(-toInput);
                if (action.execute()) {
                    component.insert(stack.getFluid(), toInput, stack.getTag(), false);
                }
            }
        });
        return (int)(stack.getAmount() - remaining.get());
    }

    @Nonnull
    public net.minecraftforge.fluids.FluidStack drain(net.minecraftforge.fluids.FluidStack maxDrain, IFluidHandler.FluidAction action) {
        long remainingToDrain = maxDrain.getAmount();
        for (FluidMachineComponent component : this.handler.getComponents().stream().sorted(Comparator.comparingInt(c -> c.getMode().isOutput() ? 1 : -1)).toList()) {
            if (component.getFluidStack().isEmpty() || !component.getFluidStack().isFluidEqual(FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)maxDrain))) continue;
            net.minecraftforge.fluids.FluidStack stack = FluidStackHooksForge.toForge((FluidStack)component.extract(maxDrain.getAmount(), true));
            if ((long)stack.getAmount() >= remainingToDrain) {
                if (action.execute()) {
                    component.extract(maxDrain.getAmount(), false);
                }
                return maxDrain;
            }
            if (action.execute()) {
                component.extract(stack.getAmount(), false);
            }
            remainingToDrain -= (long)stack.getAmount();
        }
        if (remainingToDrain == (long)maxDrain.getAmount()) {
            return net.minecraftforge.fluids.FluidStack.EMPTY;
        }
        return new net.minecraftforge.fluids.FluidStack(maxDrain.getFluid(), (int)((long)maxDrain.getAmount() - remainingToDrain), maxDrain.getTag());
    }

    @Nonnull
    public net.minecraftforge.fluids.FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        net.minecraftforge.fluids.FluidStack toDrain = net.minecraftforge.fluids.FluidStack.EMPTY;
        int remainingToDrain = maxDrain;
        for (FluidMachineComponent component : this.handler.getComponents().stream().sorted(Comparator.comparingInt(c -> c.getMode().isOutput() ? 1 : -1)).toList()) {
            if (component.getFluidStack().isEmpty() || !toDrain.isEmpty() && !component.getFluidStack().isFluidEqual(FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)toDrain))) continue;
            net.minecraftforge.fluids.FluidStack stack = FluidStackHooksForge.toForge((FluidStack)component.extract(remainingToDrain, true));
            if (stack.getAmount() >= remainingToDrain) {
                if (action.execute()) {
                    component.extract(remainingToDrain, false);
                }
                return new net.minecraftforge.fluids.FluidStack(stack.getFluid(), maxDrain, stack.getTag());
            }
            if (toDrain.isEmpty()) {
                toDrain = stack;
            }
            if (action.execute()) {
                component.extract(stack.getAmount(), false);
            }
            remainingToDrain -= stack.getAmount();
        }
        if (toDrain.isEmpty() || remainingToDrain == maxDrain) {
            return net.minecraftforge.fluids.FluidStack.EMPTY;
        }
        return new net.minecraftforge.fluids.FluidStack(toDrain.getFluid(), maxDrain - remainingToDrain, toDrain.getTag());
    }
}

