/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.transfer;

import com.google.common.collect.Maps;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.util.transfer.ICommonItemHandler;
import fr.frinn.custommachinery.forge.transfer.SidedItemHandler;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ForgeItemHandler
implements ICommonItemHandler {
    private final ItemComponentHandler handler;
    private final IItemHandler generalHandler;
    private final LazyOptional<IItemHandler> capability;
    private final Map<Direction, SidedItemHandler> sidedHandlers = Maps.newEnumMap(Direction.class);
    private final Map<Direction, LazyOptional<IItemHandler>> sidedWrappers = Maps.newEnumMap(Direction.class);
    private final Map<Direction, BlockEntity> neighbourStorages = Maps.newEnumMap(Direction.class);

    public ForgeItemHandler(ItemComponentHandler handler) {
        this.handler = handler;
        this.generalHandler = new SidedItemHandler(null, handler);
        this.capability = LazyOptional.of(() -> this.generalHandler);
        for (Direction direction : Direction.values()) {
            SidedItemHandler sided = new SidedItemHandler(direction, handler);
            this.sidedHandlers.put(direction, sided);
            this.sidedWrappers.put(direction, (LazyOptional<IItemHandler>)LazyOptional.of(() -> sided));
        }
    }

    public LazyOptional<IItemHandler> getCapability(@Nullable Direction side) {
        if (side == null) {
            return this.capability.cast();
        }
        if (this.handler.getComponents().stream().anyMatch(component -> !component.getConfig().getSideMode(side).isNone())) {
            return this.sidedWrappers.get(side).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void configChanged(RelativeSide side, SideMode oldMode, SideMode newMode) {
        if (oldMode.isNone() != newMode.isNone()) {
            Direction direction = side.getDirection((Direction)this.handler.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
            this.sidedWrappers.get(direction).invalidate();
            this.sidedWrappers.put(direction, (LazyOptional<IItemHandler>)LazyOptional.of(() -> this.sidedHandlers.get(direction)));
            if (oldMode.isNone()) {
                this.handler.getManager().getLevel().m_46672_(this.handler.getManager().getTile().m_58899_(), this.handler.getManager().getTile().m_58900_().m_60734_());
            }
        }
    }

    @Override
    public void invalidate() {
        this.capability.invalidate();
        this.sidedWrappers.values().forEach(LazyOptional::invalidate);
    }

    @Override
    public void tick() {
        for (Direction side : Direction.values()) {
            LazyOptional neighbour;
            if (this.handler.getComponents().stream().allMatch(component -> component.getConfig().getSideMode(side) == SideMode.NONE)) continue;
            if (this.neighbourStorages.get(side) == null || this.neighbourStorages.get(side).m_58901_()) {
                this.neighbourStorages.put(side, this.handler.getManager().getLevel().m_7702_(this.handler.getManager().getTile().m_58899_().m_121945_(side)));
                if (this.neighbourStorages.get(side) == null) continue;
                neighbour = this.neighbourStorages.get(side).getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_());
            } else {
                neighbour = this.neighbourStorages.get(side).getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_());
            }
            neighbour.ifPresent(storage -> this.sidedHandlers.get(side).getSlotList().forEach(slot -> {
                if (slot.getComponent().getConfig().isAutoInput() && slot.getComponent().getConfig().getSideMode(side).isInput() && slot.getComponent().getItemStack().m_41613_() < slot.getComponent().getCapacity()) {
                    this.moveStacks((IItemHandler)storage, (IItemHandler)slot, Integer.MAX_VALUE);
                }
                if (slot.getComponent().getConfig().isAutoOutput() && slot.getComponent().getConfig().getSideMode(side).isOutput() && !slot.getComponent().getItemStack().m_41619_()) {
                    this.moveStacks((IItemHandler)slot, (IItemHandler)storage, Integer.MAX_VALUE);
                }
            }));
        }
    }

    private void moveStacks(IItemHandler from, IItemHandler to, int maxAmount) {
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack canExtract = from.extractItem(i, maxAmount, true);
            if (canExtract.m_41619_()) continue;
            ItemStack canInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)canExtract, (boolean)false);
            if (canInsert.m_41619_()) {
                from.extractItem(i, maxAmount, false);
                continue;
            }
            from.extractItem(i, canExtract.m_41613_() - canInsert.m_41613_(), false);
        }
    }
}

