/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.MachineBlockState;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final Random RAND = new Random();
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,###");

    public static boolean canPlayerManageMachines(Player player) {
        return player.m_20310_(Objects.requireNonNull(player.m_20194_()).m_7022_());
    }

    public static Vec3 vec3dFromBlockPos(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static boolean testNBT(CompoundTag nbt, @Nullable CompoundTag tested) {
        if (tested == null) {
            return false;
        }
        for (String key : tested.m_128431_()) {
            if (nbt.m_128441_(key) && nbt.m_128435_(key) == tested.m_128435_(key) && Utils.testINBT(nbt.m_128423_(key), tested.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Tag> boolean testINBT(@Nullable T inbt, @Nullable T tested) {
        if (inbt == null || tested == null) {
            return false;
        }
        return switch (inbt.m_7060_()) {
            case 1 -> {
                if (((ByteTag)inbt).m_7063_() == ((ByteTag)tested).m_7063_()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (((ShortTag)inbt).m_7053_() == ((ShortTag)tested).m_7053_()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (((IntTag)inbt).m_7047_() == ((IntTag)tested).m_7047_()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (((LongTag)inbt).m_7046_() == ((LongTag)tested).m_7046_()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (((FloatTag)inbt).m_7057_() == ((FloatTag)tested).m_7057_()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (((DoubleTag)inbt).m_7061_() == ((DoubleTag)tested).m_7061_()) {
                    yield true;
                }
                yield false;
            }
            case 7 -> ((ByteArrayTag)inbt).containsAll((Collection)((ByteArrayTag)tested));
            case 8 -> inbt.m_7916_().equals(tested.m_7916_());
            case 9 -> ((ListTag)inbt).containsAll((Collection)((ListTag)tested));
            case 10 -> Utils.testNBT((CompoundTag)inbt, (CompoundTag)tested);
            case 11 -> ((IntArrayTag)inbt).containsAll((Collection)((IntArrayTag)tested));
            case 12 -> ((LongArrayTag)inbt).containsAll((Collection)((LongArrayTag)tested));
            case 99 -> ((NumericTag)inbt).m_8103_().equals(((NumericTag)tested).m_8103_());
            default -> false;
        };
    }

    public static AABB rotateBox(AABB box, Direction to) {
        return switch (to) {
            case Direction.EAST -> new AABB(box.f_82290_, box.f_82289_, -box.f_82288_, box.f_82293_, box.f_82292_, -box.f_82291_);
            case Direction.NORTH -> new AABB(-box.f_82288_, box.f_82289_, -box.f_82290_, -box.f_82291_, box.f_82292_, -box.f_82293_);
            case Direction.WEST -> new AABB(-box.f_82290_, box.f_82289_, box.f_82288_, -box.f_82293_, box.f_82292_, box.f_82291_);
            default -> new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
        };
    }

    public static boolean isResourceNameValid(String resourceLocation) {
        try {
            ResourceLocation location = new ResourceLocation(resourceLocation);
            return true;
        }
        catch (ResourceLocationException e) {
            return false;
        }
    }

    public static float getMachineBreakSpeed(MachineAppearance appearance, BlockGetter world, BlockPos pos, Player player) {
        float hardness = appearance.getHardness();
        if (hardness <= 0.0f) {
            return 0.0f;
        }
        float digSpeed = player.m_36281_((BlockState)MachineBlockState.CACHE.getUnchecked((Object)appearance));
        float canHarvest = player.m_36298_((BlockState)MachineBlockState.CACHE.getUnchecked((Object)appearance)) ? 30.0f : 100.0f;
        return digSpeed / hardness / canHarvest;
    }

    public static ItemStack makeItemStack(Item item, int amount, @Nullable CompoundTag nbt) {
        ItemStack stack = new ItemStack((ItemLike)item, amount);
        stack.m_41751_(nbt == null ? null : nbt.m_6426_());
        return stack;
    }

    public static int toInt(long l) {
        try {
            return Math.toIntExact(l);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static int toInt(float l) {
        try {
            return Math.round(l);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    public static String format(int number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String format(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String format(double number) {
        return NUMBER_FORMAT.format(number);
    }

    public static <T> T[] addToArray(T[] array, T toAdd) {
        T[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = toAdd;
        return newArray;
    }

    public static MutableComponent getBlockName(IIngredient<PartialBlockState> ingredient) {
        if (ingredient.getAll().size() == 1) {
            CustomMachine machine;
            ResourceLocation machineID;
            PartialBlockState partialBlockState = ingredient.getAll().get(0);
            if (partialBlockState.getBlockState().m_60734_() instanceof CustomMachineBlock && partialBlockState.getNbt() != null && partialBlockState.getNbt().m_128425_("machineID", 8) && (machineID = ResourceLocation.m_135820_((String)partialBlockState.getNbt().m_128461_("machineID"))) != null && (machine = CustomMachinery.MACHINES.get(machineID)) != null) {
                return (MutableComponent)machine.getName();
            }
            return partialBlockState.getName();
        }
        return Component.m_237113_((String)ingredient.toString());
    }

    public static long clamp(long value, long min, long max) {
        return value < min ? min : Math.min(value, max);
    }
}

