/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class SoundManager {
    private final BlockPos pos;
    @Nullable
    private SoundInstance sound;

    public SoundManager(BlockPos pos) {
        this.pos = pos;
    }

    @Nullable
    public ResourceLocation getSoundID() {
        return this.getSound().map(SoundInstance::m_7904_).orElse(null);
    }

    public Optional<SoundInstance> getSound() {
        return Optional.ofNullable(this.sound);
    }

    public void setSound(@Nullable SoundEvent sound) {
        this.stop();
        if (sound == null) {
            this.sound = null;
            return;
        }
        this.sound = new SimpleSoundInstance(sound, SoundSource.BLOCKS, 1.0f, 1.0f, RandomSource.m_216327_(), this.pos);
        this.play();
    }

    public boolean isPlaying() {
        return this.getSound().map(sound -> Minecraft.m_91087_().m_91106_().m_120403_(sound)).orElse(false);
    }

    public void play() {
        this.getSound().ifPresent(sound -> Minecraft.m_91087_().m_91106_().m_120367_(sound));
    }

    public void stop() {
        this.getSound().ifPresent(sound -> Minecraft.m_91087_().m_91106_().m_120399_(sound));
    }
}

